#ifndef DEF_ISING_MODEL
#define DEF_ISING_MODEL

#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../str/Thread_Options.hh"
#include <vector>

class Ising_Model { /*model of unfolded state*/
private:
   int oX7;                         //maximum number of confs per residue
   std::vector<int> o_R0nX7;        //number of confs
   std::vector<double> o_R0X7e;     //energy 1-bod
   std::vector<double> o_R0X7X7e;   //energy 2-bod
   std::vector<double> o_R0X7p;     //probability 1-bod
   std::vector<double> o_R0X7X7p;   //probability 2-bod
   std::vector<double> o_R0X7z;     //sum of partial products
   std::vector<double> o_R0X7q;     //sum of partial products

   int& R0nX7(int iR0){
      return o_R0nX7.at(iR0);
   }
   double& R0X7e(int iR0,int iX7){
      return o_R0X7e.at(iR0*oX7+iX7);
   }
   double& R0X7X7e(int iR0,int jX7,int iX7){
      return o_R0X7X7e.at(iR0*oX7*oX7 +jX7*oX7 +iX7);
   }
   double& R0X7p(int iR0,int iX7){
      return o_R0X7p.at(iR0*oX7+iX7);
   }
   double& R0X7X7p(int iR0,int jX7,int iX7){
      return o_R0X7X7p.at(iR0*oX7*oX7 +jX7*oX7 +iX7);
   }
   double& R0X7z(int iR0,int iX7){
      return o_R0X7z.at(iR0*oX7+iX7);
   }
   double& R0X7q(int iR0,int iX7){
      return o_R0X7q.at(iR0*oX7+iX7);
   }

public:
   double G;                        //free energy
   double S;                        //entropy

   Ising_Model(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const Structure& str);

};

#endif
