#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../glo/Ising_Model.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>

class MEM_Ising_Model {
private:
   std::vector<int> o_R0L3;         //
   std::vector<int> o_R0L4;         //
public:
   MEM_Ising_Model(int o):
      o_R0L3(o,-1),
      o_R0L4(o,-1)
   {
   }
   int& R0L3(int i){
      return o_R0L3.at( i);  }
   int& R0L4(int i){
      return o_R0L4.at( i);  }
};

Ising_Model::Ising_Model(const DAT_PHYSICS_CONSTS& physics_consts,
                         const DAT_ENERGY_PARAMS& energy_params,
                         const Structure& str){
   oX7=88;
   int oL3=energy_params.oL3;
   int oL4=energy_params.oL4;
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   MEM_Ising_Model vv(oR0);
   double ekT= (physics_consts.ekT/energy_params.sta( 4));

   for(int iR0= 0;iR0<oR0;iR0++){
      char c1=str.R0[iR0].c1;
      std::string aa=str.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      if      ( c1=='a'||
                c1=='e' ){
         if      ( aa=="CYS " ){
            aa="CYH ";
         }else if( aa=="HPR " ){
            aa="PRO ";
         }else if( aa=="ACE " ){
            aa="ALA ";
         }else if( aa=="NME " ){
            aa="ALA ";
         }
         int iL3=-1;
         for(int jL3= 0;jL3<oL3;jL3++){
            if( energy_params.L3[jL3].aa==aa )iL3=jL3;
         }
         if( iL3==-1 ){
            G= (0.00);
            S= (1.00);
            return;
         }else{
            vv.R0L3(iR0)=iL3;
         }
      }else if( c1=='r'||
                c1=='b'||
                c1=='p' ){
         int iL4=-1;
         for(int jL4= 0;jL4<oL4;jL4++){
            if( energy_params.L4[jL4].aa==aa )iL4=jL4;
         }
         if( iL4==-1 ){
            G= (0.00);
            S= (1.00);
            return;
         }else{
            vv.R0L4(iR0)=iL4;
         }
      }else if( c1=='s' ){
      }
   }
//
//
// load residue ising model with residue impulses
//
   o_R0nX7.resize(oR0);
   o_R0X7e.resize(oR0*oX7,(0.00));
   o_R0X7X7e.resize(oR0*oX7*oX7,(0.00));
   G= (0.00);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      char c1=str.R0[mR0].c1;
      if      ( c1=='a'||
                c1=='e' ){
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL3=vv.R0L3(iR0  );
            int iX7min=energy_params.L3[iL3].X7a;
            int iX7max=(iX7min-1+energy_params.L3[iL3].cX7);
            for(int iX7=iX7min;iX7<=iX7max;iX7++){
               R0X7e(iR0,iX7-iX7min)= energy_params.X7e(iX7);
            }
            R0nX7(iR0)=(iX7max-iX7min+1);
//
// protect against exp(-e/kT)= inf
            iX7max-=(iX7min-1);
            double z= (0.00);
            for(int iX7= 0;iX7<iX7max;iX7++){
               if( R0X7e(iR0,iX7)<z )z= R0X7e(iR0,iX7);
            }
            if( z<(-100.00) ){
               G+=z;
               for(int iX7= 0;iX7<iX7max;iX7++){
                 R0X7e(iR0,iX7)-=z;
               }
            }
         }
         for(int iR0=(mR0+1);iR0<=nR0;iR0++){
            int jL3=vv.R0L3(iR0-1);
            int iL3=vv.R0L3(iR0  );
            int jX7min=energy_params.L3[jL3].X7a;
            int jX7max=(jX7min-1+energy_params.L3[jL3].cX7);
            int iX7min=energy_params.L3[iL3].X7a;
            int iX7max=(iX7min-1+energy_params.L3[iL3].cX7);
            for(int jX7=jX7min;jX7<=jX7max;jX7++){
               for(int iX7=iX7min;iX7<=iX7max;iX7++){
                  R0X7X7e(iR0,jX7-jX7min,iX7-iX7min)=
                          energy_params.X7X7e(jX7,iX7);
               }
            }
//
// protect against exp(-e/kT)= inf
            iX7max-=(iX7min-1);
            jX7max-=(jX7min-1);
            double z= (0.00);
            for(int jX7= 0;jX7<jX7max;jX7++){
               for(int iX7= 0;iX7<iX7max;iX7++){
                  if( R0X7X7e(iR0,jX7,iX7)<z )z= R0X7X7e(iR0,jX7,iX7);
               }
            }
            if( z<(-100.00) ){
               G+=z;
               for(int jX7= 0;jX7<jX7max;jX7++){
                  for(int iX7= 0;iX7<iX7max;iX7++){
                     R0X7X7e(iR0,jX7,iX7)-=z;
                  }
               }
            }
         }
      }else if( c1=='r'||
                c1=='b'||
                c1=='p' ){
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL4=vv.R0L4(iR0  );
            int iY7min=energy_params.L4[iL4].Y7a;
            int iY7max=(iY7min-1+energy_params.L4[iL4].cY7);
            for(int iY7=iY7min;iY7<=iY7max;iY7++){
               R0X7e(iR0,iY7-iY7min)= energy_params.Y7e(iY7);
            }
            R0nX7(iR0)=(iY7max-iY7min+1);
//
// protect against exp(-e/kT)= inf
            iY7max-=(iY7min-1);
            double z= (0.00);
            for(int iY7= 0;iY7<iY7max;iY7++){
               if( R0X7e(iR0,iY7)<z )z= R0X7e(iR0,iY7);
            }
            if( z<(-100.00) ){
               G+=z;
               for(int iY7= 0;iY7<iY7max;iY7++){
                 R0X7e(iR0,iY7)-=z;
               }
            }
         }
         for(int iR0=(mR0+1);iR0<=nR0;iR0++){
            int jX7max=R0nX7(iR0-1);
            int iX7max=R0nX7(iR0  );
            for(int jX7= 0;jX7<jX7max;jX7++){
               for(int iX7= 0;iX7<iX7max;iX7++){
                  R0X7X7e(iR0,jX7,iX7)= (0.00);
               }
            }
         }
      }else if( c1=='s' ){
      }
   }
//
//
// set residue probabilities
//
   o_R0X7p.resize(oR0*oX7,(1.00));
   o_R0X7X7p.resize(oR0*oX7*oX7,(1.00));
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iX7max=R0nX7(iR0  );
         double z= (0.00);
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7p(iR0,iX7)= std::exp( -R0X7e(iR0,iX7)/ekT);
            z+=R0X7p(iR0,iX7);
         }
         G-=(ekT*std::log( z));
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7p(iR0,iX7)/=z;
            R0X7p(iR0,iX7)= std::sqrt( R0X7p(iR0,iX7));
         }
      }
      for(int iR0=(mR0+1);iR0<=nR0;iR0++){
         int jX7max=R0nX7(iR0-1);
         int iX7max=R0nX7(iR0  );
         double z= (0.00);
         for(int jX7= 0;jX7<jX7max;jX7++){
            for(int iX7= 0;iX7<iX7max;iX7++){
               R0X7X7p(iR0,jX7,iX7)=
                   std::exp( -R0X7X7e(iR0,jX7,iX7)/ekT);
               z+=R0X7X7p(iR0,jX7,iX7);
            }
         }
         G-=(ekT*std::log( z));
         for(int jX7= 0;jX7<jX7max;jX7++){
            for(int iX7= 0;iX7<iX7max;iX7++){
               R0X7X7p(iR0,jX7,iX7)/=z;
               R0X7X7p(iR0,jX7,iX7)*= (R0X7p(iR0-1,jX7)*R0X7p(iR0  ,iX7));
            }
         }
      }
   }
//
//
// evaluate partition function
//
   o_R0X7z.resize(oR0*oX7,(0.00));
   o_R0X7q.resize(oR0*oX7,(0.00));
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);

      double gb= (0.00);
      int iX7max=R0nX7(nR0  );
      for(int iX7= 0;iX7<iX7max;iX7++){
         R0X7z(nR0,iX7)= R0X7p(nR0,iX7);
      }
      for(int iR0=(nR0-1);iR0>=mR0;iR0--){
         iX7max=R0nX7(iR0  );
         int jX7max=R0nX7(iR0+1);
         double z= (0.00);
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7z(iR0,iX7)= (0.00);
            for(int jX7= 0;jX7<jX7max;jX7++){
               R0X7z(iR0,iX7)+=(R0X7X7p(iR0+1,iX7,jX7)*R0X7z(iR0+1,jX7));
            }
            z+=R0X7z(iR0,iX7);
         }
         gb-=(ekT*std::log( z));
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7z(iR0,iX7)/=z;
         }
      }
      iX7max=R0nX7(mR0  );
      double z= (0.00);
      for(int iX7= 0;iX7<iX7max;iX7++){
         z+=(R0X7p(mR0,iX7)*R0X7z(mR0,iX7));
      }
      gb-=(ekT*std::log( z));
      G+=gb;

      double gf= (0.00);
      iX7max=R0nX7(mR0  );
      for(int iX7= 0;iX7<iX7max;iX7++){
         R0X7q(mR0,iX7)= R0X7p(mR0,iX7);
      }
      for(int iR0=(mR0+1);iR0<=nR0;iR0++){
         int jX7max=R0nX7(iR0-1);
         int iX7max=R0nX7(iR0  );
         z= (0.00);
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7q(iR0,iX7)= (0.00);
            for(int jX7= 0;jX7<jX7max;jX7++){
               R0X7q(iR0,iX7)+=(R0X7X7p(iR0,jX7,iX7)*R0X7q(iR0-1,jX7));
            }
            z+=R0X7q(iR0,iX7);
         }
         gf-=(ekT*std::log( z));
         for(int iX7= 0;iX7<iX7max;iX7++){
            R0X7q(iR0,iX7)/=z;
         }
      }
      iX7max=R0nX7(nR0  );
      z= (0.00);
      for(int iX7= 0;iX7<iX7max;iX7++){
         z+=(R0X7q(nR0,iX7)*R0X7p(nR0,iX7));
      }
      gf-=(ekT*std::log( z));
//    std::cout<< std::scientific<< std::setprecision( 3);
//    std::cout<<" gb="<< std::setw(10)<<gb
//             <<" gf="<< std::setw(10)<<gf
//             <<" G="<< std::setw(10)<<G<<'\n';
   }
//
//
// entropy
//
   S= (G/ekT);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=(mR0+1);iR0<=nR0;iR0++){
         int jX7max=R0nX7(iR0-1);
         int iX7max=R0nX7(iR0  );
         double z= (0.00);
         for(int jX7= 0;jX7<jX7max;jX7++){
            for(int iX7= 0;iX7<iX7max;iX7++){
               z+=( R0X7X7p(iR0,jX7,iX7)
                   *R0X7q(iR0-1,jX7)*R0X7z(iR0,iX7) );
            }
         }
         for(int jX7= 0;jX7<jX7max;jX7++){
            for(int iX7= 0;iX7<iX7max;iX7++){
               double p= R0X7X7p(iR0,jX7,iX7);
               if( p<(1.00e-256) )continue;
               S+=( (p*R0X7q(iR0-1,jX7)*R0X7z(iR0,iX7)/z)
                     *std::log( p) );
            }
         }

         iX7max=R0nX7(mR0  );
         z= (0.00);
         for(int iX7= 0;iX7<iX7max;iX7++){
            z+=( R0X7q(mR0,iX7)*R0X7z(mR0,iX7) );
         }
         for(int iX7= 0;iX7<iX7max;iX7++){
            double p= R0X7p(mR0,iX7);
            if( p<(1.00e-256) )continue;
            S+=( (R0X7q(mR0,iX7)*R0X7z(mR0,iX7)/z)
                *std::log( p) );
         }

         iX7max=R0nX7(nR0  );
         z= (0.00);
         for(int iX7= 0;iX7<iX7max;iX7++){
            z+=( R0X7q(nR0,iX7)*R0X7z(nR0,iX7) );
         }
         for(int iX7= 0;iX7<iX7max;iX7++){
            double p= R0X7p(nR0,iX7);
            if( p<(1.00e-256) )continue;
            S+=( (R0X7q(nR0,iX7)*R0X7z(nR0,iX7)/z)
                *std::log( p) );
         }
      }
   }
   S*=(-ekT);
//
//
// reference energies
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      char c1=str.R0[mR0].c1;
      if      ( c1=='a'||
                c1=='e' ){
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL3=vv.R0L3(iR0  );
            G+=energy_params.sta( 7+iL3);
         }
      }else if( c1=='r'||
                c1=='b'||
                c1=='p' ){
      }else if( c1=='s' ){
      }
   }
//
//
// correction for ionization state of unfolded
//
   double pH= (7.00);           //pH
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=str.R0[iR0].aa;
         std::string ab=str.R0[iR0].aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         if      ( aa[0]=='z' ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 7.50 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( aa[0]=='e' ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 7.50 -pH);
            if( dG<(0.00) )G-=dG;
         }
         if      ( ab=="ASP " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 4.00 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="ASZ " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 4.00 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="GLU " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 4.40 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="GLZ " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 4.40 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="HIS " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 6.30 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="HIE " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 6.30 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="HIP " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 6.30 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="TYR " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 9.60 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="TYZ " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 9.60 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="LYS " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*(10.50 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="LYZ " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*(10.50 -pH);
            if( dG>(0.00) )G+=dG;
         }else if( ab=="CYH " ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 8.28 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( ab=="CYZ " ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 8.28 -pH);
            if( dG>(0.00) )G+=dG;
         }
         if      ( aa[3]=='z' ){ //observed protonation state DH <-- D + H
            double dG= (2.303)*physics_consts.ekT*( 3.80 -pH);
            if( dG<(0.00) )G-=dG;
         }else if( aa[3]=='e' ){ //observed protonation state DH --> D + H
            double dG= (2.303)*physics_consts.ekT*( 3.80 -pH);
            if( dG>(0.00) )G+=dG;
         }
      }
   }
}
