#include "../glo/Glo_Automatic.hh"
#include <string>
#include <vector>

class MEM_Glo_Automatic {
public:
   std::vector<int> o_D2I3a;            //start index of confs within threshold
   std::vector<int> o_D2cI3;            //number of confs within threshold
   std::vector<int> o_D2I3b;            //start index of higher neighbor confs
   std::vector<int> o_D2dI3;            //number of lower neighbor confs
   std::vector<int> o_I3D2;             //mapping to index of neighbor conf
   std::vector<int> o_D3I3a;            //start index of confs within threshold
   std::vector<int> o_D3cI3;            //number of confs within threshold
   std::vector<int> o_D3I3b;            //start index of higher neighbor confs
   std::vector<int> o_D3dI3;            //number of lower neighbor confs
   std::vector<int> o_I3D3;             //mapping to index of neighbor conf
   std::vector<int> o_D2ord;            //
   std::vector<int> o_D2inv;            //
   std::vector<int> o_D3ord;            //
   std::vector<int> o_D3inv;            //
   MEM_Glo_Automatic(){
   }
   int& D2I3a(int i){
      return o_D2I3a.at( i);  }
   int& D2cI3(int i){
      return o_D2cI3.at( i);  }
   int& D2I3b(int i){
      return o_D2I3b.at( i);  }
   int& D2dI3(int i){
      return o_D2dI3.at( i);  }
   int& I3D2(int i){
      return o_I3D2.at( i);  }
   int& D3I3a(int i){
      return o_D3I3a.at( i);  }
   int& D3cI3(int i){
      return o_D3cI3.at( i);  }
   int& D3I3b(int i){
      return o_D3I3b.at( i);  }
   int& D3dI3(int i){
      return o_D3dI3.at( i);  }
   int& I3D3(int i){
      return o_I3D3.at( i);  }
   int& D2ord(int i){
      return o_D2ord.at( i);  }
   int& D2inv(int i){
      return o_D2inv.at( i);  }
   int& D3ord(int i){
      return o_D3ord.at( i);  }
   int& D3inv(int i){
      return o_D3inv.at( i);  }
};
//
//
// D2
//
void Glo_Automatic::tD2::operator=(tD2& a){
   int oR1=R1.size();
   int oZ2=o_Z2iD1.size();
   int oU2=o_U2chi.size();
   for(int iR1= 0;iR1<oR1;iR1++){
      R1[iR1]=a.R1[iR1];
   }
   for(int iZ2= 0;iZ2<oZ2;iZ2++){
      Z2iD1(iZ2)=a.Z2iD1(iZ2);
   }
   for(int iU2= 0;iU2<oU2;iU2++){
      U2chi(iU2)= a.U2chi(iU2);
   }
   star=a.star;
   bord=a.bord;
   for(int i=0;i<7;i++){
      f[i]= a.f[i];
   }
   return;
}
void Glo_Automatic::tD2::swap(tD2& a){
   int oR1=R1.size();
   int oZ2=o_Z2iD1.size();
   int oU2=o_U2chi.size();
   for(int iR1= 0;iR1<oR1;iR1++){
      R1[iR1].swap( a.R1[iR1]);
   }
   for(int iZ2= 0;iZ2<oZ2;iZ2++){
      int j=Z2iD1(iZ2);
      Z2iD1(iZ2)=a.Z2iD1(iZ2);
      a.Z2iD1(iZ2)=j;
   }
   for(int iU2= 0;iU2<oU2;iU2++){
      double z= U2chi(iU2);
      U2chi(iU2)= a.U2chi(iU2);
      a.U2chi(iU2)= z;
   }
   int k=star;
   star=a.star;
   a.star=k;
   k=bord;
   bord=a.bord;
   a.bord=k;
   for(int i=0;i<7;i++){
      double z= f[i];
      f[i]= a.f[i];
      a.f[i]= z;
   }
   return;
}
//
//
// Y3 Y3Y3
//
void Glo_Automatic::tY3::normalize(){
   double e= C2e( 0);
   for(int iC2= 1;iC2<cC2;iC2++){
      if( C2e(iC2)<e )e= C2e(iC2);
   }
   for(int iC2= 0;iC2<cC2;iC2++){
      C2e(iC2)-=e;
   }
   return;
}
void Glo_Automatic::tY3Y3::normalize(){
   int n=o_C2C2e.size();
   double e= o_C2C2e[ 0];
   for(int i=1;i<n;i++){
      if( o_C2C2e[i]<e )e= o_C2C2e[i];
   }
   for(int i=0;i<n;i++){
      if( o_C2C2e[i]<(1.00e+8) )o_C2C2e[i]-=e;
   }
   n=o_C2z.size();
   for(int iC2=0;iC2<n;iC2++){
      if( C2z(iC2)<(1.00e+8) )C2z(iC2)-=e;
   }
   if( z<(1.00e+8) )z-=e;
   return;
}
//
//
// D3
//
void Glo_Automatic::tD3::operator=(tD3& a){
   int oY3=o_Y3iC2.size();
   int oU2=o_U2chi.size();
   for(int iY3= 0;iY3<oY3;iY3++){
      Y3iC2(iY3)=a.Y3iC2(iY3);
   }
   for(int iU2= 0;iU2<oU2;iU2++){
      U2chi(iU2)= a.U2chi(iU2);
   }
   for(int i=0;i<7;i++){
      f[i]= a.f[i];
   }
   return;
}
void Glo_Automatic::tD3::swap(tD3& a){
   int oY3=o_Y3iC2.size();
   int oU2=o_U2chi.size();
   for(int iY3= 0;iY3<oY3;iY3++){
      int j=Y3iC2(iY3);
      Y3iC2(iY3)=a.Y3iC2(iY3);
      a.Y3iC2(iY3)=j;
   }
   for(int iU2= 0;iU2<oU2;iU2++){
      double z= U2chi(iU2);
      U2chi(iU2)= a.U2chi(iU2);
      a.U2chi(iU2)= z;
   }
   for(int i=0;i<7;i++){
      double z= f[i];
      f[i]= a.f[i];
      a.f[i]= z;
   }
   return;
}
//
//
// class functions
//
void Glo_Automatic::CLUSTER(const std::string& MODE,
                            int oU2){
   MEM_Glo_Automatic vv;
   if      ( MODE=="bb " ){
      int pD2=(D2.size()/2);
      int mD2=( nD2>pD2 )? pD2: 0;
      int oD2=(nD2-mD2);
      vv.o_D2I3a.resize(oD2);
      vv.o_D2cI3.resize(oD2, 0);
      vv.o_D2I3b.resize(oD2);
      vv.o_D2dI3.resize(oD2, 0);

      int mI3=0;
      for(int aD2=mD2;aD2<nD2;aD2++){
         vv.D2I3a(aD2-mD2)=mI3;
         int n=vv.D2cI3(aD2-mD2);
         for(int i=0;i<n;i++){
            vv.o_I3D2.push_back(-1);
            mI3++;
         }
         vv.D2I3b(aD2-mD2)=mI3;
         for(int bD2=(aD2+1);bD2<nD2;bD2++){
            bool NEIGHBOR=true;
            double RR= (0.00);
            for(int iU2= 0;iU2<oU2;iU2++){
               double z=( D2[bD2].U2chi(iU2)
                         -D2[aD2].U2chi(iU2));
               if      ( z>( 180.) ){
                  z-=(360.);
               }else if( z<(-180.) ){
                  z+=(360.);
               }
               RR+=(z*z);
               if( (RR/oU2)>(64.00) ){
                  NEIGHBOR=false;
                  break;
               }
            }
            if( NEIGHBOR ){
               vv.o_I3D2.push_back(bD2);
               mI3++;
               vv.D2cI3(aD2-mD2)++;
               vv.D2cI3(bD2-mD2)++;
            }
         }
      }

      for(int aD2=mD2;aD2<(nD2-1);aD2++){
         int iI3min=vv.D2I3b(aD2-mD2);
         int iI3max=(vv.D2I3a(aD2-mD2)-1+vv.D2cI3(aD2-mD2));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int bD2=vv.I3D2(iI3);
            vv.I3D2(vv.D2I3a(bD2-mD2)+vv.D2dI3(bD2-mD2))=aD2;
            vv.D2dI3(bD2-mD2)++;
         }
      }

      pD2=mD2;
      for(int aD2=mD2;aD2<nD2;aD2++){
         int aI3=vv.D2cI3(aD2-mD2);
         bool DENSITYMAX=true;
         int iI3min=vv.D2I3a(aD2-mD2);
         int iI3max=(iI3min-1+vv.D2cI3(aD2-mD2));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int bD2=vv.I3D2(iI3);
            int bI3=vv.D2cI3(bD2-mD2);
            if( (bI3<aI3)||((bI3==aI3)&&(bD2>aD2)) )continue;
            DENSITYMAX=false;
            break;
         }
         if( DENSITYMAX ){
            D2[pD2++]=D2[aD2];
         }
      }
      nD2=pD2;

   }else if( MODE=="sc " ){
      int oD3=nD3;
      vv.o_D3I3a.resize(oD3);
      vv.o_D3cI3.resize(oD3, 0);
      vv.o_D3I3b.resize(oD3);
      vv.o_D3dI3.resize(oD3, 0);

      int mI3=0;
      for(iD3= 0;iD3<oD3;iD3++){
         vv.D3I3a(iD3)=mI3;
         int n=vv.D3cI3(iD3);
         for(int i=0;i<n;i++){
            vv.o_I3D3.push_back(-1);
            mI3++;
         }
         vv.D3I3b(iD3)=mI3;
         for(int jD3=(iD3+1);jD3<oD3;jD3++){
            bool NEIGHBOR=true;
            double RR= (0.00);
            for(int iU2= 0;iU2<oU2;iU2++){
               double z=( D3[jD3].U2chi(iU2)
                         -D3[iD3].U2chi(iU2));
               if      ( z>( 180.) ){
                  z-=(360.);
               }else if( z<(-180.) ){
                  z+=(360.);
               }
               RR+=(z*z);
               if( (RR/oU2)>(64.00) ){
                  NEIGHBOR=false;
                  break;
               }
            }
            if( NEIGHBOR ){
               vv.o_I3D3.push_back(jD3);
               mI3++;
               vv.D3cI3(iD3)++;
               vv.D3cI3(jD3)++;
            }
         }
      }

      for(iD3= 0;iD3<(oD3-1);iD3++){
         int iI3min=vv.D3I3b(iD3);
         int iI3max=(vv.D3I3a(iD3)-1+vv.D3cI3(iD3));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int jD3=vv.I3D3(iI3);
            vv.I3D3(vv.D3I3a(jD3)+vv.D3dI3(jD3))=iD3;
            vv.D3dI3(jD3)++;
         }
      }

      nD3=0;
      for(iD3= 0;iD3<oD3;iD3++){
         int aI3=vv.D3cI3(iD3);
         bool DENSITYMAX=true;
         int iI3min=vv.D3I3a(iD3);
         int iI3max=(iI3min-1+vv.D3cI3(iD3));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int jD3=vv.I3D3(iI3);
            int bI3=vv.D3cI3(jD3);
            if( (bI3<aI3)||((bI3==aI3)&&(jD3>iD3)) )continue;
            DENSITYMAX=false;
            break;
         }
         if( DENSITYMAX ){
            D3[nD3++]=D3[iD3];
         }
      }

   }else if( MODE=="lp " ){
   }
   return;
}

void Glo_Automatic::ORDER(const std::string& MODE){
   MEM_Glo_Automatic vv;
   if      ( MODE=="bb " ){
      int pD2=(D2.size()/2);
      int mD2=( nD2>pD2 )? pD2: 0;
      int oD2=(nD2-mD2);
      vv.o_D2ord.resize(oD2);
      vv.o_D2inv.resize(oD2);

      for(int aD2= 0;aD2<oD2;aD2++){
         vv.D2ord(aD2)=aD2;
      }

      for(int bD2max=(oD2-1);bD2max> 0;bD2max--){
         bool ORDERED=true;
         double z1= D2[vv.D2ord( 0)+mD2].f[0];
         for(int bD2= 1;bD2<=bD2max;bD2++){
            double z2= D2[vv.D2ord(bD2)+mD2].f[0];
            if( z2<z1 ){
               int L=vv.D2ord(bD2);
               vv.D2ord(bD2)=vv.D2ord(bD2-1);
               vv.D2ord(bD2-1)=L;
               ORDERED=false;
            }else{
               z1= z2;
            }
         }
         if( ORDERED )break;
      }

      for(int aD2= 0;aD2<oD2;aD2++){
         vv.D2inv(vv.D2ord(aD2))=aD2;
      }
      double Eglo=( oD2>0 )? D2[vv.D2ord( 0)+mD2].f[0]: (0.00);
      double Ecut=( Eglo +(128.00));

      for(int aD2= 0;aD2<oD2;aD2++){
         int bD2=vv.D2ord(aD2);
         int kD2=vv.D2inv(aD2);
         if( bD2==aD2 )continue;
         D2[aD2+mD2].swap(D2[bD2+mD2]);
         vv.D2ord(aD2)=aD2;
         vv.D2inv(aD2)=aD2;
         vv.D2ord(kD2)=bD2;
         vv.D2inv(bD2)=kD2;
         if( D2[aD2+mD2].f[0]<Ecut )nD2=(aD2+mD2+1);
      }

   }else if( MODE=="sc " ){
      int oD3=nD3;
      vv.o_D3ord.resize(oD3);
      vv.o_D3inv.resize(oD3);

      for(iD3= 0;iD3<oD3;iD3++){
         vv.D3ord(iD3)=iD3;
      }

      for(int jD3max=(oD3-1);jD3max> 0;jD3max--){
         bool ORDERED=true;
         double z1= D3[vv.D3ord( 0)].f[0];
         for(int jD3= 1;jD3<=jD3max;jD3++){
            double z2= D3[vv.D3ord(jD3)].f[0];
            if( z2<z1 ){
               int L=vv.D3ord(jD3);
               vv.D3ord(jD3)=vv.D3ord(jD3-1);
               vv.D3ord(jD3-1)=L;
               ORDERED=false;
            }else{
               z1= z2;
            }
         }
         if( ORDERED )break;
      }

      for(iD3= 0;iD3<oD3;iD3++){
         vv.D3inv(vv.D3ord(iD3))=iD3;
      }
      double Eglo=( oD3>0 )? D3[vv.D3ord( 0)].f[0]: (0.00);
      double Ecut=( Eglo +(16.00));

      for(iD3= 0;iD3<oD3;iD3++){
         int jD3=vv.D3ord(iD3);
         int kD3=vv.D3inv(iD3);
         D3[iD3].swap(D3[jD3]);
         vv.D3ord(iD3)=iD3;
         vv.D3inv(iD3)=iD3;
         vv.D3ord(kD3)=jD3;
         vv.D3inv(jD3)=kD3;
         if( D3[iD3].f[0]<Ecut )nD3=(iD3+1);
      }
      if( nD3>20 )nD3=20;

   }else if( MODE=="lp " ){
   }
   return;
}

void Glo_Automatic::INSERT(const std::string& MODE){
   MEM_Glo_Automatic vv;
   if      ( MODE=="bb " ){
      int oD2=(D2.size()/2);
      vv.o_D2ord.resize(oD2);

      for(int aD2= 0;aD2<oD2;aD2++){
         vv.D2ord(aD2)=aD2;
      }

      for(int bD2=oD2;bD2<nD2;bD2++){
         if( D2[bD2].f[0]<D2[vv.D2ord(oD2-1)].f[0] ){
            vv.D2ord(oD2-1)=bD2;
            for(int aD2=(oD2-1);aD2> 0;aD2--){
               if( D2[vv.D2ord(aD2)].f[0]>=D2[vv.D2ord(aD2-1)].f[0] )break;
               int j=vv.D2ord(aD2-1);
               vv.D2ord(aD2-1)=vv.D2ord(aD2);
               vv.D2ord(aD2)=j;
            }
         }
      }

      nD2=oD2;
      for(int aD2=(oD2-1);aD2>=0;aD2--){
         int bD2=vv.D2ord(aD2);
         D2[aD2]=D2[bD2];
         if( D2[aD2].f[0]>=(1.00e+8) )nD2=aD2;
      }

   }else if( MODE=="sc " ){
   }else if( MODE=="lp " ){
   }
   return;
}
