#ifndef DEF_GLO
#define DEF_GLO

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"

class Glo {
public:
   void GLO(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_DISULFIDE_LINKS& disulfide_links,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const DAT_REGION_MAPS& region_maps,
            const DAT_DEFORM_PARAMS& deform_params,
            Thread_Options& opt,
            Output_Streams& out,
            Structure& str,
            Search_Subspace& sub,
            Family& fam,
            const Distance_Constraints& dst);

   void GLO_Q2(Glo_Automatic& aut,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const Thread_Options& opt,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep,
               Energy_Surface4& ene);

   void GLO_U2(Glo_Automatic& aut,
               const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const Thread_Options& opt,
               const Backbone_Defs& def,
               const Search_Subspace& sub,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               const Conf_Dependent_System& dep,
               Energy_Surface4& ene,
               Local_Minimization4& loc);

   void GLO_F2(const Glo_Automatic& aut,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);

   void GLO_A5(Glo_Automatic& aut,
               Dielec_Continu& med,
               const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);

   void GLO_DEF(Glo_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const DAT_REGION_MAPS& region_maps,
                const DAT_DEFORM_PARAMS& deform_params,
                const Thread_Options& opt,
                Output_Streams& out,
                Backbone_Defs& def,
                const Structure& str,
                const Search_Subspace& sub,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep,
                Energy_Surface4& ene,
                Local_Minimization4& loc);

   void GLO_BBPCK(Glo_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_REGION_MAPS& region_maps,
                  const Thread_Options& opt,
                  Output_Streams& out,
                  const Structure& str,
                  const Search_Subspace& sub,
                  Backbone_Defs& def,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Local_Minimization4& loc);

   void GLO_SCPCK(Glo_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_REGION_MAPS& region_maps,
                  const Thread_Options& opt,
                  Output_Streams& out,
                  const Structure& str,
                  const Search_Subspace& sub,
                  Backbone_Defs& def,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Local_Minimization4& loc);

   void GLO_CHI(const Glo_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Thread_Options& opt,
                const Search_Subspace& sub,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep,
                Energy_Surface4& ene,
                const Backbone_Defs& def,
                bool LATTICE);

   void GLO_WRT(Glo_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const DAT_REGION_MAPS& region_maps,
                const Thread_Options& opt,
                const Search_Subspace& sub,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep,
                Energy_Surface4& ene,
                Backbone_Defs& def);

   void GLO_STEP(Glo_Automatic& aut,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_REGION_MAPS& region_maps,
                 const Thread_Options& opt,
                 Output_Streams& out,
                 Structure& str,
                 const Search_Subspace& sub,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep,
                 Backbone_Defs& def);

   void GLO_DEF2STR(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out,
                    Structure& str,
                    Search_Subspace& sub,
                    const Backbone_Defs& def);

   Glo(){}
};

#endif
