#ifndef DEF_BACKBONE_DEFS
#define DEF_BACKBONE_DEFS

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Backbone_Defs {
public:
   class tZ0 { /*chain translation +rotation*/
   public:
      Coordinates trans;        //translation (bohr)
      Coordinates rot;          //rotation (radian)
      tZ0(){}
      void operator=(const tZ0& a);
      void swap(tZ0& a);
   };
   class tR1 { /*residue conformation*/
   public:
      double phi;               //(degree)
      double psi;               //(degree)
      double omg;               //(degree)
      int C4;                   //conf of peptide plane
      std::string cnfa;         //region of (phi,psi) grid 4-state
      std::string cnfb;         //region of (phi,psi) grid 8-state
      double eps;               //(degree)
      double zet;               //(degree)
      double alp;               //(degree)
      double bet;               //(degree)
      double gam;               //(degree)
      double del;               //(degree)
      int C6;                   //conf of nucleotide suite
      tR1(){}
      void operator=(const tR1& a);
      void swap(tR1& a);
   };
   class tD0 { /*search subspace deformations*/
   public:
      std::vector<tZ0> Z0;              //chain translat (bohr)+rotat (radian)
      double e[20];                     //energy (kcal)
      tD0(){}
   };
   class tZ2 { /*segments deformed in a step of global minimization*/
   public:
      class tZ2D1 { /*segment backbone deformations*/
      public:
         double p;              //ising model probability
         double d;              //rmsd from starting conf
         int star;              //residues in star region
         int bord;              //residues outside low-energy region
         double r;              //rmsd of end closure
         double fg;             //energy of excluded confs
         std::vector<tR1> R1;   //sequence of residue conformations
         tZ0 tr;                //translation (bohr) +rotation (radian)

         tZ2D1(int oR1):
            p(0.00),d(0.00),star( 0),bord( 0),r(0.00),fg(0.00),
            R1(oR1)
         {
         }
      };
      class tZ2J3 { /*residue shifts in deformation*/
      public:
         int shf1;              //N-terminal shift
         int shf2;              //C-terminal shift
         tZ2J3(){}
         void operator=(const tZ2J3& a);
         void swap(tZ2J3& a);
      };

   public:
      int nR1;                  //number of residues local to segment
      std::vector<tR1> R1;      //scatch sequence of residue conformations
      int CYC;                  //start residue of segment
      int CIS;                  //local to segment position of cis-peptide
      bool CORE;                //segment is part of core
      std::vector<tZ2J3> J3;    //set of residue shifts
      int Z0;                   //{-2=internal, -1=C-terminal,
                                // chain index iZ0=N-terminal}
      Rotation_Matrix P;        //gen matrix truncating before R(psi_first)
      Rotation_Matrix Q;        //gen matrix truncating before R(psi_last)
      Coordinates y00;          //position of C_first (bohr)
      Coordinates y18;          //position of C_last (bohr)
      int nD1;                  //number
      std::vector<tZ2D1> D1;    //set of backbone deformations

      tZ2(int oR1):
         nR1(oR1),
         R1(oR1)
      {
      }
   };

private:
   std::vector<Coordinates> o_F2x;      //atom position
   Coordinates& F2x(int i){
       return o_F2x.at( i);
   }

   void SHF_SCO(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Search_Subspace& sub,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Energy_Surface4& ene,
                int iJ3);

   void DEF_SETX1(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  const Thread_Options& opt,
                  const Structure& str,
                  const Search_Subspace& sub,
                  int iZ2,int iJ3);
   void DEF_DISCE(Def_Automatic& aut,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_DEFORM_PARAMS& deform_params,
                  const Search_Subspace& sub,
                  int iZ2);
   void DEF_SETX2(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETX3(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_DISCT(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETT4(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETTH(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETX4(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_DISCP(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETX5(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  int iZ2);
   void DEF_SETSG(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  int iZ2);
   void DEF_SETPS(Def_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_DEFORM_PARAMS& deform_params,
                  const DAT_REGION_MAPS& region_maps,
                  Output_Streams& out,
                  const Structure& str,
                  const Search_Subspace& sub,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Local_Minimization4& loc,
                  int iZ2,int iJ3);
   void DEF_ZERO(Def_Automatic& aut,
                 const DAT_PHYSICS_CONSTS& physics_consts);
   double DEF_ZERO_C3(Def_Automatic& aut,
                      const DAT_PHYSICS_CONSTS& physics_consts,
                      double psi3);
   void DEF_SORT(Def_Automatic& aut,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_DEFORM_PARAMS& deform_params,
                 const DAT_REGION_MAPS& region_maps,
                 Output_Streams& out,
                 const Structure& str,
                 const Search_Subspace& sub,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep,
                 Energy_Surface4& ene,
                 Local_Minimization4& loc,
                 int iZ2,int iJ3);
   void DEF_SEGPT(const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  Output_Streams& out,
                  const Search_Subspace& sub,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Local_Minimization4& loc,
                  int iZ2,int iJ3,int iD1);
   double DEF_DEV18(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out,
                    const Structure& str,
                    const Search_Subspace& sub,
                    int iZ2,int iD1);
   void DEF_CLUST(const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_DEFORM_PARAMS& deform_params,
                  Output_Streams& out,
                  int iZ2);

public:
   int nD0;                         //number
   int iD0;                         //index
   std::vector<tD0> D0;             //set of search subspace deformations
   int oT5;                         //number of torsions in search subspace
   std::vector<double> o_D0T5chi;   //torsion angle (degree)
   bool PATCH;                      //no undeformed structure
   int nZ2;                         //number
   std::vector<tZ2> Z2;             //set of backbone segments
   bool CORE;                       //all deformable segments are part of core
   double RRchar;                   //threshold dist squared in torsion space
   double TEMP;                     //kT
   int nJ3;                         //number of shifts
   int ENDSTATE;                    //return value from DEF

   double& D0T5chi(int i,int j){
      return o_D0T5chi.at( i*oT5 +j);
   }
   const double& D0T5chi(int i,int j) const {
      return o_D0T5chi.at( i*oT5 +j);
   }

   void CLUSTER(int oU2);
   void ORDER();
   void PRINT(const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_RESIDUE_MAPPINGS& residue_mappings,
              const DAT_REGION_MAPS& region_maps,
              Output_Streams& out,
              const Search_Subspace& sub,
              const std::string& MODE);
   void SHF(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            Output_Streams& out,
            const Search_Subspace& sub,
            const Mechanical_System& mol,
            const Subset_Contracted_System::tM3& con,
            Conf_Dependent_System& dep,
            Energy_Surface4& ene);
   void DEF(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const DAT_DEFORM_PARAMS& deform_params,
            const DAT_REGION_MAPS& region_maps,
            const Thread_Options& opt,
            Output_Streams& out,
            const Structure& str,
            const Search_Subspace& sub,
            const Mechanical_System& mol,
            const Subset_Contracted_System::tM3& con,
            Conf_Dependent_System& dep,
            Energy_Surface4& ene,
            Local_Minimization4& loc,
            int iZ2,int iJ3);

   Backbone_Defs(const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_DEFORM_PARAMS& deform_params,
                 const Structure& str,
                 const Search_Subspace& sub);
   Backbone_Defs(){}
};

#endif
