#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_Backbone_Defs {
public:
   std::vector<int> o_Z2n;              //allow shift at junction (iZ2,iZ2+1)
   std::vector<int> o_Z2i;              //index for combinatorial shift
   std::vector<int> o_D0I3a;            //start index of confs within threshold
   std::vector<int> o_D0cI3;            //number of confs within threshold
   std::vector<int> o_D0I3b;            //start index of higher neighbor confs
   std::vector<int> o_D0dI3;            //number of lower neighbor confs
   std::vector<int> o_I3D0;             //mapping to index of neighbor conf
   std::vector<int> o_D0ord;            //
   std::vector<int> o_D0inv;            //
   std::vector<std::string> o_R1cnf;    //region of (phi,psi) grid
   MEM_Backbone_Defs(){
   }
   int& Z2n(int i){
      return o_Z2n.at( i);  }
   int& Z2i(int i){
      return o_Z2i.at( i);  }
   int& D0I3a(int i){
      return o_D0I3a.at( i);  }
   int& D0cI3(int i){
      return o_D0cI3.at( i);  }
   int& D0I3b(int i){
      return o_D0I3b.at( i);  }
   int& D0dI3(int i){
      return o_D0dI3.at( i);  }
   int& I3D0(int i){
      return o_I3D0.at( i);  }
   int& D0ord(int i){
      return o_D0ord.at( i);  }
   int& D0inv(int i){
      return o_D0inv.at( i);  }
   std::string& R1cnf(int i){
      return o_R1cnf.at( i);  }
};
//
//
// Z0
//
void Backbone_Defs::tZ0::operator=(const tZ0& a){
   trans=a.trans;
   rot=a.rot;
   return;
}
void Backbone_Defs::tZ0::swap(tZ0& a){
   Coordinates z=trans;
   trans=a.trans;
   a.trans=z;
   z=rot;
   rot=a.rot;
   a.rot=z;
   return;
}
//
//
// R1
//
void Backbone_Defs::tR1::operator=(const tR1& a){
   phi= a.phi;
   psi= a.psi;
   omg= a.omg;
   C4=a.C4;
   cnfa=a.cnfa;
   cnfb=a.cnfb;
   eps= a.eps;
   zet= a.zet;
   alp= a.alp;
   bet= a.bet;
   gam= a.gam;
   del= a.del;
   C6=a.C6;
   return;
}
void Backbone_Defs::tR1::swap(tR1& a){
   double z= phi;
   phi= a.phi;
   a.phi= z;
   z= psi;
   psi= a.psi;
   a.psi= z;
   z= omg;
   omg= a.omg;
   a.omg= z;
   int L=C4;
   C4=a.C4;
   a.C4=L;
   std::string c=cnfa;
   cnfa=a.cnfa;
   a.cnfa=c;
   c=cnfb;
   cnfb=a.cnfb;
   a.cnfb=c;
   z= eps;
   eps= a.eps;
   a.eps= z;
   z= zet;
   zet= a.zet;
   a.zet= z;
   z= alp;
   alp= a.alp;
   a.alp= z;
   z= bet;
   bet= a.bet;
   a.bet= z;
   z= gam;
   gam= a.gam;
   a.gam= z;
   z= del;
   del= a.del;
   a.del= z;
   L=C6;
   C6=a.C6;
   a.C6=L;
   return;
}
//
//
// Z2
//
void Backbone_Defs::tZ2::tZ2J3::operator=(const tZ2::tZ2J3& a){
   shf1=a.shf1;
   shf2=a.shf2;
   return;
}
void Backbone_Defs::tZ2::tZ2J3::swap(tZ2::tZ2J3& a){
   int L=shf1;
   shf1=a.shf1;
   a.shf1=L;
   L=shf2;
   shf2=a.shf2;
   a.shf2=L;
   return;
}
//
//
// construct
//
Backbone_Defs::Backbone_Defs(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_RESIDUE_MAPPINGS& residue_mappings,
                             const DAT_DEFORM_PARAMS& deform_params,
                             const Structure& str,
                             const Search_Subspace& sub):
      nD0( 1),
      D0(2048),
      PATCH(false)
{
   MEM_Backbone_Defs vv;
   int oZ0=str.nZ0;
   int oR1=sub.nR1;
   oT5=(sub.R1[oR1-1].T5a+sub.R1[oR1-1].cT5);
//
//
// search subspace deformations D0
//
   int oD0=D0.size();
   for(int jD0= 0;jD0<oD0;jD0++){
      D0[jD0].Z0.resize(oZ0);
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      D0[ 0].Z0[iZ0].trans=str.Z0[iZ0].trans;
      D0[ 0].Z0[iZ0].rot=str.Z0[iZ0].rot;
   }
   o_D0T5chi.resize(oD0*oT5);
   int mT5=0;
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=sub.R1[iR1].R0;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         D0T5chi( 0,iT1-mT1+mT5)= str.T1[iT1].chi;
      }
      mT5+=sub.R1[iR1].cT5;
   }
//
//
// segments deformed Z2
//
   nZ2=0;
   for(int iR1= 0;iR1<oR1;iR1++){
      if( sub.R1[iR1].pt>0 ){
         Z2.push_back( tZ2(sub.R1[iR1].pt));
         Z2[nZ2++].CYC=iR1;
      }
   }
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      Z2[iZ2].CIS=0;
      int mR1=Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      for(int iR1=(mR1+1);iR1<=nR1;iR1++){
         if( sub.R1[iR1].aa=="PRO " ){
            int jR0=(sub.R1[iR1].R0-1);
            int jT1=(str.R0[jR0].T1a+2);
            if( std::abs( str.T1[jT1].chi)<( 60.00) ){
               Z2[iZ2].CIS=(iR1-mR1);
            }
         }
      }
   }
   CORE=true;
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      int noncore=0;
      int mR1=Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      for(int iR1=mR1;iR1<=nR1;iR1++){
         int iR0=sub.R1[iR1].R0;
         if( str.R0[iR0].core!=':' )noncore++;
      }
      Z2[iZ2].CORE=( noncore>2 )? false: true;
      if( !Z2[iZ2].CORE )CORE=false;
   }
   if      ( nZ2>1 ){
      nJ3=1;
      vv.o_Z2n.resize(nZ2-1);
      for(int iZ2= 0;iZ2<(nZ2-1);iZ2++){
         if( (sub.R1[Z2[iZ2  ].CYC].pt<=11)&&
             (sub.R1[Z2[iZ2+1].CYC].pt<=11)&&
             (sub.R1[Z2[iZ2+1].CYC].Z0==sub.R1[Z2[iZ2  ].CYC].Z0) ){
            vv.Z2n(iZ2)=1;
            int iR1min=(Z2[iZ2  ].CYC+sub.R1[Z2[iZ2  ].CYC].pt);
            int iR1max=Z2[iZ2+1].CYC;
            for(int iR1=iR1min;iR1<=iR1max;iR1++){
               std::string aa=sub.R1[iR1].aa;
               if( (sub.R1[iR1  ].R0!=(sub.R1[iR1-1].R0+1))||
                   (sub.R1[iR1  ].bb==0)||
                   (aa=="PRO ")||(aa=="HPR ") ){
                  vv.Z2n(iZ2)=0;
               }
            }
            nJ3*=(2*vv.Z2n(iZ2)+1);
         }else{
            vv.Z2n(iZ2)=0;
         }
      }
      for(int iZ2= 0;iZ2<nZ2;iZ2++){
         Z2[iZ2].J3.resize(nJ3);
      }
      vv.o_Z2i.resize(nZ2-1);
      for(int iZ2= 0;iZ2<(nZ2-1);iZ2++){
         vv.Z2i(iZ2)=-vv.Z2n(iZ2)-1;
      }
      int iJ3=0;
      int iZ2=0;
      for(;;){
         vv.Z2i(iZ2)++;
         if( vv.Z2i(iZ2)>vv.Z2n(iZ2) ){
            if( iZ2==0 ){
               break;
            }else{
               vv.Z2i(iZ2)=-vv.Z2n(iZ2)-1;
               iZ2--;
               continue;
            }
         }else{
            if( iZ2==(nZ2-2) ){
               Z2[    0].J3[iJ3].shf1=0;
               Z2[nZ2-1].J3[iJ3].shf2=0;
               for(int jZ2= 0;jZ2<(nZ2-1);jZ2++){
                  Z2[jZ2  ].J3[iJ3].shf2=(2*vv.Z2i(jZ2));
                  Z2[jZ2+1].J3[iJ3].shf1=(2*vv.Z2i(jZ2));
               }
               iJ3++;
            }else{
               iZ2++;
            }
         }
      }
   }else if( nZ2>0 ){
      nJ3=1;
      Z2[ 0].J3.resize(nJ3);
      Z2[ 0].J3[ 0].shf1=0;
      Z2[ 0].J3[ 0].shf2=0;
   }
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      Z2[iZ2].Z0=-2;
      int mR1=Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      int jZ0=sub.R1[mR1].Z0;
      int jR0=sub.R1[mR1].R0;
//    int kZ0=sub.R1[nR1].Z0;
      int kR0=sub.R1[nR1].R0;
      int mR0=str.Z0[jZ0].R0a;
      int nR0=(mR0-1+str.Z0[jZ0].cR0);
      if      ( jR0==mR0 ){
         Z2[iZ2].Z0=jZ0;
      }else if( kR0==nR0 ){
         Z2[iZ2].Z0=-1;
      }else{
         for(int iR1=(mR1-1);iR1>=0;iR1--){
            if( sub.R1[iR1].Z0!=jZ0 )break;
            if( sub.R1[iR1].R0!=(sub.R1[iR1+1].R0-1) )break;
            if( sub.R1[iR1].pt>0 )break;
            if( sub.R1[iR1].bb==0 )break;
            if( sub.R1[iR1].R0==mR0 )Z2[iZ2].Z0=jZ0;
         }
         for(int iR1=(nR1+1);iR1<oR1;iR1++){
            if( sub.R1[iR1].Z0!=jZ0 )break;
            if( sub.R1[iR1].R0!=(sub.R1[iR1-1].R0+1) )break;
            if( sub.R1[iR1].pt>0 )break;
            if( sub.R1[iR1].bb==0 )break;
            if( sub.R1[iR1].R0==nR0 )Z2[iZ2].Z0=-1;
         }
      }
      if( Z2[iZ2].CORE )Z2[iZ2].Z0=-2;
   }
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      int mR1=Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      for(int iR1=mR1;iR1<=nR1;iR1++){
         int iR0=sub.R1[iR1].R0;
         char c1=str.R0[iR0].c1;
         int mT5=sub.R1[iR1].T5a;
         int nT5=(mT5-1+sub.R1[iR1].cT5);
         if( nT5>(mT5+2) )nT5=(mT5+2);
         if      ( c1=='a' ){
            for(int iT5=mT5;iT5<=nT5;iT5++){
               std::string tor=sub.T5[iT5].tor;
               if      ( tor=="PHI" ){
                  Z2[iZ2].R1[iR1-mR1].phi= D0T5chi( 0,iT5);
               }else if( tor=="PSI" ){
                  Z2[iZ2].R1[iR1-mR1].psi= D0T5chi( 0,iT5);
               }else if( tor=="OMG" ){
                  Z2[iZ2].R1[iR1-mR1].omg= D0T5chi( 0,iT5);
               }
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            for(int iT5=mT5;iT5<=nT5;iT5++){
               std::string tor=sub.T5[iT5].tor;
               if      ( tor=="BET" ){
                  Z2[iZ2].R1[iR1-mR1].bet= D0T5chi( 0,iT5);
               }else if( tor=="GAM" ){
                  Z2[iZ2].R1[iR1-mR1].gam= D0T5chi( 0,iT5);
               }else if( tor=="DEL" ){
                  Z2[iZ2].R1[iR1-mR1].del= D0T5chi( 0,iT5);
               }
            }
         }else if( c1=='b' ){
         }else if( c1=='p' ){
            for(int iT5=mT5;iT5<=nT5;iT5++){
               std::string tor=sub.T5[iT5].tor;
               if      ( tor=="EPS" ){
                  Z2[iZ2].R1[iR1-mR1].eps= D0T5chi( 0,iT5);
               }else if( tor=="ZET" ){
                  Z2[iZ2].R1[iR1-mR1].zet= D0T5chi( 0,iT5);
               }else if( tor=="ALP" ){
                  Z2[iZ2].R1[iR1-mR1].alp= D0T5chi( 0,iT5);
               }
            }
         }else if( c1=='s' ){
         }
      }
      Z2[iZ2].R1[ 0].C4=-1;
      Z2[iZ2].R1[ 0].C6=-1;
      for(int iR1=(mR1+1);iR1<=nR1;iR1++){
         int iL0=sub.R1[iR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         if      ( c1=='a' ){
            double psi= Z2[iZ2].R1[iR1-1-mR1].psi;
            double omg= Z2[iZ2].R1[iR1-1-mR1].omg;
            double phi= Z2[iZ2].R1[iR1  -mR1].phi;
            double RRmin= (1.00e+6);
            int iG4=residue_mappings.L0[iL0].G4;
            int mC4=deform_params.G4[iG4].mC4;
            int nC4=deform_params.G4[iG4].nC4;
            for(int iC4=mC4;iC4<=nC4;iC4++){
               double dpsi=( psi -deform_params.C4[iC4].psi);
               if( dpsi>( 180.00) )dpsi-=(360.00);
               if( dpsi<(-180.00) )dpsi+=(360.00);
               double domg=( omg -deform_params.C4[iC4].omg);
               if( domg>( 180.00) )domg-=(360.00);
               if( domg<(-180.00) )domg+=(360.00);
               double dphi=( phi -deform_params.C4[iC4].phi);
               if( dphi>( 180.00) )dphi-=(360.00);
               if( dphi<(-180.00) )dphi+=(360.00);
               double RR=( dpsi*dpsi +domg*domg +dphi*dphi);
               if( RR<RRmin ){
                  RRmin= RR;
                  Z2[iZ2].R1[iR1-mR1].C4=iC4;
               }
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            double eps= Z2[iZ2].R1[iR1-1-mR1].eps;
            double zet= Z2[iZ2].R1[iR1-1-mR1].zet;
            double alp= Z2[iZ2].R1[iR1-1-mR1].alp;
            double bet= Z2[iZ2].R1[iR1  -mR1].bet;
            double gam= Z2[iZ2].R1[iR1  -mR1].gam;
            double del= Z2[iZ2].R1[iR1  -mR1].del;
            double RRmin= (1.00e+6);
            for(int iC6= 0;iC6<46;iC6++){
               double deps=( eps -deform_params.C6[iC6].eps);
               if( deps>( 180.00) )deps-=(360.00);
               if( deps<(-180.00) )deps+=(360.00);
               double dzet=( zet -deform_params.C6[iC6].zet);
               if( dzet>( 180.00) )dzet-=(360.00);
               if( dzet<(-180.00) )dzet+=(360.00);
               double dalp=( alp -deform_params.C6[iC6].alp);
               if( dalp>( 180.00) )dalp-=(360.00);
               if( dalp<(-180.00) )dalp+=(360.00);
               double dbet=( bet -deform_params.C6[iC6].bet);
               if( dbet>( 180.00) )dbet-=(360.00);
               if( dbet<(-180.00) )dbet+=(360.00);
               double dgam=( gam -deform_params.C6[iC6].gam);
               if( dgam>( 180.00) )dgam-=(360.00);
               if( dgam<(-180.00) )dgam+=(360.00);
               double ddel=( del -deform_params.C6[iC6].del);
               if( ddel>( 180.00) )ddel-=(360.00);
               if( ddel<(-180.00) )ddel+=(360.00);
               double RR=( deps*deps +dzet*dzet +dalp*dalp
                          +dbet*dbet +dgam*dgam +ddel*ddel);
               if( RR<RRmin ){
                  RRmin= RR;
                  Z2[iZ2].R1[iR1-mR1].C6=iC6;
               }
            }
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
//
//
// threshold distance squared
//
   double fac=( CORE )? (0.25): (1.00);
   int npep=0;
   for(int iZ2= 0;iZ2<nZ2;iZ2++){
      if( (Z2[iZ2].nR1-1)>npep )npep=(Z2[iZ2].nR1-1);
   }
   RRchar= fac*( 2*npep)*( npep +4)*( npep +4);
   TEMP= fac*physics_consts.ekT;
}
//
//
// class functions
//
void Backbone_Defs::CLUSTER(int oU2){
   MEM_Backbone_Defs vv;
   int oD0=nD0;
   int oZ0=D0[ 0].Z0.size();

   vv.o_D0I3a.resize(oD0);
   vv.o_D0cI3.resize(oD0);
   vv.o_D0I3b.resize(oD0);
   vv.o_D0dI3.resize(oD0);

   for(int aD0= 0;aD0<oD0;aD0++){
      vv.D0cI3(aD0)=0;
      vv.D0dI3(aD0)=0;
   }

   int mI3=0;
   for(int aD0= 0;aD0<oD0;aD0++){
      vv.D0I3a(aD0)=mI3;
      int n=vv.D0cI3(aD0);
      for(int i=0;i<n;i++){
         vv.o_I3D0.push_back(-1);
         mI3++;
      }
      vv.D0I3b(aD0)=mI3;
      for(int bD0=(aD0+1);bD0<oD0;bD0++){
         bool NEIGHBOR=true;
         double RR= (0.00);
         for(int iT5= 0;iT5<oT5;iT5++){
            double z=( D0T5chi(bD0,iT5)
                      -D0T5chi(aD0,iT5));
            if      ( z>( 180.) ){
               z-=(360.);
            }else if( z<(-180.) ){
               z+=(360.);
            }
            RR+=(z*z);
            if( RR>(oU2*(36.00)) ){
               NEIGHBOR=false;
               break;
            }
         }
         if( NEIGHBOR ){
            vv.o_I3D0.push_back(bD0);
            mI3++;
            vv.D0cI3(aD0)++;
            vv.D0cI3(bD0)++;
         }
      }
   }

   for(int aD0= 0;aD0<(oD0-1);aD0++){
      int iI3min=vv.D0I3b(aD0);
      int iI3max=(vv.D0I3a(aD0)-1+vv.D0cI3(aD0));
      for(int iI3=iI3min;iI3<=iI3max;iI3++){
         int bD0=vv.I3D0(iI3);
         vv.I3D0(vv.D0I3a(bD0)+vv.D0dI3(bD0))=aD0;
         vv.D0dI3(bD0)++;
      }
   }

   nD0=0;
   for(int aD0= 0;aD0<oD0;aD0++){
      int aI3=vv.D0cI3(aD0);
      bool DENSITYMAX=true;
      int iI3min=vv.D0I3a(aD0);
      int iI3max=(iI3min-1+vv.D0cI3(aD0));
      for(int iI3=iI3min;iI3<=iI3max;iI3++){
         int bD0=vv.I3D0(iI3);
         int bI3=vv.D0cI3(bD0);
         if( (bI3<aI3)||((bI3==aI3)&&(bD0>aD0)) )continue;
         DENSITYMAX=false;
         break;
      }
      if( DENSITYMAX ){
         if( nD0!=aD0 ){
            for(int i= 0;i<20;i++){
               D0[nD0].e[i]= D0[aD0].e[i];
            }
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               D0[nD0].Z0[iZ0]= D0[aD0].Z0[iZ0];
            }
            for(int iT5= 0;iT5<oT5;iT5++){
               D0T5chi(nD0,iT5)= D0T5chi(aD0,iT5);
            }
         }
         nD0++;
      }
   }

   return;
}

void Backbone_Defs::ORDER(){
   MEM_Backbone_Defs vv;
   int oD0=nD0;
   int oZ0=D0[ 0].Z0.size();

   vv.o_D0ord.resize(oD0);
   vv.o_D0inv.resize(oD0);
   for(int aD0= 0;aD0<oD0;aD0++){
      vv.D0ord(aD0)=aD0;
   }
   for(int bD0max=(oD0-1);bD0max> 0;bD0max--){
      bool ORDERED=true;
      double z1= D0[vv.D0ord( 0)].e[0];
      for(int bD0= 1;bD0<=bD0max;bD0++){
         double z2= D0[vv.D0ord(bD0)].e[0];
         if( z2<z1 ){
            int L=vv.D0ord(bD0);
            vv.D0ord(bD0)=vv.D0ord(bD0-1);
            vv.D0ord(bD0-1)=L;
            ORDERED=false;
         }else{
            z1= z2;
         }
      }
      if( ORDERED )break;
   }
   for(int aD0= 0;aD0<oD0;aD0++){
      vv.D0inv(vv.D0ord(aD0))=aD0;
   }

   double Eglo=( oD0>0 )? D0[vv.D0ord( 0)].e[0]: (0.00);
   double Ecut=( Eglo +(32.00));

   for(int aD0= 0;aD0<oD0;aD0++){
      int bD0=vv.D0ord(aD0);
      if( bD0!=aD0 ){
         int kD0=vv.D0inv(aD0);
         for(int i= 0;i<20;i++){
            double z= D0[aD0].e[i];
            D0[aD0].e[i]= D0[bD0].e[i];
            D0[bD0].e[i]= z;
         }
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            D0[aD0].Z0[iZ0].swap( D0[bD0].Z0[iZ0]);
         }
         for(int iT5= 0;iT5<oT5;iT5++){
            double z= D0T5chi(aD0,iT5);
            D0T5chi(aD0,iT5)= D0T5chi(bD0,iT5);
            D0T5chi(bD0,iT5)= z;
         }
         vv.D0ord(aD0)=aD0;
         vv.D0inv(aD0)=aD0;
         vv.D0ord(kD0)=bD0;
         vv.D0inv(bD0)=kD0;
      }
      if( D0[aD0].e[0]<Ecut )nD0=(aD0+1);
   }

   return;
}

void Backbone_Defs::PRINT(const DAT_PHYSICS_CONSTS& physics_consts,
                          const DAT_RESIDUE_MAPPINGS& residue_mappings,
                          const DAT_REGION_MAPS& region_maps,
                          Output_Streams& out,
                          const Search_Subspace& sub,
                          const std::string& MODE){
   MEM_Backbone_Defs vv;
   int oD0=nD0;
   int oZ0=D0[ 0].Z0.size();
   int oR1=sub.nR1;

   if( out.SHELL ){
      out.FILE3<<"DEFORMATIONS FOR MODE="<<MODE<<'\n';
      out.FILE3<<"Number of conformations="<< std::setw( 4)<<nD0<<'\n';
   }
   vv.o_R1cnf.resize(oR1);
   for(int aD0= 0;aD0<oD0;aD0++){
//
//
// evaluate conformational regions
//
      for(int iR1= 0;iR1<oR1;iR1++){
         vv.R1cnf(iR1)="  ";
         std::string aa=sub.R1[iR1].aa;
         int iL0=sub.R1[iR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         int mT5=sub.R1[iR1  ].T5a;
         if      ( c1=='a' ){
            if( (aa[0]=='e')||(aa[0]=='z')||
                (aa[3]=='e')||(aa[3]=='z') )continue;
            if( sub.R1[iR1].bb==0 )continue;
            double phi= D0T5chi(aD0,mT5  );
            double psi= D0T5chi(aD0,mT5+1);
            if( phi>(0.00) ){
               phi=-phi;
               psi=-psi;
               vv.R1cnf(iR1)[1]='*';
            }
            int iH4=1 +int( phi +(180.00))/10;
            int jH4=1 +int( psi +(180.00))/10;
            int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                    region_maps.H4H4ala(iH4,jH4);
            vv.R1cnf(iR1)[0]=( (MODE=="bb ")||(MODE=="sc ") )?
                    region_maps.I0alp(iI0):
                    region_maps.I0bet(iI0);
         }else if( c1=='e' ){
            if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ") )continue;
         }else if( c1=='r' ){
            if( iR1== 0 )continue;
            if( (sub.R1[iR1-1].R0  )!=
                (sub.R1[iR1  ].R0-1) )continue;
            int jT5=sub.R1[iR1-1].T5a;
            double eps= D0T5chi(aD0,jT5  );
            double zet= D0T5chi(aD0,jT5+1);
            double alp= D0T5chi(aD0,jT5+2);
            double bet= D0T5chi(aD0,mT5  );
            double gam= D0T5chi(aD0,mT5+1);
            double del= D0T5chi(aD0,mT5+2);
            double de0=( 146.00);
            if( iR1> 2 ){
               int iR0=sub.R1[iR1  ].R0;
               int jR0=sub.R1[iR1-3].R0;
               if( jR0==(iR0-3) ){
                  jT5=sub.R1[iR1-3].T5a;
                  de0= D0T5chi(aD0,jT5+2);
               }
            }
            double rmin= (1.00e+8);
            int jC6=-1;
            for(int iC6= 0;iC6<46;iC6++){
               double d0=( de0 -region_maps.C6[iC6].de0);
               if      ( d0>=( 180.) ){ d0-=(360.);
               }else if( d0< (-180.) ){ d0+=(360.);
               }
               double d1=( eps -region_maps.C6[iC6].eps);
               if      ( d1>=( 180.) ){ d1-=(360.);
               }else if( d1< (-180.) ){ d1+=(360.);
               }
               double d2=( zet -region_maps.C6[iC6].zet);
               if      ( d2>=( 180.) ){ d2-=(360.);
               }else if( d2< (-180.) ){ d2+=(360.);
               }
               double d3=( alp -region_maps.C6[iC6].alp);
               if      ( d3>=( 180.) ){ d3-=(360.);
               }else if( d3< (-180.) ){ d3+=(360.);
               }
               double d4=( bet -region_maps.C6[iC6].bet);
               if      ( d4>=( 180.) ){ d4-=(360.);
               }else if( d4< (-180.) ){ d4+=(360.);
               }
               double d5=( gam -region_maps.C6[iC6].gam);
               if      ( d5>=( 180.) ){ d5-=(360.);
               }else if( d5< (-180.) ){ d5+=(360.);
               }
               double d6=( del -region_maps.C6[iC6].del);
               if      ( d6>=( 180.) ){ d6-=(360.);
               }else if( d6< (-180.) ){ d6+=(360.);
               }
               double rr=( d0*d0 +d1*d1 +d2*d2 +d3*d3 +d4*d4
                          +d5*d5 +d6*d6);
               double r= std::sqrt( rr/(7.00));
               if( r<rmin ){
                  rmin= r;
                  jC6=iC6;
               }
            }
            vv.R1cnf(iR1)=region_maps.C6[jC6].cnf;
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
//
//
// print characterization of conf
//
      if( out.SHELL ){
         out.FILE3<<" iD0="<< std::setw( 4)<<aD0<<"  "
                  << std::scientific<< std::setprecision(5);
         if      ( (MODE=="bb ")||(MODE=="sc ") ){
            if( aD0== 0 ){
               out.FILE3<<" S=?? initial  ";
            }else{
               out.FILE3<<" S="<< std::setw(12)<<D0[aD0].e[0];
            }
         }else if( (MODE=="lp ") ){
            out.FILE3<<" F="<< std::setw(12)<<D0[aD0].e[0];
         }
         out.FILE3<<"  cnf=";
         for(int iZ2= 0;iZ2<nZ2;iZ2++){
            out.FILE3<<'[';
            int mR1=Z2[iZ2].CYC;
            int nR1=(mR1-1+sub.R1[mR1].pt);
            for(int iR1=mR1;iR1<=nR1;iR1++){
               int iL0=sub.R1[iR1].L0;
               char c1=residue_mappings.L0[iL0].c1;
               if      ( c1=='a' ){
                  out.FILE3<<vv.R1cnf(iR1);
               }else if( c1=='e' ){
               }else if( c1=='r' ){
                  if( iR1>(mR1+2) ){
                     out.FILE3<<'|';
                  }
                  out.FILE3<<vv.R1cnf(iR1);
               }else if( c1=='b' ){
               }else if( c1=='p' ){
               }else if( c1=='s' ){
               }
            }
            out.FILE3<<']';
         }
         out.FILE3<<'\n';
         out.FILE3<< std::fixed<< std::setprecision(2);
         if      ( MODE=="bb " ){
            if( aD0== 0 ){
               out.FILE3<<" S1=??       "
                        <<" S2=??       "
                        <<" S3=??       "
                        <<" S4=??       "
                        <<" S5=??       "<<'\n';
            }else{
               out.FILE3<<" S1="<< std::setw( 9)<<D0[aD0].e[1]
                        <<" S2="<< std::setw( 9)<<D0[aD0].e[2]
                        <<" S3="<< std::setw( 9)<<D0[aD0].e[3]
                        <<" S4="<< std::setw( 9)<<D0[aD0].e[4]
                        <<" S5="<< std::setw( 9)<<D0[aD0].e[5]<<'\n';
            }
         }else if( MODE=="sc " ){
         }else if( MODE=="lp " ){
            out.FILE3<<"    Fr  "
                     <<"    Fe  "
                     <<"    Fs  "
                     <<"    Ft  "
                     <<"    Fc  "
                     <<"    Fb  "
                     <<"    Fh  "
                     <<"    Fm  "
                     <<"    Fg  "
                     <<"    Fp  "<<'\n';
            out.FILE3<< std::setw( 8)<<D0[aD0].e[ 1]
                     << std::setw( 8)<<D0[aD0].e[ 2]
                     << std::setw( 8)<<D0[aD0].e[ 3]
                     << std::setw( 8)<<D0[aD0].e[ 4]
                     << std::setw( 8)<<D0[aD0].e[ 5]
                     << std::setw( 8)<<D0[aD0].e[ 6]
                     << std::setw( 8)<<D0[aD0].e[ 7]
                     << std::setw( 8)<<D0[aD0].e[ 8]
                     << std::setw( 8)<<D0[aD0].e[11]
                     << std::setw( 8)<<D0[aD0].e[12]<<'\n';
//          out.FILE3<<"   Fps  "
//                   <<"   Fss  "
//                   <<"   sol  "
//                   <<"   Qha  "
//                   <<"   Qpa  "
//                   <<"   Qps  "
//                   <<"   Qss  "
//                   <<"   Qtq  "
//                   <<"   Qfq  "<<'\n';
//          out.FILE3<< std::setw( 8)<<D0[aD0].e[ 9]
//                   << std::setw( 8)<<D0[aD0].e[10]
//                   << std::setw( 8)<<D0[aD0].e[13]
//                   << std::setw( 8)<<D0[aD0].e[14]
//                   << std::setw( 8)<<D0[aD0].e[15]
//                   << std::setw( 8)<<D0[aD0].e[16]
//                   << std::setw( 8)<<D0[aD0].e[17]
//                   << std::setw( 8)<<D0[aD0].e[18]
//                   << std::setw( 8)<<D0[aD0].e[19]<<'\n';
         }
      }
//
//
// print torsion angles
//
      if( out.SHELL ){
         out.FILE3<< std::fixed;
         if( sub.mBOD==1 ){
            out.FILE3<< std::setprecision(7);
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               out.FILE3<< std::setw( 2)<<iZ0<<' ';
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw(12)<<(physics_consts.ANG
                                             *D0[aD0].Z0[iZ0].trans(i));
               }
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw(12)<<(D0[aD0].Z0[iZ0].rot(i)
                                             /physics_consts.RAD);
               }
               out.FILE3<<'\n';
            }
         }
         out.FILE3<< std::setprecision(2);
         for(int iR1= 0;iR1<oR1;iR1++){
            std::string aa=sub.R1[iR1].aa;
            out.FILE3<<aa<<' '<<vv.R1cnf(iR1)<<' ';
            if( aa=="ACE " ){
               out.FILE3<<"       ";
            }
            int mT5=sub.R1[iR1].T5a;
            int nT5=(mT5-1+sub.R1[iR1].cT5);
            for(int iT5=mT5;iT5<=nT5;iT5++){
               if( ((aa[3]=='e')||(aa[3]=='z'))&&(iT5==(mT5+2)) ){
                  out.FILE3<<"       ";
               }else{
                  out.FILE3<< std::setw( 7)<<D0T5chi(aD0,iT5);
               }
            }
            out.FILE3<<'\n';
         }
      }
   }

   return;
}
