#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>

class MEM_unionsc {
private:
   std::vector<int> o_R0sub;            //residue has unsearched sc
   std::vector<Coordinates> o_R0x;      //center of sc atoms (angstrom)
   std::vector<int> o_R1sub;            //residue has searched bb or sc
   std::vector<std::string> o_R1cat;    //concatenated names of allowed residues
   std::vector<int> o_R1ord;            //order
   std::vector<int> o_R1inv;            //inverse order
public:
   MEM_unionsc(int o,int oR1):
      o_R0sub(o, 0),
      o_R0x(o),
      o_R1sub(oR1, 0),
      o_R1cat(o,""),
      o_R1ord(o),
      o_R1inv(o)
   {
   }
   int& R0sub(int i){
      return o_R0sub.at( i);  }
   Coordinates& R0x(int i){
      return o_R0x.at( i);  }
   int& R1sub(int i){
      return o_R1sub.at( i);  }
   std::string& R1cat(int i){
      return o_R1cat.at( i);  }
   int& R1ord(int i){
      return o_R1ord.at( i);  }
   int& R1inv(int i){
      return o_R1inv.at( i);  }
};

void Search_Subspace::UNIONSC(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              const Structure& str){
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oR1=nR1;
   MEM_unionsc vv(oR0,oR1);
//
//
// annotate structure
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         vv.R0x(iR0).zero();
         double z= (0.00);
         int mP1=str.R0[iR0].P1a;
         int nP1=(mP1-1+str.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( str.P1[iP1].sub==0 )continue;
            if( str.P1[iP1].sc==0 )continue;
            vv.R0x(iR0)+=str.P1[iP1].x;
            z++;
         }
         if( z>(0.00) ){
            vv.R0x(iR0)/=z;
         }
         if      ( c1=='a' ){
            if( aa=="ALA " )continue;
            if( aa=="GLY " )continue;
//          if( aa=="PRO " )continue;
            if( aa=="AIB " )continue;
            if( aa=="UNK " )continue;
         }else if( c1=='e' ){
            continue;
         }else if( c1=='r' ){
            if( aa=="D   " )continue;
            if( aa=="R   " )continue;
            if( aa=="RF  " )continue;
            if( aa=="LNA " )continue;
            if( aa=="CET " )continue;
         }else if( c1=='b' ){
            if( aa=="N   " )continue;
         }else if( c1=='p' ){
            continue;
         }else if( c1=='s' ){
            continue;
         }
         if( z>(0.00) ){
            vv.R0sub(iR0)=1;
         }
      }
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=R1[iR1].R0;
      if( (R1[iR1].bb<2)&&(R1[iR1].sc<2) ){
      }else{
         vv.R0sub(iR0)=0;
      }
   }
//
//
// annotate search subspace
//
   for(int iR1= 0;iR1<oR1;iR1++){
      if( (R1[iR1].bb<2)&&(R1[iR1].sc<2) ){
      }else{
         vv.R1sub(iR1)=1;
      }
      int mR3=R1[iR1].R3a;
      int nR3=(mR3-1+R1[iR1].cR3);
      for(int iR3=mR3;iR3<=nR3;iR3++){
         vv.R1cat(iR1)+=R3[iR3].aa;
      }
   }
//
//
// expand R1
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0sub(iR0)==0 )continue;
         int iR1=-1;
         for(int jR1= 0;jR1<oR1;jR1++){
            if( R1[jR1].R0==iR0 ){
               iR1=jR1;
               break;
            }
         }
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int mP1=str.R0[iR0].P1a;
         int nP1=(mP1-1+str.R0[iR0].cP1);
         for(int jR1= 0;jR1<oR1;jR1++){
            if( vv.R1sub(jR1)==0 )continue;
            int jR0=R1[jR1].R0;
            int jP1min=str.R0[jR0].P1a;
            int jP1max=(jP1min-1+str.R0[jR0].cP1);
            double zR=( vv.R0x(jR0) -vv.R0x(iR0)).r();
            if( zR>(11.00) )continue;
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( str.P1[iP1].sub==0 )continue;
               if( str.P1[iP1].typ< 8 )continue;
               if( str.P1[iP1].sc==0 )continue;
               for(int jP1=jP1min;jP1<=jP1max;jP1++){
                  if( str.P1[jP1].sub==0 )continue;
                  if( str.P1[jP1].typ< 8 )continue;
                  if( (R1[jR1].bb<2)&&(str.P1[jP1].sc==0) )continue;
                  double zQ=( str.P1[jP1].x -str.P1[iP1].x).r();
                  if( zQ<zR )zR= zQ;
               }
            }
            if( zR<(4.20) ){
               if( iR1==-1 ){
                  R1.push_back( tR1());
                  R1[nR1].Z0=iZ0;
                  R1[nR1].R0=iR0;
                  R1[nR1].L0=str.R0[iR0].L0;
                  R1[nR1].aa=str.R0[iR0].aa;
                  R1[nR1].bb=0;
                  if( aa=="PRO " ){
                     R1[nR1].sc=1;
                  }else{
                     R1[nR1].sc=2;
                  }
                  R1[nR1].pt=0;
                  vv.R1cat(nR1)=str.R0[iR0].aa;
                  nR1++;
               }else{
                  if( aa=="PRO " ){
                     R1[iR1].sc=1;
                  }else{
                     R1[iR1].sc=2;
                  }
               }
               break;
            }
         }
      }
   }
   oR1=nR1;
//
//
// order R1
//
   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1ord(iR1)=iR1;
   }
   for(int jR1max=(oR1-1);jR1max> 0;jR1max--){
      bool ORDERED=true;
      int i=R1[vv.R1ord( 0)].R0;
      for(int jR1= 1;jR1<=jR1max;jR1++){
         int j=R1[vv.R1ord(jR1)].R0;
         if( j<i ){
            int L=vv.R1ord(jR1);
            vv.R1ord(jR1)=vv.R1ord(jR1-1);
            vv.R1ord(jR1-1)=L;
            ORDERED=false;
         }else{
            i=j;
         }
      }
      if( ORDERED )break;
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1inv(vv.R1ord(iR1))=iR1;
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      int jR1=vv.R1ord(iR1);
      int kR1=vv.R1inv(iR1);
      int iZ0=R1[iR1].Z0;
      R1[iR1].Z0=R1[jR1].Z0;
      R1[jR1].Z0=iZ0;
      int iR0=R1[iR1].R0;
      R1[iR1].R0=R1[jR1].R0;
      R1[jR1].R0=iR0;
      int iL0=R1[iR1].L0;
      R1[iR1].L0=R1[jR1].L0;
      R1[jR1].L0=iL0;
      std::string aa=R1[iR1].aa;
      R1[iR1].aa=R1[jR1].aa;
      R1[jR1].aa=aa;
      int bb=R1[iR1].bb;
      R1[iR1].bb=R1[jR1].bb;
      R1[jR1].bb=bb;
      int sc=R1[iR1].sc;
      R1[iR1].sc=R1[jR1].sc;
      R1[jR1].sc=sc;
      int pt=R1[iR1].pt;
      R1[iR1].pt=R1[jR1].pt;
      R1[jR1].pt=pt;
      std::string cat=vv.R1cat(iR1);
      vv.R1cat(iR1)=vv.R1cat(jR1);
      vv.R1cat(jR1)=cat;
      vv.R1ord(iR1)=iR1;
      vv.R1inv(iR1)=iR1;
      vv.R1ord(kR1)=jR1;
      vv.R1inv(jR1)=kR1;
   }
//
//
// unpack concatenated names of allowed residues
//
   R3.clear();
   int mR3=0;
   for(int iR1= 0;iR1<oR1;iR1++){
      R1[iR1].R3a=mR3;
      R1[iR1].cR3=(vv.R1cat(iR1).size()/4);
      int nR3=(mR3-1+R1[iR1].cR3);
      for(int iR3=mR3;iR3<=nR3;iR3++){
         std::string aa=vv.R1cat(iR1).substr( (iR3-mR3)*4, 4);
         int iL0=residue_mappings.iresidue( aa);
         if( iL0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in Search_Subspace."
                     <<" iR1="<< std::setw( 4)<<iR1
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         R3.push_back( tR3());
         R3[iR3].aa=aa;
         R3[iR3].L0=iL0;
      }
      mR3+=R1[iR1].cR3;
   }
//
//
// populate Search_Subspace to level of fil2stp
//
   T5.clear();
   int mT5=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      int iR0=R1[iR1].R0;
      char c1=str.R0[iR0].c1;
      std::string aa=str.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      R1[iR1].T5a=mT5;
      R1[iR1].cT5=str.R0[iR0].cT1;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         T5.push_back( tT5());
         T5[iT1-mT1+mT5].tor=str.T1[iT1].tor;
      }
      mT5+=R1[iR1].cT5;
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )R1[iR1].ca=str.P1[iP1].x;
            if( atm==" CB " )R1[iR1].cb=str.P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CM'" )R1[iR1].cb=str.P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CA'" )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" N1 " )R1[iR1].cb=str.P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" C4 " )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }

   return;
}
