#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cmath>

void Structure::TOR2FIL(const DAT_PHYSICS_CONSTS& physics_consts) const{

   std::string filename="../../"+fam+"/tor/tor."+mol+"."+cnf;
   std::ofstream ofile(filename.c_str());
   ofile<< std::fixed;
   std::string rule="________________________________________"
                    "________________________________________"
                    "\n";

   ofile<< std::setprecision(7);
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      ofile<< std::setw( 2)<<(iZ0+1)<<' ';
      for(int i=0;i<3;i++){
         ofile<< std::setw(12)<<(physics_consts.ANG*Z0[iZ0].trans(i));
      }
      for(int i=0;i<3;i++){
         ofile<< std::setw(12)<<(Z0[iZ0].rot(i)/physics_consts.RAD);
      }
      ofile<<'\n';
   }
   ofile<< std::setprecision(4);
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      ofile<<rule;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         ofile<<aa<<' ';
         if( aa=="ACE " ){
            ofile<<"         ";
         }
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if( ((aa[3]=='e')||(aa[3]=='z'))&&(iT1==(mT1+2)) ){
               ofile<<"         ";
            }else{
               ofile<< std::setw( 9)<<T1[iT1].chi;
            }
         }
//
//
// additional ring geometry for PRO
//
         if( (aa=="PRO ")||(aa=="PROe") ){
            int iP1=iatom(iR0  ," CG ");
            int jP1=iatom(iR0  ," CD ");
            int kP1=iatom(iR0  ," N  ");
            int lP1=iatom(iR0-1," CA ");
            if( (iP1==-1)||(P1[iP1].sub==0)||
                (jP1==-1)||(P1[jP1].sub==0)||
                (kP1==-1)||(P1[kP1].sub==0)||
                (lP1==-1)||(P1[lP1].sub==0) ){
               std::cerr<<"FLAG: Missing atom of PRO ring."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-(mR0-1))<<".\n";
            }
            Coordinates u=( P1[kP1].x -P1[jP1].x);
            u.normalize();
            Coordinates v=( P1[iP1].x -P1[jP1].x);
            double vu= dot(v,u);
            v-=vu*u;
            v.normalize();
            Coordinates w= cross(u,v);
            Coordinates d=( P1[lP1].x -P1[kP1].x);
            double du= dot(d,u);
            d-=du*u;
            d.normalize();
            double CP= dot(d,v);
            double SP= dot(d,w);
            double ch4= (std::atan2(SP,CP)/physics_consts.RAD);
            ofile<<" #(CG-CD-N -CA)="
                 << std::setprecision(1)<< std::setw( 6)<<ch4
                 << std::setprecision(4);
         }
         if( (aa=="D   ")||(aa=="R   ")||(aa=="RME ")||(aa=="RF  ")||
             (aa=="MOE ")||(aa=="LNA ")||(aa=="CET ") ){
            int iP1=iatom(iR0  ," C2'");
            int jP1=iatom(iR0  ," C1'");
            int kP1=iatom(iR0  ," O4'");
            int lP1=iatom(iR0  ," C4'");
            if( (iP1==-1)||(P1[iP1].sub==0)||
                (jP1==-1)||(P1[jP1].sub==0)||
                (kP1==-1)||(P1[kP1].sub==0)||
                (lP1==-1)||(P1[lP1].sub==0) ){
               std::cerr<<"FLAG: Missing atom of ribose ring."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-(mR0-1))<<".\n";
            }
            Coordinates u=( P1[kP1].x -P1[jP1].x);
            u.normalize();
            Coordinates v=( P1[iP1].x -P1[jP1].x);
            double vu= dot(v,u);
            v-=vu*u;
            v.normalize();
            Coordinates w= cross(u,v);
            Coordinates d=( P1[lP1].x -P1[kP1].x);
            double du= dot(d,u);
            d-=du*u;
            d.normalize();
            double CP= dot(d,v);
            double SP= dot(d,w);
            double nu0= (std::atan2(SP,CP)/physics_consts.RAD);
            ofile<<" #(C2-C1-O4-C4)="
                 << std::setprecision(1)<< std::setw( 6)<<nu0
                 << std::setprecision(4);
         }
         ofile<<'\n';
      }
   }
   ofile<<rule;
   ofile.close();
   return;
}
