#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Structure::TOR(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings){
//
//
// initiate torsions
//
   T1.clear();
   int jT1=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         R0[iR0].T1a=jT1;
         R0[iR0].cT1=residue_mappings.L0[iL0].cT0;
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            T1.push_back( tT1());
            T1[iT1].chi=( 180.00);
         }
         if      ( aa=="ALA " ){
            T1[jT1+ 3].chi=(  60.00);
         }else if( aa=="ILE " ){
            T1[jT1+ 5].chi=(  60.00);
            T1[jT1+ 6].chi=(  60.00);
         }else if( aa=="LEU " ){
            T1[jT1+ 5].chi=(  60.00);
            T1[jT1+ 6].chi=(  60.00);
         }else if( aa=="MET " ){
            T1[jT1+ 6].chi=(  60.00);
         }else if( aa=="PRO " ){
            T1[jT1   ].chi=( -65.00);
            T1[jT1+ 3].chi=(  16.00);
            T1[jT1+ 4].chi=( -19.00);
            T1[jT1+ 5].chi=(  14.00);
         }else if( aa=="ARG " ){
            T1[jT1+ 7].chi=(   0.00);
         }else if( aa=="THR " ){
            T1[jT1+ 5].chi=(  60.00);
         }else if( aa=="VAL " ){
            T1[jT1+ 4].chi=(  60.00);
            T1[jT1+ 5].chi=(  60.00);
         }else if( aa=="TYR " ){
            T1[jT1+ 5].chi=(   0.00);
         }else if( aa=="ACE " ){
            T1[jT1   ].chi=(   0.00);
         }
         jT1+=residue_mappings.L0[iL0].cT0;
      }
   }
//
//
// chain translation +rotation
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int iR0=Z0[iZ0].R0a;
      std::string aa=R0[iR0].aa;
      int mP1=R0[iR0].P1a;
      int nP1=(mP1-1+R0[iR0].cP1);
      int iL0=R0[iR0].L0;
      char c1=residue_mappings.L0[iL0].c1;
      int jP1=-1;
      int kP1=-1;
      int lP1=-1;
      double sgn= ( 1.00);
      std::string atj,atk,atl;
      if      ( c1=='a' ){
         atj=" N  ";
         atk=" CA ";
         atl="1H  ";
         if( aa=="ePRO" ){
            atl=" CD ";
         }
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            if( atm==atj )jP1=iP1;
            if( atm==atk )kP1=iP1;
            if( atm==atl )lP1=iP1;
         }
         if( lP1==-1 ){
            atl=" C  ";
            sgn= (-1.00);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( P1[iP1].sub==0 )continue;
               std::string atm=P1[iP1].atm;
               if( atm==atl )lP1=iP1;
            }
         }
         if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
            if( nZ0== 1 ){
               Z0[ 0].trans.zero();
               Z0[ 0].rot.zero();
               continue;
            }
            std::cerr<<"ERROR: Incomplete 1st residue of chain."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
      }else if( c1=='e' ){
         if( aa=="ACE " ){
            atj=" CH3";
            atk=" C  ";
            atl="1H  ";
            sgn= (-1.00);
         }else{
            std::cerr<<"ERROR: Unmatched end group name."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit(1);
         }
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            if( atm==atj )jP1=iP1;
            if( atm==atk )kP1=iP1;
            if( atm==atl )lP1=iP1;
         }
         if( lP1==-1 ){
            atl=" O  ";
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( P1[iP1].sub==0 )continue;
               std::string atm=P1[iP1].atm;
               if( atm==atl )lP1=iP1;
            }
         }
         if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
            if( nZ0== 1 ){
               Z0[ 0].trans.zero();
               Z0[ 0].rot.zero();
               continue;
            }
            std::cerr<<"ERROR: Incomplete 1st residue of chain."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
      }else if( c1=='p' ){
         if      ( aa=="5OH " ){
            atj=" O5'";
            atk=" C5'";
            atl=" HO5";
            kP1=(nP1+1);
         }else if( aa=="5PO " ){
            atj=" P  ";
            atk=" O5'";
            atl=" O1P";
         }else{
            std::cerr<<"ERROR: Unmatched end group name."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit(1);
         }
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            if( atm==atj )jP1=iP1;
            if( atm==atk )kP1=iP1;
            if( atm==atl )lP1=iP1;
         }
         if( lP1==-1 ){
            atl=" C4'";
            lP1=(nP1+4);
            sgn= (-1.00);
         }
         if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
            std::cerr<<"ERROR: Incomplete 1st residue of chain."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit(1);
         }
      }else if( c1=='s' ){
         jP1=(mP1  );
         kP1=(mP1+1);
         lP1=(mP1+2);
         if( (lP1>nP1)||
             (P1[jP1].sub==0)||(P1[kP1].sub==0)||(P1[lP1].sub==0) ){
            std::cerr<<"ERROR: Incomplete 3 atom base of small molecule."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
      }
      Coordinates u=( P1[kP1].x -P1[jP1].x);
      u.normalize();
      Coordinates v=( P1[lP1].x -P1[jP1].x);
      double vu= dot(v,u);
      v-=vu*u;
      v.normalize();
      v*=sgn;
      Coordinates w= cross(u,v);
      Rotation_Matrix ROT;
      ROT(0,0)= u(0);
      ROT(1,0)= u(1);
      ROT(2,0)= u(2);
      ROT(0,1)= v(0);
      ROT(1,1)= v(1);
      ROT(2,1)= v(2);
      ROT(0,2)= w(0);
      ROT(1,2)= w(1);
      ROT(2,2)= w(2);
      if( (aa=="ePRO")&&(atl==" C  ") ){
         double C= std::cos((  65.00));
         double S= std::sin((  65.00));
         ROT(0,1)=(  C*v(0) +S*w(0));
         ROT(1,1)=(  C*v(1) +S*w(1));
         ROT(2,1)=(  C*v(2) +S*w(2));
         ROT(0,2)=( -S*v(0) +C*w(0));
         ROT(1,2)=( -S*v(1) +C*w(1));
         ROT(2,2)=( -S*v(2) +C*w(2));
      }
      Coordinates TRANS= P1[jP1].x;
      TRANS/=physics_consts.ANG;
      Z0[iZ0].trans=TRANS;
      double Cbet= ROT(2,2);
      double Sbet= std::sqrt( (1.00) -Cbet*Cbet);
      double bet= std::atan2(Sbet,Cbet);
      double alp,gam;
      if( Sbet<(1.00e-12) ){
         gam= (0.00);
         if( Cbet>(0.00) ){
            double Calp= ROT(0,0);
            double Salp= ROT(0,1);
            alp= std::atan2(Salp,Calp);
         }else{
            double Calp=-ROT(0,0);
            double Salp=-ROT(0,1);
            alp= std::atan2(Salp,Calp);
         }
      }else{
         double Calp= (ROT(2,0)/Sbet);
         double Salp= (ROT(2,1)/Sbet);
         alp= std::atan2(Salp,Calp);
         double Cgam=-(ROT(0,2)/Sbet);
         double Sgam= (ROT(1,2)/Sbet);
         gam= std::atan2(Sgam,Cgam);
      }
      Z0[iZ0].rot(0)= alp;
      Z0[iZ0].rot(1)= bet;
      Z0[iZ0].rot(2)= gam;
   }
//
//
// torsions specified by coordinates
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int iL0=R0[iR0].L0;
         int mT0=residue_mappings.L0[iL0].T0a;
         int nT0=(mT0-1+residue_mappings.L0[iL0].cT0);
         int iT1=(R0[iR0].T1a-1);
         for(int iT0=mT0;iT0<=nT0;iT0++){
            std::string tor=residue_mappings.T0[iT0].tor;
            T1[++iT1].tor=tor;

            int A0P1[4];
            for(int iA0=0;iA0<4;iA0++){
               int jR0=iR0+residue_mappings.T0A0R0(iT0,iA0);
               std::string atm=residue_mappings.T0A0atm(iT0,iA0);
               if( (c1=='a')&&(aa=="CYS ")&&
                   (tor=="CH2" )&&
                   (atm==" X  ") ){
                  for(int iS0=0;iS0<nS0;iS0++){
                     for(int iN2=0;iN2<2;iN2++){
                        if( S0N2R0(iS0,iN2)==iR0 ){
                           jR0=S0N2R0(iS0,1-iN2);
                        }
                     }
                  }
                  atm=" SG ";
               }
               if( (c1=='r')&&
                   (tor=="NU1")&&
                   (jR0==(iR0+1))&&(atm==" N1 ") ){
                  std::string ab=R0[jR0].aa;
                  if( (ab=="A   ")||(ab=="AP  ")||
                      (ab=="G   ")||(ab=="GP  ")||(ab=="GM  ") ){
                     atm=" N9 ";
                  }
               }
               if( (R0[jR0].aa=="5OH ")&&
                   (tor=="BET")&&
                   (atm==" P  ") ){
                     atm=" HO5";
               }
               A0P1[iA0]=-1;
               int mP1=R0[jR0].P1a;
               int nP1=(mP1-1+R0[jR0].cP1);
               for(int iP1=mP1;iP1<=nP1;iP1++){
                  if( P1[iP1].sub==0 )continue;
                  if( P1[iP1].atm==atm )A0P1[iA0]=iP1;
               }
               if( atm[1]=='H' ){
               }else{
                  if( A0P1[iA0]==-1 ){
//                   std::cerr<<"Missing atom of torsion definition."
//                            <<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                            <<" iR0="<< std::setw( 4)<<(iR0+1)
//                            <<" aa="<<R0[iR0].aa
//                            <<" iT0="<< std::setw( 2)<<(iT0-mT0+1)
//                            <<" iA0="<< std::setw( 1)<<iA0
//                            <<" T0A0R0="<< std::setw( 4)<<(jR0-iR0)
//                            <<" T0A0atm="<<atm<<".\n"
                  }
               }
            }
            int iP1=A0P1[0];
            int jP1=A0P1[1];
            int kP1=A0P1[2];
            int lP1=A0P1[3];
            if( (iP1==-1)||(jP1==-1)||(kP1==-1)||(lP1==-1) )continue;

            Coordinates u=( P1[kP1].x -P1[jP1].x);
            u.normalize();
            Coordinates v=( P1[lP1].x -P1[kP1].x);
            double vu= dot(v,u);
            v-=vu*u;
            v.normalize();
            Coordinates w= cross(u,v);
            Coordinates zD=( P1[iP1].x -P1[jP1].x);
//
//
// special case ePRO
//
            if( (c1=='a')&&(tor=="PHI") ){
               if      ( R0[iR0].aa=="ePRO" ){
//                zD-=P1[iP1].x;
//                int gP1=-1;
//                int hP1=-1;
//                int aP1=R0[iR0].P1a;
//                int bP1=(aP1-1+R0[iR0].cP1);
//                for(int pP1=aP1;pP1<=bP1;pP1++){
//                   if( P1[pP1].sub==0 )continue;
//                   if      ( P1[pP1].atm=="1H  " ){
//                      gP1=pP1;
//                   }else if( P1[pP1].atm=="2H  " ){
//                      hP1=pP1;
//                   }
//                }
//                if( (gP1==-1)||(hP1==-1) )continue;
//                zD+=(.50)*( P1[gP1].x +P1[hP1].x);
               }else if( R0[iR0].aa=="zPRO" ){
                  zD-=P1[iP1].x;
                  int gP1=-1;
                  int aP1=R0[iR0].P1a;
                  int bP1=(aP1-1+R0[iR0].cP1);
                  for(int pP1=aP1;pP1<=bP1;pP1++){
                     if( P1[pP1].sub==0 )continue;
                     if( P1[pP1].atm=="1H  " ){
                        gP1=pP1;
                     }
                  }
                  if( gP1==-1 )continue;
                  zD+=P1[gP1].x;
               }
            }
            double zDU= dot(zD,u);
            zD-=zDU*u;
            zD.normalize();
            double CP= dot(zD,v);
            double SP= dot(zD,w);
            T1[iT1].chi= (-std::atan2(SP,CP)/physics_consts.RAD);
            if( (c1=='a')&&(tor=="PHI") ){
               if( R0[iR0].aa=="zPRO" ){
                  T1[iT1].chi+=(  60.00);
               }
            }
         }
      }
   }
//
//
// enforce ranges
//
   jT1=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         if( (aa[3]=='e')||(aa[3]=='z') ){
            if( T1[jT1+ 1].chi<(   0.00) ){
               T1[jT1+ 1].chi+=( 180.00);
            }else{
               T1[jT1+ 1].chi-=( 180.00);
            }
         }
         if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
         if      ( aa=="ASN " ){
            if( std::abs( T1[jT1+ 5].chi)<(  90.00) ){
               T1[jT1+ 5].chi+=( 180.00);
            }
            if( T1[jT1+ 5].chi>( 180.00) ){
               T1[jT1+ 5].chi-=( 360.00);
            }
         }else if( aa=="ARG " ){
            if( std::abs( T1[jT1+ 7].chi)>(  90.00) ){
               T1[jT1+ 7].chi+=( 180.00);
            }
            if( T1[jT1+ 7].chi>( 180.00) ){
               T1[jT1+ 7].chi-=( 360.00);
            }
         }else if( aa=="GLN " ){
            if( std::abs( T1[jT1+ 6].chi)<(  90.00) ){
               T1[jT1+ 6].chi+=( 180.00);
            }
            if( T1[jT1+ 6].chi>( 180.00) ){
               T1[jT1+ 6].chi-=( 360.00);
            }
         }else if( aa=="TYR " ){
            if( std::abs( T1[jT1+ 5].chi)>(  90.00) ){
               T1[jT1+ 4].chi+=( 180.00);
               T1[jT1+ 5].chi+=( 180.00);
            }
            if( T1[jT1+ 4].chi>( 180.00) ){
               T1[jT1+ 4].chi-=( 360.00);
            }
            if( T1[jT1+ 5].chi>( 180.00) ){
               T1[jT1+ 5].chi-=( 360.00);
            }
         }
         jT1+=R0[iR0].cT1;
      }
   }
   return;
}
