#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_sta {
private:
   std::vector<std::string> o_R0cnf;    //region of (phi,psi) space
   std::vector<bool> o_R0coil;          //ss state is C as opposed to H or E
   std::vector<int> o_R0nH3;            //number of H-bond contacts
public:
   MEM_sta(int o):
      o_R0cnf(o,"  "),
      o_R0coil(o,true),
      o_R0nH3(o,0)
   {
   }
   std::string& R0cnf(int i){
      return o_R0cnf.at( i);  }
   void R0coil(int i,bool a){
      o_R0coil[ i]=a;  }
   bool R0coil(int i){
      return o_R0coil[ i];  }
   int& R0nH3(int i){
      return o_R0nH3.at( i);  }
};

void Structure::STA(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_REGION_MAPS& region_maps){
   int oR0=R0.size();
   MEM_sta vv(oR0);
   o_R0H3Z0.resize(oR0*8);
   o_R0H3R0.resize(oR0*8);
//
//
// assign region of (phi,psi) space
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int iR0min=(mR0+1);
      int iR0max=(nR0-1);
      for(int iR0=iR0min;iR0<=iR0max;iR0++){
         if( R0[iR0].c1!='a' )continue;
         std::string aa=R0[iR0].aa;
         int iT1phi=itorsion(iR0  ,"PHI");
         int iT1psi=itorsion(iR0  ,"PSI");
         if( iT1phi==-1 )continue;
         if( iT1psi==-1 )continue;
         int iT1omg=itorsion(iR0-1,"OMG");
         if( iT1omg==-1 )continue;
         double phi= T1[iT1phi].chi;
         double psi= T1[iT1psi].chi;
         double omg= T1[iT1omg].chi;
         if( std::abs(omg)<( 120.00) )continue;
         std::string cnf="  ";
         if( phi>(0.00) ){
            phi=-phi;
            psi=-psi;
            cnf[1]='*';
         }
         int iH4=1 +int( phi +(180.00))/10;
         int jH4=1 +int( psi +(180.00))/10;
         if( aa=="GLY " ){
            cnf[0]=region_maps.I0bet(region_maps.H4H4gly(iH4,jH4));
         }else{
            cnf[0]=region_maps.I0bet(region_maps.H4H4ala(iH4,jH4));
         }
         if      ( (cnf[0]=='E')||(cnf[0]=='F')||
                   (cnf[0]=='D') ){
            cnf[0]='E';
         }else if( (cnf[0]=='A')||(cnf[0]=='B') ){
            cnf[0]='A';
         }
         if( (aa=="GLY ")&&(cnf=="E*") ){
            cnf[1]=' ';
         }
         vv.R0cnf(iR0)=cnf;
      }
   }
//
//
// limit ss elements to strings of A or E
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int iR0min=(mR0+1);
      int iR0max=(nR0-5);
      for(int iR0=iR0min;iR0<=iR0max;iR0++){
         if( (vv.R0cnf(iR0  )=="A ")&&(vv.R0cnf(iR0+1)=="A ")&&
             (vv.R0cnf(iR0+2)=="A ")&&(vv.R0cnf(iR0+3)=="A ")&&
             (vv.R0cnf(iR0+4)=="A ") ){
            vv.R0coil(iR0  ,false);
            vv.R0coil(iR0+1,false);
            vv.R0coil(iR0+2,false);
            vv.R0coil(iR0+3,false);
            vv.R0coil(iR0+4,false);
         }
      }
      iR0max=(nR0-3);
      for(int iR0=iR0min;iR0<=iR0max;iR0++){
         if( (vv.R0cnf(iR0  )=="E ")&&(vv.R0cnf(iR0+1)=="E ")&&
             (vv.R0cnf(iR0+2)=="E ") ){
            vv.R0coil(iR0  ,false);
            vv.R0coil(iR0+1,false);
            vv.R0coil(iR0+2,false);
         }
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0coil(iR0) )vv.R0cnf(iR0)="  ";
      }
   }
//
//
// map H-bond contacts of adjacent peptide groups
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+1);iR0<=nR0;iR0++){
         if( vv.R0coil(iR0-1)&&
             vv.R0coil(iR0  ) )continue;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            if( (P1[iP1].typ!= 2)||(P1[iP1].atm!=" H  ") )continue;
            int kP1=iatom(iR0  ," N  ");
            if( kP1==-1 ){
               std::cerr<<"ERROR: Missing H-bond vector."
                        <<R0[iR0].aa
                        <<R0[iR0].cha
                        << std::setw( 4)<<R0[iR0].res
                        <<R0[iR0].ins<<' '
                        <<P1[iP1].atm<<'\n';
               std::exit( 1);
            }
            Coordinates u=( P1[iP1].x -P1[kP1].x).normalize();
            std::string cnf1=vv.R0cnf(iR0-1);
            std::string cnf2=vv.R0cnf(iR0  );

            for(int jZ0= 0;jZ0<nZ0;jZ0++){
               int aR0=Z0[jZ0].R0a;
               int bR0=(aR0-1+Z0[jZ0].cR0);
               for(int jR0=aR0;jR0<=(bR0-1);jR0++){
                  if( vv.R0coil(jR0  )&&
                      vv.R0coil(jR0+1) )continue;
                  int aP1=R0[jR0].P1a;
                  int bP1=(aP1-1+R0[jR0].cP1);
                  for(int jP1=aP1;jP1<=bP1;jP1++){
                     if( P1[jP1].sub==0 )continue;
                     if( (P1[jP1].typ!=13)||(P1[jP1].atm!=" O  ") )continue;
                     Coordinates c=( P1[jP1].x -P1[iP1].x);
                     double R= c.r();
                     if( R>( 3.15) )continue;
                     c/=R;
                     double Cthet= dot(c,u);
                     double thet= (std::acos( Cthet)/physics_consts.RAD);
                     if( thet>(  75.00) )continue;
                     std::string cnf3=vv.R0cnf(jR0  );
                     std::string cnf4=vv.R0cnf(jR0+1);

                     if( !vv.R0coil(iR0-1) ){
                        if( (cnf1==cnf3)||(cnf1==cnf4) ){
                           R0H3Z0(iR0-1,vv.R0nH3(iR0-1)  )=jZ0;
                           R0H3R0(iR0-1,vv.R0nH3(iR0-1)++)=jR0;
                        }
                     }
                     if( !vv.R0coil(iR0  ) ){
                        if( (cnf2==cnf3)||(cnf2==cnf4) ){
                           R0H3Z0(iR0  ,vv.R0nH3(iR0  )  )=jZ0;
                           R0H3R0(iR0  ,vv.R0nH3(iR0  )++)=jR0;
                        }
                     }
                     if( !vv.R0coil(jR0  ) ){
                        if( (cnf3==cnf1)||(cnf3==cnf2) ){
                           R0H3Z0(jR0  ,vv.R0nH3(jR0  )  )=iZ0;
                           R0H3R0(jR0  ,vv.R0nH3(jR0  )++)=iR0;
                        }
                     }
                     if( !vv.R0coil(jR0+1) ){
                        if( (cnf4==cnf1)||(cnf4==cnf2) ){
                           R0H3Z0(jR0+1,vv.R0nH3(jR0+1)  )=iZ0;
                           R0H3R0(jR0+1,vv.R0nH3(jR0+1)++)=iR0;
                        }
                     }

                  }
               }
            }

         }
      }
   }
//
//
// limit ss elements to strings containing H-bond contacts
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0coil(iR0) )continue;
         std::string cnf=vv.R0cnf(iR0);
         if      ( cnf=="E " ){
            int nH3=vv.R0nH3(iR0);
            if( nH3< 2 ){
               vv.R0coil(iR0, true);
            }else{
               bool SSELEM=false;
               for(int pH3= 0;pH3<(nH3-1);pH3++){
                  int pZ0=R0H3Z0(iR0,pH3);
                  int pR0=R0H3R0(iR0,pH3);
                  for(int qH3=(pH3+1);qH3<nH3;qH3++){
                     int qZ0=R0H3Z0(iR0,qH3);
                     int qR0=R0H3R0(iR0,qH3);
                     if( (qZ0==pZ0)&&(std::abs(qR0-pR0)<= 3) ){
                        SSELEM=true;
                     }
                  }
               }
               vv.R0coil(iR0, !SSELEM);
            }
         }else if( cnf=="A " ){
            int L=4;
            bool SSELEM=false;
            for(int aR0=(iR0-L);aR0<=iR0;aR0++){
               int bR0=(aR0+L);
               if( aR0<mR0 )continue;
               if( bR0>nR0 )continue;
               int nH3=0;
               for(int jR0=aR0;jR0<=bR0;jR0++){
                  if( vv.R0cnf(jR0)!=cnf ){
                     nH3=0;
                     break;
                  }
                  nH3+=vv.R0nH3(jR0);
               }
               if( nH3> 1 )SSELEM=true;
            }
            vv.R0coil(iR0, !SSELEM);
         }
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0coil(iR0) )continue;
         std::string cnf=vv.R0cnf(iR0);
         int L=4;
         if      ( cnf=="A " ){
         }else if( cnf=="E " ){
            L=1;
         }
         bool SSELEM=false;
         for(int aR0=(iR0-L);aR0<=iR0;aR0++){
            int bR0=(aR0+L);
            if( aR0<=mR0 )continue;
            if( bR0>=nR0 )continue;
            bool WINDOW=true;
            for(int jR0=aR0;jR0<=bR0;jR0++){
               if( vv.R0coil(jR0)||(vv.R0cnf(jR0)!=cnf) )WINDOW=false;
            }
            if( WINDOW )SSELEM=true;
         }
         vv.R0coil(iR0, !SSELEM);
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0coil(iR0) ){
            R0[iR0].C7=3;
         }else{
            std::string cnf=vv.R0cnf(iR0);
            if      ( cnf=="A " ){
               R0[iR0].C7=1;
            }else if( cnf=="E " ){
               R0[iR0].C7=2;
            }
         }
      }
   }
   return;
}
