#include "../fil/Structure.hh"
#include <string>
#include <fstream>
#include <iomanip>

void Structure::SEQ2FIL() const{

   std::string filename="../../"+fam+"/seq/seq."+mol;
   std::ofstream ofile(filename.c_str());
   ofile<< std::setw( 5)<<nZ0<<'\n';
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      ofile<< std::setw( 5)<<Z0[iZ0].cR0<<'\n';
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int iR0=mR0;
      int n=(Z0[iZ0].cR0+15)/16;
      for(int i=0;i<n;i++){
         int m=(nR0-iR0+1);
         if( m>16 )m=16;
         for(int j=0;j<m;j++){
            ofile<<'|'<<R0[iR0++].aa;
         }
         ofile<<'\n';
      }
   }
   ofile<< std::setw( 5)<<nS0<<'\n';
   if( nS0>0 ){
      for(int iS0=0;iS0<nS0;iS0++){
         for(int iN2=0;iN2<2;iN2++){
            int iZ0=S0N2Z0(iS0,iN2);
            int iR0=S0N2R0(iS0,iN2);
            ofile<< std::setw( 5)<<(iZ0+1)
                 << std::setw( 5)<<(iR0-Z0[iZ0].R0a+1);
         }
         ofile<<'\n';
      }
   }
   ofile.close();

   return;
}
