#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cmath>

void Structure::REFORM(const DAT_PHYSICS_CONSTS& physics_consts,
                       const DAT_RESIDUE_MAPPINGS& residue_mappings){

   std::string filename="../../"+fam+"/exp/"+mol+".pdb";
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   char buf;
   std::string aa;

   Z0.push_back( tZ0());
   int iZ0=0;
   Z0[iZ0].R0a=0;
   Z0[iZ0].cR0=0;
   int iR0=-1;
   int jP1=-1;
   std::string grp="          ";
   char alt=' ';
   while( !std::getline(ifile,rec).eof() ){
//
//
// patch rec
//
      if      ( rec.substr( 0, 6)=="HETATM" ){
         std::string a=rec.substr(17, 4);
         std::string b=rec.substr(12, 4);
         if      ( a=="MSE " ){
            rec.replace( 0, 6,"ATOM  ");
            rec.replace(17, 4,"MET ");
            if( (b=="SE  ")||(b==" SE ") )rec.replace(12, 4," SD ");
         }else if( a=="CGU " ){
            rec.replace( 0, 6,"ATOM  ");
            rec.replace(17, 4,"GLU ");
            if( b==" CD1" )rec.replace(12, 4," CD ");
            if( (b==" CD2")||(b==" OE3")||(b==" OE4") )continue;
         }else{
            int iL0=residue_mappings.iresidue( a);
            if( iL0==-1 )continue;
         }
      }else if( rec.substr( 0, 6)=="ATOM  " ){
         std::string a=rec.substr(17, 4);
         std::string g=rec.substr(12, 9);
         if( a=="FOR " )continue;
         if( a=="  A " )continue;
         if( a=="  T " )continue;
         if( a=="  G " )continue;
         if( a=="  C " )continue;
         if( a=="  U " )continue;
//       if( a==" +A " )continue;
//       if( a==" +T " )continue;
         if( a==" +G " )continue;
         if( a==" +C " )continue;
         if( a==" +U " )continue;
         if( a=="PSU " )continue;
         if( a=="  N " )continue;
         if( g==" CB  GLY " )continue;
         if( a=="N-M " )rec.replace(17, 4,"NME ");
         if( a=="HISH" )rec.replace(17, 4,"HIP ");
         if( a=="HID " )rec.replace(17, 4,"HIS ");
         if( a=="CYX " )rec.replace(17, 4,"CYS ");
         if( a=="CSS " )rec.replace(17, 4,"CYS ");
         if( a=="PCA " )rec.replace(17, 4,"GLN ");
         if( g==" CD  ILE " )rec.replace(12, 4," CD1");
         if( g==" AD1 ASN " )rec.replace(12, 4," OD1");
         if( g==" AD2 ASN " )rec.replace(12, 4," ND2");
         if( g==" AE1 GLN " )rec.replace(12, 4," OE1");
         if( g==" AE2 GLN " )rec.replace(12, 4," NE2");
      }else if( rec.substr( 0, 6)=="ENDMDL" ){
         break;
      }else{
         continue;
      }
      if( rec[13]=='D' )rec[13]='H';
      buf=rec[16];
      if( buf==' '||buf==alt ){
      }else{
         if( alt==' ' ){
            alt=buf;
         }else{
            continue;
         }
      }
      char ci=' ';
      {
         std::string a=rec.substr(17, 4);
         int iL0=residue_mappings.iresidue( a);
         if( iL0>=0 ){
            ci=residue_mappings.L0[iL0].c1;
            if( ci=='a' ){
               std::string b=rec.substr(12, 4);
               if( b==" O1 " )rec.replace(12, 4," O  ");
               if( b==" O2 " )rec.replace(12, 4," OXT");
            }
         }
      }
//
//
// process rec
//
      Coordinates x;
      std::istringstream irec(rec.substr(30,24));
      for(int i=0;i<3;i++){
         irec>>x(i);
      }
      if( rec.substr(17,10)!=grp ){
         grp=rec.substr(17,10);
         if( iR0>=Z0[iZ0].R0a ){
            std::string a=rec.substr(17, 4);
            std::string b=rec.substr(12, 4);
            int jR0=iR0;
            bool MISSINGBSE=false;
            if      ( ci=='a' ){
               if( b!=" N  " )MISSINGBSE=true;
            }else if( ci=='e' ){
               if( a!="ACE " ){
                  if( b!=" N  " )MISSINGBSE=true;
               }
            }else if( ci=='s' ){
            }else if( ci=='r' ){
               if( b!=" C5'" )MISSINGBSE=true;
            }else if( ci=='p' ){
               if( (a!="5OH ")&&(a!="5PO ") ){
                  jR0--;
                  if( b!=" O3'" )MISSINGBSE=true;
               }
            }else if( ci=='b' ){
               if( (b!=" N1 ")&&(b!=" N9 ") )MISSINGBSE=true;
            }
            if( MISSINGBSE ){
               std::cerr<<"ERROR: Missing atom in PDB file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0+2)
                        <<" aa="<<a<<".\n";
               std::exit( 1);
            }
            int jL0=R0[jR0].L0;
            char cj=residue_mappings.L0[jL0].c1;
            std::string g=residue_mappings.L0[jL0].aa;
            std::string jnt="";
            bool MISSINGJNT=false;
            if      ( ci=='a' ){
               jnt=" C  ";
               if( cj=='a' )MISSINGJNT=true;
               if( cj=='e' ){
                  if( (g!="NME ")&&(g!="NH2 ") )MISSINGJNT=true;
               }
            }else if( ci=='e' ){
               if( a!="ACE " ){
                  jnt=" C  ";
                  if( cj=='a' )MISSINGJNT=true;
               }
            }else if( ci=='s' ){
            }else if( ci=='r' ){
               jnt=" O5'";
               if( cj=='p' ){
                  if( (g!="3OH ")&&(g!="3PO ") )MISSINGJNT=true;
               }
            }else if( ci=='p' ){
               if( (a!="5OH ")&&(a!="5PO ") ){
                  jnt=" C3'";
                  if( cj=='r' )MISSINGJNT=true;
               }
            }else if( ci=='b' ){
               jnt=" C1'";
               if( cj=='r' )MISSINGJNT=true;
            }
            int mP1=R0[jR0].P1a;
            int nP1=(mP1-1+R0[jR0].cP1);
            double zR= (1.00e+8);
            for(int kP1=mP1;kP1<=nP1;kP1++){
               if( P1[kP1].sub==0 )continue;
               if( P1[kP1].atm==jnt ){
                  MISSINGJNT=false;
                  Coordinates zD=( P1[kP1].x -x);
                  zR= zD.r();
               }
            }
            if( MISSINGJNT ){
               std::cerr<<"ERROR: Missing atom in PDB file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(jR0+1)
                        <<" aa="<<g<<".\n";
               std::exit( 1);
            }
            if( zR>(2.10) ){
               if( cj=='s' ){
               }else{
                  if( Z0[iZ0].cR0== 1 ){
                     std::cerr<<"ERROR: Peptide or nucleotide chain"
                              <<" consisting of 1 residue."
                              <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                              <<" iR0="<< std::setw( 4)<<(Z0[iZ0].R0a+1)
                              <<" aa="<<aa<<".\n";
                     std::exit( 1);
                  }
               }
               if( cj=='a' ){
                  aa[3]='e';
                  R0[iR0].aa=aa;
                  R0[iR0].L0=residue_mappings.iresidue( aa);
                  if( R0[iR0].L0==-1 ){
                     std::cerr<<"ERROR: Unmatched residue name in PDB file."
                              <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                              <<" iR0="<< std::setw( 4)<<(iR0+1)
                              <<" aa="<<aa<<".\n";
                     std::exit( 1);
                  }
                  R0[iR0].cP1++;
                  jP1++;
                  P1[jP1].atm=" OXT";
                  P1[jP1].typ=13;
                  P1[jP1].sc=0;
               }
               Z0.push_back( tZ0());
               iZ0++;
               Z0[iZ0].R0a=(iR0+1);
               Z0[iZ0].cR0=0;
            }
         }
         R0.push_back( tR0());
         iR0++;
         Z0[iZ0].cR0++;
         aa=rec.substr(17, 4);
         if( (iR0==Z0[iZ0].R0a)&&(ci=='a') ){
            aa='e'+aa.substr(0,3);
         }
         R0[iR0].aa=aa;
         R0[iR0].L0=residue_mappings.iresidue( aa);
         if( R0[iR0].L0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in PDB file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         R0[iR0].core='|';
         int iL0=R0[iR0].L0;
         if( int(P1.size())>(jP1+1) ){
            P1.pop_back();
         }
         R0[iR0].P1a=(jP1+1);
         R0[iR0].cP1=residue_mappings.L0[iL0].cP0;
         int mP0=residue_mappings.L0[iL0].P0a;
         int nP0=(mP0-1+residue_mappings.L0[iL0].cP0);
         int iP1=jP1;
         for(int iP0=mP0;iP0<=nP0;iP0++){
            P1.push_back( tP1());
            iP1++;
            P1[iP1].atm=residue_mappings.P0[iP0].atm;
            P1[iP1].typ=residue_mappings.P0[iP0].typ;
            P1[iP1].sc=residue_mappings.P0[iP0].sc;
            P1[iP1].sub=0;
         }
         jP1+=R0[iR0].cP1;
         if( ci=='a' ){
            P1.push_back( tP1());
            P1[jP1+1].sub=0;
         }
         R0[iR0].cha=rec[21];
         std::istringstream(rec.substr(22, 4))>>R0[iR0].res;
         R0[iR0].ins=rec[26];
      }
      std::string atm=rec.substr(12, 4);
      int mP1=R0[iR0].P1a;
      int nP1=(mP1-1+R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( P1[iP1].atm==atm ){
            P1[iP1].sub=1;
            P1[iP1].x=x;
            atm="xxxx";
         }
      }
      if( atm!="xxxx" ){
         buf=atm[1];
         if      ( (ci=='a')&&(buf=='O') ){
            P1[nP1+1].sub=1;
            P1[nP1+1].x=x;
         }else if( buf=='H' ){
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( (P1[iP1].sub==0)&&
                   (P1[iP1].atm.substr( 1, 2)==atm.substr( 1, 2)) ){
                  P1[iP1].sub=1;
                  P1[iP1].x=x;
                  break;
               }
            }
         }else if( buf=='L' ){
         }else if( buf=='Q' ){
         }else{
            std::cerr<<"ERROR: Unmatched atom name in PDB file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
      }
   }

   nZ0=(iZ0+1);
   char cj=residue_mappings.L0[R0[iR0].L0].c1;
   if( cj=='s' ){
   }else{
      if( Z0[iZ0].cR0== 1 ){
         std::cerr<<"ERROR: Peptide or nucleotide chain"
                  <<" consisting of 1 residue."
                  <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                  <<" iR0="<< std::setw( 4)<<(Z0[iZ0].R0a+1)
                  <<" aa="<<aa<<".\n";
         std::exit( 1);
      }
   }
   if( cj=='a' ){
      aa[3]='e';
      R0[iR0].aa=aa;
      R0[iR0].L0=residue_mappings.iresidue( aa);
      if( R0[iR0].L0==-1 ){
         std::cerr<<"ERROR: Unmatched residue name in PDB file."
                  <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                  <<" iR0="<< std::setw( 4)<<(iR0+1)
                  <<" aa="<<aa<<".\n";
         std::exit( 1);
      }
      R0[iR0].cP1++;
      jP1++;
      P1[jP1].atm=" OXT";
      P1[jP1].typ=13;
      P1[jP1].sc=0;
   }
   if( int(P1.size())>(jP1+1) ){
      P1.pop_back();
   }
   ifile.close();
//
//
// disulfide bonds
//
   nS0=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aa=R0[iR0].aa;
         if( (aa.substr(0,3)!="CYS")&&(aa.substr(1,3)!="CYS") )continue;
         int iP1=(R0[iR0].P1a-1+10);
         if( P1[iP1].sub!=1 ){
            std::cerr<<"ERROR: Missing atom in PDB file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<R0[iR0].aa<<".\n";
            std::exit( 1);
         }
         int jZ0min=iZ0;
         int jZ0max=(nZ0-1);
         for(int jZ0=jZ0min;jZ0<=jZ0max;jZ0++){
            int jR0min=( jZ0==iZ0 )? (iR0+1): Z0[jZ0].R0a;
            int jR0max=(Z0[jZ0].R0a-1+Z0[jZ0].cR0);
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               aa=R0[jR0].aa;
               if( (aa.substr(0,3)!="CYS")&&(aa.substr(1,3)!="CYS") )continue;
               int jP1=(R0[jR0].P1a-1+10);
               if( P1[jP1].sub!=1 )continue;
               Coordinates zD=( P1[jP1].x -P1[iP1].x);
               double zR= zD.r();
               if( zR<(2.80) ){
                  S0.push_back( tS0());
                  for(int i=0;i<2;i++){
                     o_S0N2Z0.push_back(-1);
                     o_S0N2R0.push_back(-1);
                  }
                  S0N2Z0(nS0,0)=iZ0;
                  S0N2R0(nS0,0)=iR0;
                  S0N2Z0(nS0,1)=jZ0;
                  S0N2R0(nS0,1)=jR0;
                  nS0++;
               }
            }
         }
      }
   }
//
//
// free cysteine
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aa=R0[iR0].aa;
         if( (aa.substr(0,3)!="CYS")&&(aa.substr(1,3)!="CYS") )continue;
         bool FREECYS=true;
         for(int iS0=0;iS0<nS0;iS0++){
            for(int iN2=0;iN2<2;iN2++){
               if( (S0N2Z0(iS0,iN2)==iZ0)&&
                   (S0N2R0(iS0,iN2)==iR0) ){
                  FREECYS=false;
               }
            }
         }
         if( FREECYS ){
            aa.replace(aa.find("CYS"),3,"CYH");
            R0[iR0].aa=aa;
            R0[iR0].L0=residue_mappings.iresidue( aa);
            if( R0[iR0].L0==-1 ){
               std::cerr<<"ERROR: Unmatched residue name in PDB file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0+1)
                        <<" aa="<<aa<<".\n";
               std::exit( 1);
            }
            P1.push_back( tP1());
            int iP1=(R0[iR0].P1a-1+10);
            int jZ0max=(nZ0-1);
            int jZ0min=iZ0;
            for(int jZ0=jZ0max;jZ0>=jZ0min;jZ0--){
               int jR0max=(Z0[jZ0].R0a-1+Z0[jZ0].cR0);
               int jR0min=( jZ0==iZ0 )? iR0: Z0[jZ0].R0a;
               for(int jR0=jR0max;jR0>=jR0min;jR0--){
                  int jP1max=(R0[jR0].P1a-1+R0[jR0].cP1);
                  int jP1min=( jR0==iR0 )? (iP1+1): R0[jR0].P1a;
                  if( jR0>iR0 ){
                     R0[jR0].P1a++;
                  }
                  for(int jP1=jP1max;jP1>=jP1min;jP1--){
                     P1[jP1+1].atm=P1[jP1].atm;
                     P1[jP1+1].typ=P1[jP1].typ;
                     P1[jP1+1].sc=P1[jP1].sc;
                     P1[jP1+1].sub=P1[jP1].sub;
                     if( P1[jP1].sub==1 ){
                        P1[jP1+1].x=P1[jP1].x;
                     }
                  }
               }
            }
            R0[iR0].cP1++;
            P1[iP1+1].atm=" HG ";
            P1[iP1+1].typ= 3;
            P1[iP1+1].sc=1;
            P1[iP1+1].sub=0;
         }
      }
   }
//
//
// class name
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         R0[iR0].c1=residue_mappings.L0[iL0].c1;
      }
   }
//
//
// ensure coordinates for CD of ePRO
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int iR0=Z0[iZ0].R0a;
      std::string aa=R0[iR0].aa;
      if( aa!="ePRO" )continue;
      int iP1=iatom(iR0  ," CD ");
      if( P1[iP1].sub!=0 )continue;
      int jP1=iatom(iR0  ," N  ");
      int kP1=iatom(iR0  ," CA ");
      int lP1=iatom(iR0  ," C  ");
      if( (P1[jP1].sub==1)&&
          (P1[kP1].sub==1)&&
          (P1[lP1].sub==1) ){
         Coordinates u=( P1[kP1].x -P1[jP1].x).normalize();
         Coordinates v=( P1[lP1].x -P1[kP1].x);
         double vu= dot(v,u);
         v-=vu*u;
         v.normalize();
         v*=(-1.00);
         Coordinates w= cross(u,v);
         double C= std::cos((  65.00));
         double S= std::sin((  65.00));
         Coordinates p;
         p(0)=(  C*v(0) +S*w(0));
         p(1)=(  C*v(1) +S*w(1));
         p(2)=(  C*v(2) +S*w(2));
         C= std::cos(( 113.00));
         S= std::sin(( 113.00));
         Coordinates x;
         x(0)=(  C*u(0) +S*p(0));
         x(1)=(  C*u(1) +S*p(1));
         x(2)=(  C*u(2) +S*p(2));
         P1[iP1].sub=1;
         P1[iP1].x=( P1[jP1].x +(1.46)*x);
      }
   }
   return;
}
