#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <cmath>

void Structure::POLARH(const DAT_PHYSICS_CONSTS& physics_consts,
                       const DAT_RESIDUE_MAPPINGS& residue_mappings){
   Rotation_Matrix P;
   Coordinates x;
   double Gphi[15];
   Coordinates Gx[15];
//
//
//
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int iL0=residue_mappings.iresidue( aa);
         if( iL0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in residue data."
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
//
//
// add position for polar hydrogen
//
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==1 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2!= 2)&&(iT2!= 5)&&
                ((aa!="CYH ")||(atm!=" HG ")) )continue;
            int iP2=residue_mappings.ip2atom(iL0,atm);
            if( iP2==-1 )continue;
//          int j0R0=iR0;
            int j0P1=iP1;
            int j1R0=(iR0+residue_mappings.P2[iP2].grp1);
            if( j1R0<mR0 )continue;
            if( j1R0>nR0 )continue;
            int j2R0=(iR0+residue_mappings.P2[iP2].grp2);
            if( j2R0<mR0 )continue;
            if( j2R0>nR0 )continue;
            int j3R0=(iR0+residue_mappings.P2[iP2].grp3);
            if( j3R0<mR0 )continue;
            if( j3R0>nR0 )continue;
            std::string atm1=residue_mappings.P2[iP2].atm1;
            std::string atm2=residue_mappings.P2[iP2].atm2;
            std::string atm3=residue_mappings.P2[iP2].atm3;
            int j1P1=iatom(j1R0,atm1);
            if( j1P1==-1 )continue;
            int j2P1=iatom(j2R0,atm2);
            if( j2P1==-1 )continue;
            int j3P1=iatom(j3R0,atm3);
            if( j3P1==-1 )continue;
            if( P1[j1P1].sub==0 )continue;
            if( P1[j2P1].sub==0 )continue;
            if( P1[j3P1].sub==0 )continue;

            Coordinates u=( P1[j1P1].x -P1[j2P1].x);
            u.normalize();
            Coordinates v=( P1[j3P1].x -P1[j2P1].x);
            double vu= dot(v,u);
            v-=vu*u;
            v.normalize();
            Coordinates w= cross(u,v);

            P(0,0)= u(0);
            P(1,0)= u(1);
            P(2,0)= u(2);
            P(0,1)= v(0);
            P(1,1)= v(1);
            P(2,1)= v(2);
            P(0,2)= w(0);
            P(1,2)= w(1);
            P(2,2)= w(2);

            double D= residue_mappings.P2[iP2].dst;
            double the=( (180.00) -residue_mappings.P2[iP2].lam)
                       *physics_consts.RAD;
            double CT= std::cos( the);
            double ST= std::sin( the);
            double phi= residue_mappings.P2[iP2].chi;
            if( phi>(999.) )phi= (180.00);
            int nG=1;
            Gphi[ 0]= phi;
            if( (iT2== 5)||(iT2== 3) ){
               if( (aa=="SER ")||(aa=="THR ")||(aa=="CYH ")||
                   (aa=="HPR ")||(aa=="R   ")||(aa=="5OH ")||
                   (aa=="3OH ") ){
                  nG=15;
                  Gphi[ 1]= (-165.00);
                  Gphi[ 2]= (-150.00);
                  Gphi[ 3]= ( -90.00);
                  Gphi[ 4]= ( -75.00);
                  Gphi[ 5]= ( -60.00);
                  Gphi[ 6]= ( -45.00);
                  Gphi[ 7]= ( -30.00);
                  Gphi[ 8]= (  30.00);
                  Gphi[ 9]= (  45.00);
                  Gphi[10]= (  60.00);
                  Gphi[11]= (  75.00);
                  Gphi[12]= (  90.00);
                  Gphi[13]= ( 150.00);
                  Gphi[14]= ( 165.00);
               }else if( aa=="TYR " ){
                  nG=6;
                  Gphi[ 1]= (-165.00);
                  Gphi[ 2]= ( -15.00);
                  Gphi[ 3]= (   0.00);
                  Gphi[ 4]= (  15.00);
                  Gphi[ 5]= ( 165.00);
               }
            }
            int jG=0;
            double Rmin= (5.00);
            for(int iG=0;iG<nG;iG++){
               phi= Gphi[iG]*physics_consts.RAD;
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               x(0)= D*CT;
               x(1)= D*ST*CP;
               x(2)= D*ST*SP;
               Gx[iG].generate(P1[j1P1].x,P,x);
               if( (iT2== 5)||(iT2== 3) ){
                  Coordinates u=( Gx[iG] -P1[j1P1].x);
                  u.normalize();
                  double Racc= (1.00e+6);
                  double Rdon= (1.00e+6);
                  for(int jZ0=0;jZ0<nZ0;jZ0++){
                     int jR0min=Z0[jZ0].R0a;
                     int jR0max=(jR0min-1+Z0[jZ0].cR0);
                     for(int jR0=jR0min;jR0<=jR0max;jR0++){
                        int jP1min=R0[jR0].P1a;
                        int jP1max=(jP1min-1+R0[jR0].cP1);
                        for(int jP1=jP1min;jP1<=jP1max;jP1++){
                           if( jP1==j0P1 )continue;
                           if( jP1==j1P1 )continue;
                           if( jP1==j2P1 )continue;
                           if( P1[jP1].sub==0 )continue;
                           int jT2=P1[jP1].typ;
                           if( (jT2==12)||(jT2==13)||(jT2==14)||
                               (jT2==15)||(jT2==17) ){
                              Coordinates e=( P1[jP1].x -Gx[iG]);
                              double R= e.r();
                              if( R<Racc ){
                                 e.normalize();
                                 double Cthe= dot(u,e);
                                 the= std::acos( Cthe)
                                     /physics_consts.RAD;
                                 if( the<( 60.00) ){
                                    Racc= R;
                                 }
                              }
                           }else if( (jT2== 2)||(jT2== 5) ){
                              Coordinates e=( P1[jP1].x -Gx[iG]);
                              double R= e.r();
                              if( R<Rdon ){
                                 e.normalize();
                                 double Cthe= dot(u,e);
                                 the= std::acos( Cthe)
                                     /physics_consts.RAD;
                                 if( the<(120.00) ){
                                    Rdon= R;
                                 }
                              }
                           }
                        }
                     }
                  }
                  if( Rdon<Racc ){
                     Racc+=(8.00)*( Racc -Rdon);
                  }
                  if( Racc<Rmin ){
                     jG=iG;
                     Rmin= Racc;
                  }
               }
            }
            P1[j0P1].sub=1;
            P1[j0P1].x= Gx[jG];
         }
//
//
// add position for N-terminal hydrogen
//
         if( (iR0==mR0)&&
             (c1=='a')&&
             ((iZ0== 0)||(R0[mR0].cha!=R0[mR0-1].cha)) ){
            for(int j0P1=mP1;j0P1<=nP1;j0P1++){
               std::string atm=P1[j0P1].atm;
               if( (atm!="1H  ")&&(atm!="2H  ")&&(atm!="3H  ") )continue;
               if( P1[j0P1].typ!= 2 )continue;
               if( P1[j0P1].sub==1 )continue;
               int j1P1=iatom(iR0  ," N  ");
               int j2P1=iatom(iR0  ," CA ");
               int j3P1=iatom(iR0  ," C  ");
               int j4P1=iatom(iR0  ," CD ");
               if( (aa=="PRO ")||(aa=="HPR ") )j3P1=j4P1;
               if( j1P1==-1 )continue;
               if( j2P1==-1 )continue;
               if( j3P1==-1 )continue;
               if( P1[j1P1].sub==0 )continue;
               if( P1[j2P1].sub==0 )continue;
               if( P1[j3P1].sub==0 )continue;

               Coordinates u=( P1[j1P1].x -P1[j2P1].x);
               u.normalize();
               Coordinates v=( P1[j3P1].x -P1[j2P1].x);
               double vu= dot(v,u);
               v-=vu*u;
               v.normalize();
               Coordinates w= cross(u,v);

               P(0,0)= u(0);
               P(1,0)= u(1);
               P(2,0)= u(2);
               P(0,1)= v(0);
               P(1,1)= v(1);
               P(2,1)= v(2);
               P(0,2)= w(0);
               P(1,2)= w(1);
               P(2,2)= w(2);

               double D= (1.00);
               double the=( (180.00) -(109.47))*physics_consts.RAD;
               double CT= std::cos( the);
               double ST= std::sin( the);
               double phi= ( 180.00);
               if( (aa=="PRO ")||(aa=="HPR ") ){
                  if      ( atm=="2H  " ){
                     phi= (-120.00)*physics_consts.RAD;
                  }else if( atm=="1H  " ){
                     phi= ( 120.00)*physics_consts.RAD;
                  }
               }else{
                  if      ( atm=="2H  " ){
                     phi= ( -60.00)*physics_consts.RAD;
                  }else if( atm=="3H  " ){
                     phi= (  60.00)*physics_consts.RAD;
                  }else if( atm=="1H  " ){
                     phi= ( 180.00)*physics_consts.RAD;
                  }
               }
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               x(0)= D*CT;
               x(1)= D*ST*CP;
               x(2)= D*ST*SP;
               P1[j0P1].sub=1;
               P1[j0P1].x.generate(P1[j1P1].x,P,x);
            }
         }
//
//
// add position for C-terminal oxygen
//
         if( (iR0==nR0)&&
             (c1=='a')&&
             ((iZ0==(nZ0-1))||(R0[nR0].cha!=R0[nR0+1].cha)) ){
            for(int j0P1=nP1;j0P1<=nP1;j0P1++){
               if( P1[j0P1].atm!=" OXT" )continue;
               if( P1[j0P1].typ!=13 )continue;
               if( P1[j0P1].sub==1 )continue;
               int j1P1=iatom(iR0  ," C  ");
               int j2P1=iatom(iR0  ," CA ");
               int j3P1=iatom(iR0  ," O  ");
               if( j1P1==-1 )continue;
               if( j2P1==-1 )continue;
               if( j3P1==-1 )continue;
               if( P1[j1P1].sub==0 )continue;
               if( P1[j2P1].sub==0 )continue;
               if( P1[j3P1].sub==0 )continue;

               Coordinates u=( P1[j1P1].x -P1[j2P1].x);
               u.normalize();
               Coordinates v=( P1[j3P1].x -P1[j2P1].x);
               double vu= dot(v,u);
               v-=vu*u;
               v.normalize();
               Coordinates w= cross(u,v);

               P(0,0)= u(0);
               P(1,0)= u(1);
               P(2,0)= u(2);
               P(0,1)= v(0);
               P(1,1)= v(1);
               P(2,1)= v(2);
               P(0,2)= w(0);
               P(1,2)= w(1);
               P(2,2)= w(2);

               double D= (1.231);
               double the=( (180.00) -(114.50))*physics_consts.RAD;
               double CT= std::cos( the);
               double ST= std::sin( the);
               double phi= (180.00)*physics_consts.RAD;
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               x(0)= D*CT;
               x(1)= D*ST*CP;
               x(2)= D*ST*SP;
               P1[j0P1].sub=1;
               P1[j0P1].x.generate(P1[j1P1].x,P,x);
            }
         }

      }
   }
//
//
// correct short bond lengths to polar H
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2!= 2)&&(iT2!= 5) )continue;
            for(int jP1=mP1;jP1<=nP1;jP1++){
               if( P1[jP1].sub==0 )continue;
               if( jP1==iP1 )continue;
               Coordinates h=( P1[iP1].x -P1[jP1].x);
               if( h.r()<(.999) ){
                  h.normalize();
                  P1[iP1].x=( P1[jP1].x +h);
               }
            }
         }
      }
   }
   return;
}
