#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>

void Search_Subspace::PCKSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                             const std::vector<Structure>& G9str){
//
//
// composite structure
//
   Structure str;
   str=G9str[ 0];
   int oG9=G9str.size();
   for(int iG9= 1;iG9<oG9;iG9++){
      str+=G9str[iG9];
   }
//
//
// composite subspace
//
   nR1=0;
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if      ( c1=='a' ){
            if( aa=="ALA " )continue;
            if( aa=="GLY " )continue;
            if( aa=="PRO " )continue;
            if( aa=="AIB " )continue;
            if( aa=="UNK " )continue;
         }else if( c1=='e' ){
            continue;
         }else if( c1=='r' ){
            if( aa=="D   " )continue;
            if( aa=="R   " )continue;
            if( aa=="RF  " )continue;
            if( aa=="LNA " )continue;
            if( aa=="CET " )continue;
         }else if( c1=='b' ){
            if( aa=="N   " )continue;
            continue;
         }else if( c1=='p' ){
            continue;
         }else if( c1=='s' ){
            continue;
         }
         R1.push_back( tR1());
         R1[nR1].Z0=iZ0;
         R1[nR1].R0=iR0;
         R1[nR1].L0=str.R0[iR0].L0;
         R1[nR1].aa=str.R0[iR0].aa;
         R1[nR1].bb=0;
         if( aa=="PRO " ){
            R1[nR1].sc=1;
         }else{
            R1[nR1].sc=2;
         }
         R1[nR1].pt=0;
         nR1++;
      }
   }
//
//
// populate Search_Subspace to level of fil2stp
//
   R3.clear();
   int mR3=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      R1[iR1].R3a=mR3;
      R1[iR1].cR3=1;
      R3.push_back( Search_Subspace::tR3());
      R3[mR3].aa=R1[iR1].aa;
      R3[mR3].L0=R1[iR1].L0;
      mR3++;
   }
   T5.clear();
   int mT5=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      int iR0=R1[iR1].R0;
      char c1=str.R0[iR0].c1;
      std::string aa=str.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      R1[iR1].T5a=mT5;
      R1[iR1].cT5=str.R0[iR0].cT1;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         T5.push_back( tT5());
         T5[iT1-mT1+mT5].tor=str.T1[iT1].tor;
      }
      mT5+=R1[iR1].cT5;
   }

   return;
}
