#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../set/Mechanical_System.hh"

void Search_Subspace::MECHSYS(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              const Mechanical_System& mol){
//
//
// connect search subspace to mechanical system
//
   for(int iR1= 0;iR1<nR1;iR1++){
      int iZ0=R1[iR1].Z0;
      int iR0=R1[iR1].R0;
      int mQ1=mol.Z0[iZ0].Q1a;
      R1[iR1].Q1bb=mQ1;
      R1[iR1].Q1sc=(mQ1-1+mol.Z0[iZ0].cQ1bb);
      int mR0=mol.Z0[iZ0].R0a;
      for(int jR0=mR0;jR0<iR0;jR0++){
          int jL0=mol.R0[jR0].L0;
          int nSC=residue_mappings.L0[jL0].cU0;
          int nBB=(residue_mappings.L0[jL0].cQ0-nSC);
          R1[iR1].Q1bb+=nBB;
          R1[iR1].Q1sc+=nSC;
      }
   }
   return;
}
