#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_fil2tor {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_fil2tor(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

void Structure::FIL2TOR(const DAT_PHYSICS_CONSTS& physics_consts){
   MEM_fil2tor vv;

   std::string filename="../../"+fam+"/tor/tor."+mol+"."+cnf;
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   int p=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      std::istringstream irec(vv.Lrec(p++).substr( 3,72));
      for(int i=0;i<3;i++){
         irec>>Z0[iZ0].trans(i);
      }
      Z0[iZ0].trans/=physics_consts.ANG;
      for(int i=0;i<3;i++){
         irec>>Z0[iZ0].rot(i);
      }
      Z0[iZ0].rot*=physics_consts.RAD;
   }
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      p+=1;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=vv.Lrec(p  ).substr( 0, 4);
         if( aa!=R0[iR0].aa ){
            std::cerr<<"ERROR: Inconsistency of TOR file"
                     <<" with SEQ file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         char c1=R0[iR0].c1;
         std::istringstream irec(vv.Lrec(p++).substr( 5,108));
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if( (c1=='a')&&
                ((aa[3]=='e')||(aa[3]=='z'))&&
                (iT1==(mT1+2)) )continue;
            irec>>T1[iT1].chi;
         }
      }
   }

   return;
}
