#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_fil2stp {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_fil2stp(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

void Search_Subspace::FIL2STP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              const Structure& str,
                              const Thread_Options& opt){
   MEM_fil2stp vv;
   std::string filename="../../"+str.fam+"/stp/stp."+opt.QSUB+"."+str.mol;
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   int p=0;
   std::istringstream(vv.Lrec(p++))>>nR1;
   int mR3=0;
   for(int iR1=0;iR1<nR1;iR1++){
      R1.push_back( tR1());
      std::istringstream(vv.Lrec(p  ).substr( 1, 2))>>R1[iR1].Z0;
      int iZ0=(--R1[iR1].Z0);
      int mR0=str.Z0[iZ0].R0a;
      std::istringstream(vv.Lrec(p  ).substr( 4, 4))>>R1[iR1].R0;
      int iR0=(R1[iR1].R0+=(mR0-1));
      R1[iR1].L0=str.R0[iR0].L0;
      R1[iR1].aa=str.R0[iR0].aa;
      std::istringstream(vv.Lrec(p  ).substr(10, 4))>>R1[iR1].bb
                                                    >>R1[iR1].sc;
      std::istringstream(vv.Lrec(p  ).substr(14, 2))>>R1[iR1].pt;
      std::string cat=vv.Lrec(p++).substr( 18,112);
      R1[iR1].ortho=0;
//
// unpack concatenated names of allowed residues
//
      R1[iR1].R3a=mR3;
      R1[iR1].cR3=int( cat.size())/4;
      bool MATCH=false;
      int nR3=(mR3-1+R1[iR1].cR3);
      for(int iR3=mR3;iR3<=nR3;iR3++){
         std::string aa=cat.substr( (iR3-mR3)*4, 4);
         if( (iR3==mR3)&&(aa==str.R0[iR0].aa) )MATCH=true;
         int iL0=residue_mappings.iresidue( aa);
         if( iL0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in STP file."
                     <<" iR1="<< std::setw( 4)<<iR1
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         R3.push_back( tR3());
         R3[iR3].aa=aa;
         R3[iR3].L0=iL0;
      }
      if( !MATCH ){
         std::cerr<<"ERROR: Inconsistency of STP file"
                  <<" with SEQ file."
                  <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                  <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                  <<" aa="<<str.R0[iR0].aa<<".\n";
         std::exit( 1);
      }
      mR3+=R1[iR1].cR3;
   }

   mBOD=0;
   if( str.nZ0> 1 ){
      for(int iR1=0;iR1<nR1;iR1++){
         if( R1[iR1].bb==0 )continue;
         int iZ0=R1[iR1].Z0;
         int iR0=R1[iR1].R0;
         int mR0=str.Z0[iZ0].R0a;
         if( iR0==mR0 )mBOD=1;
      }
   }

   int mT5=0;
   for(int iR1=0;iR1<nR1;iR1++){
      int iR0=R1[iR1].R0;
      int iL0=R1[iR1].L0;
      char c1=residue_mappings.L0[iL0].c1;
      std::string aa=R1[iR1].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      R1[iR1].T5a=mT5;
      R1[iR1].cT5=str.R0[iR0].cT1;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         T5.push_back( tT5());
         T5[iT1-mT1+mT5].tor=str.T1[iT1].tor;
      }
      mT5+=R1[iR1].cT5;
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )R1[iR1].ca=str.P1[iP1].x;
            if( atm==" CB " )R1[iR1].cb=str.P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CM'" )R1[iR1].cb=str.P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CA'" )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" N1 " )R1[iR1].cb=str.P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" C4 " )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }

   return;
}
