#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_fil2seq {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_fil2seq(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

void Structure::FIL2SEQ(const DAT_RESIDUE_MAPPINGS& residue_mappings){
   MEM_fil2seq vv;

   std::string filename="../../"+fam+"/seq/seq."+mol;
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   int p=0;
   std::istringstream(vv.Lrec(p++).substr( 1, 4))>>nZ0;
   int mR0=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      Z0.push_back( tZ0());
      Z0[iZ0].R0a=mR0;
      std::istringstream(vv.Lrec(p++).substr( 1, 4))>>Z0[iZ0].cR0;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int n=(Z0[iZ0].cR0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,80);
      }
      int i=0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tR0());
         R0[iR0].core=rec[i];
         R0[iR0].aa=rec.substr(i+1, 4);
         i+=5;
      }
      mR0+=Z0[iZ0].cR0;
   }
   std::istringstream(vv.Lrec(p++).substr( 1, 4))>>nS0;
   if( nS0>0 ){
      for(int iS0=0;iS0<nS0;iS0++){
         S0.push_back( tS0());
         for(int i=0;i<2;i++){
            o_S0N2Z0.push_back(-1);
            o_S0N2R0.push_back(-1);
         }
         std::istringstream irec(vv.Lrec(p++).substr( 0,20));
         for(int iN2=0;iN2<2;iN2++){
            irec>>S0N2Z0(iS0,iN2) >>S0N2R0(iS0,iN2);
            S0N2Z0(iS0,iN2)--;
            int iZ0=S0N2Z0(iS0,iN2);
            S0N2R0(iS0,iN2)+=(Z0[iZ0].R0a-1);
         }
      }
   }

   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         R0[iR0].L0=residue_mappings.iresidue( aa);
         if( R0[iR0].L0==-1 ){
            std::cerr<<"ERROR: Unmatched residue name in SEQ file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                     <<" aa="<<aa<<".\n";
            std::exit( 1);
         }
         R0[iR0].c1=residue_mappings.L0[R0[iR0].L0].c1;
         R0[iR0].C7=3;
      }
   }
   std::string chain=" ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
   int jZ0=( nZ0> 1 )? 1: 0;
   int iT1=0;
   int iP1=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         int mT0=residue_mappings.L0[iL0].T0a;
         int nT0=(mT0-1+residue_mappings.L0[iL0].cT0);
         R0[iR0].T1a=iT1;
         R0[iR0].cT1=(nT0-mT0+1);
         for(int iT0=mT0;iT0<=nT0;iT0++){
            T1.push_back( tT1());
            T1[iT1].tor=residue_mappings.T0[iT0].tor;
            iT1++;
         }
         int mP0=residue_mappings.L0[iL0].P0a;
         int nP0=(mP0-1+residue_mappings.L0[iL0].cP0);
         R0[iR0].P1a=iP1;
         R0[iR0].cP1=(nP0-mP0+1);
         for(int iP0=mP0;iP0<=nP0;iP0++){
            P1.push_back( tP1());
            P1[iP1].sub=0;
            P1[iP1].atm=residue_mappings.P0[iP0].atm;
            P1[iP1].typ=residue_mappings.P0[iP0].typ;
            P1[iP1].sc=residue_mappings.P0[iP0].sc;
            iP1++;
         }
         R0[iR0].cha=chain[jZ0+iZ0];
         R0[iR0].res=(iR0-mR0+1);
         R0[iR0].ins=' ';
      }
   }
   return;
}
