#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>

class MEM_fil2cha {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_fil2cha(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

void Structure::FIL2CHA(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const DAT_IGOR_DATA& igor_data){
   MEM_fil2cha vv;

   std::string filename="../../"+fam+"/exp/seq."+mol;
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   int p=0;
   nZ0=1;
   Z0.push_back( tZ0());
   Z0[ 0].R0a=0;
   std::istringstream(vv.Lrec(p++).substr( 0, 4))>>Z0[ 0].cR0;
   int oR0=Z0[ 0].cR0;
   int n=(oR0+99)/100;
   rec.clear();
   for(int i=0;i<n;i++){
      rec+=vv.Lrec(p++).substr( 0,100);
   }
   for(int iR0=0;iR0<oR0;iR0++){
      R0.push_back( tR0());
      char a1=rec[iR0];
      int iL1=igor_data.iresidue( a1);
      if( iL1==-1 ){
         std::cerr<<"ERROR: Unmatched 1-letter residue name in file "
                   +filename.erase( 0, 6)+".\n";
         std::exit( 1);
      }
      R0[iR0].L1=iL1;
      R0[iR0].core='|';
      std::string a3=igor_data.L1[iL1].a3;
      if( a3=="CYS" )a3="CYH";
      std::string aa;
      if( iR0== 0 ){
         aa='e'+a3;
      }else if( iR0==(oR0-1) ){
         aa=a3+'e';
      }else{
         aa=a3+' ';
      }
      R0[iR0].aa=aa;
      R0[iR0].L0=residue_mappings.iresidue( aa);
      R0[iR0].c1='a';
   }
   std::istringstream(vv.Lrec(p++).substr( 0, 4))>>nS0;
   for(int iS0= 0;iS0<nS0;iS0++){
      S0.push_back( tS0());
      o_S0N2Z0.push_back( 0);
      o_S0N2Z0.push_back( 0);
      int iR0( 0),jR0( 0);
      std::istringstream(vv.Lrec(p++).substr( 0, 8))>>iR0>>jR0;
      o_S0N2R0.push_back( --iR0);
      o_S0N2R0.push_back( --jR0);
      std::string ai="CYS ";
      if( iR0== 0 ){
         ai="eCYS";
      }else if( iR0==(oR0-1) ){
         ai="CYSe";
      }
      R0[iR0].aa=ai;
      R0[iR0].L0=residue_mappings.iresidue( ai);
      std::string aj="CYS ";
      if( jR0== 0 ){
         aj="eCYS";
      }else if( jR0==(oR0-1) ){
         aj="CYSe";
      }
      R0[jR0].aa=aj;
      R0[jR0].L0=residue_mappings.iresidue( aj);
   }
   rec.clear();
   for(int i=0;i<n;i++){
      rec+=vv.Lrec(p++).substr( 0,100);
   }
   for(int iR0= 0;iR0<oR0;iR0++){
      R0[iR0].path=rec[iR0];
   }

   int iT1=0;
   int iP1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=R0[iR0].L0;
      int mT0=residue_mappings.L0[iL0].T0a;
      int nT0=(mT0-1+residue_mappings.L0[iL0].cT0);
      R0[iR0].T1a=iT1;
      R0[iR0].cT1=(nT0-mT0+1);
      for(int iT0=mT0;iT0<=nT0;iT0++){
         T1.push_back( tT1());
         T1[iT1].tor=residue_mappings.T0[iT0].tor;
         iT1++;
      }
      int mP0=residue_mappings.L0[iL0].P0a;
      int nP0=(mP0-1+residue_mappings.L0[iL0].cP0);
      R0[iR0].P1a=iP1;
      R0[iR0].cP1=(nP0-mP0+1);
      for(int iP0=mP0;iP0<=nP0;iP0++){
         P1.push_back( tP1());
         P1[iP1].sub=0;
         P1[iP1].atm=residue_mappings.P0[iP0].atm;
         P1[iP1].typ=residue_mappings.P0[iP0].typ;
         P1[iP1].sc=residue_mappings.P0[iP0].sc;
         iP1++;
      }
      R0[iR0].cha=' ';
      R0[iR0].res=(iR0+1);
      R0[iR0].ins=' ';
   }
   return;
}
