#include "../fil/Structure.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_fil2car {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_fil2car(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

void Structure::FIL2CAR(){
   MEM_fil2car vv;

   std::string filename="../../"+fam+"/car/"+mol+"."+cnf+".pdb";
   std::ifstream ifile(filename.c_str());
   if( !ifile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   int iZ0=0;
   int mR0=Z0[iZ0].R0a;
   int nR0=(mR0-1+Z0[iZ0].cR0);
   int iR0=-1;
   std::string grp="          ";
   int n=vv.o_Lrec.size();
   for(int p=0;p<n;p++){
      rec=vv.Lrec(p);
      if      ( rec.substr( 0, 6)=="ATOM  " ){
         if( rec.substr(17,10)!=grp ){
            grp=rec.substr(17,10);
            if( iR0==nR0 ){
               iZ0++;
               mR0=Z0[iZ0].R0a;
               nR0=(mR0-1+Z0[iZ0].cR0);
            }
            iR0++;
            std::string aa=R0[iR0].aa;
            char c1=R0[iR0].c1;
            if( c1=='a' ){
               if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
               if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
            }
            if( aa=="HIE " )aa="HIS ";
            if( aa=="HIP " )aa="HIS ";
            if( aa=="CYH " )aa="CYS ";
            if( rec.substr(17, 4)!=aa ){
               std::cerr<<"ERROR: Inconsistency of CAR file"
                        <<" with SEQ file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                        <<" aa="<<rec.substr(17, 4)<<".\n";
               std::exit( 1);
            }
            R0[iR0].cha=rec[21];
            std::istringstream(rec.substr(22, 4))>>R0[iR0].res;
            R0[iR0].ins=rec[26];
         }
         std::string atm=rec.substr(12, 4);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].atm==atm ){
               P1[iP1].sub=1;
               std::istringstream irec(rec.substr(30,24));
               for(int i=0;i<3;i++){
                  irec>>P1[iP1].x(i);
               }
               atm="xxxx";
            }
         }
         if( atm!="xxxx" ){
            std::cerr<<"ERROR: Unmatched atom name in CAR file."
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                     <<" atm="<<atm<<".\n";
            std::exit( 1);
         }

      }else if( rec.substr( 0, 6)=="TER   " ){
      }else if( rec.substr( 0, 6)=="END   " ){
      }else{
      }
   }

   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (aa=="CYH ")&&(atm==" HG ") )iT2= 5;
            if( iT2== 0 )continue;
            if( iT2== 3 )continue;
            if( P1[iP1].sub==0 ){
               std::cerr<<"ERROR: Missing atom in CAR file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                        <<" atm="<<atm<<".\n";
               std::exit( 1);
            }
         }
      }
   }
   return;
}
