#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>

class MEM_docstp {
private:
   std::vector<int> o_R0sub;            //residue has unsearched sc
public:
   std::vector<int> o_R1ord;            //order
   std::vector<int> o_R1inv;            //inverse order
   MEM_docstp(int o):
      o_R0sub(o, 0)
   {
   }
   int& R0sub(int i){
      return o_R0sub.at( i);  }
   int& R1ord(int i){
      return o_R1ord.at( i);  }
   int& R1inv(int i){
      return o_R1inv.at( i);  }
};

void Search_Subspace::DOCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                             const Structure& str,
                             const Coordinates& d,
                             int jZ0,int jR0){
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oR1=nR1;
   MEM_docstp vv(oR0);
//
//
// boundary planes
//
   double g=( d.r() -(6.40));
   Coordinates n=d;
   n.normalize();
//
//
// annotate structure
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if      ( c1=='a' ){
            if( aa=="ALA " )continue;
            if( aa=="GLY " )continue;
//          if( aa=="PRO " )continue;
            if( aa=="AIB " )continue;
            if( aa=="UNK " )continue;
         }else if( c1=='e' ){
            continue;
         }else if( c1=='r' ){
            if( aa=="D   " )continue;
            if( aa=="R   " )continue;
            if( aa=="RF  " )continue;
            if( aa=="LNA " )continue;
            if( aa=="CET " )continue;
         }else if( c1=='b' ){
            if( aa=="N   " )continue;
            continue;
         }else if( c1=='p' ){
            continue;
         }else if( c1=='s' ){
            continue;
         }
         vv.R0sub(iR0)=1;
      }
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=(R1[iR1].R0-jR0);
      if( iR0< 0 )continue;
      if( iR0>=oR0 )continue;
      vv.R0sub(iR0)=0;
   }
//
//
// expand R1
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0sub(iR0)==0 )continue;
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int mP1=str.R0[iR0].P1a;
         int nP1=(mP1-1+str.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( str.P1[iP1].sub==0 )continue;
            if( str.P1[iP1].typ< 8 )continue;
            if( str.P1[iP1].sc==0 )continue;
            double z= dot( str.P1[iP1].x, n);
            if( z>g ){
               R1.push_back( tR1());
               R1[nR1].Z0=(iZ0+jZ0);
               R1[nR1].R0=(iR0+jR0);
               R1[nR1].L0=str.R0[iR0].L0;
               R1[nR1].aa=str.R0[iR0].aa;
               R1[nR1].bb=0;
               if( aa=="PRO " ){
                  R1[nR1].sc=1;
               }else{
                  R1[nR1].sc=2;
               }
               R1[nR1].pt=0;
               nR1++;
               break;
            }
         }
      }
   }
   oR1=nR1;
   vv.o_R1ord.resize(oR1);
   vv.o_R1inv.resize(oR1);
//
//
// order R1
//
   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1ord(iR1)=iR1;
   }
   for(int jR1max=(oR1-1);jR1max> 0;jR1max--){
      bool ORDERED=true;
      int i=R1[vv.R1ord( 0)].R0;
      for(int jR1= 1;jR1<=jR1max;jR1++){
         int j=R1[vv.R1ord(jR1)].R0;
         if( j<i ){
            int L=vv.R1ord(jR1);
            vv.R1ord(jR1)=vv.R1ord(jR1-1);
            vv.R1ord(jR1-1)=L;
            ORDERED=false;
         }else{
            i=j;
         }
      }
      if( ORDERED )break;
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1inv(vv.R1ord(iR1))=iR1;
   }
   for(int iR1= 0;iR1<oR1;iR1++){
      int jR1=vv.R1ord(iR1);
      int kR1=vv.R1inv(iR1);
      int iZ0=R1[iR1].Z0;
      R1[iR1].Z0=R1[jR1].Z0;
      R1[jR1].Z0=iZ0;
      int iR0=R1[iR1].R0;
      R1[iR1].R0=R1[jR1].R0;
      R1[jR1].R0=iR0;
      int iL0=R1[iR1].L0;
      R1[iR1].L0=R1[jR1].L0;
      R1[jR1].L0=iL0;
      std::string aa=R1[iR1].aa;
      R1[iR1].aa=R1[jR1].aa;
      R1[jR1].aa=aa;
      int bb=R1[iR1].bb;
      R1[iR1].bb=R1[jR1].bb;
      R1[jR1].bb=bb;
      int sc=R1[iR1].sc;
      R1[iR1].sc=R1[jR1].sc;
      R1[jR1].sc=sc;
      int pt=R1[iR1].pt;
      R1[iR1].pt=R1[jR1].pt;
      R1[jR1].pt=pt;
      vv.R1ord(iR1)=iR1;
      vv.R1inv(iR1)=iR1;
      vv.R1ord(kR1)=jR1;
      vv.R1inv(jR1)=kR1;
   }

   return;
}
void Search_Subspace::DOCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                             const Structure& str){
//
//
// unpack concatenated names of allowed residues
//
   R3.clear();
   int mR3=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      R1[iR1].R3a=mR3;
      R1[iR1].cR3=1;
      R3.push_back( Search_Subspace::tR3());
      R3[mR3].aa=R1[iR1].aa;
      R3[mR3].L0=R1[iR1].L0;
      mR3++;
   }
//
//
// populate Search_Subspace to level of fil2stp
//
   T5.clear();
   int mT5=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      int iR0=R1[iR1].R0;
      char c1=str.R0[iR0].c1;
      std::string aa=str.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      R1[iR1].T5a=mT5;
      R1[iR1].cT5=str.R0[iR0].cT1;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         T5.push_back( tT5());
         T5[iT1-mT1+mT5].tor=str.T1[iT1].tor;
      }
      mT5+=R1[iR1].cT5;
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )R1[iR1].ca=str.P1[iP1].x;
            if( atm==" CB " )R1[iR1].cb=str.P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CM'" )R1[iR1].cb=str.P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CA'" )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" N1 " )R1[iR1].cb=str.P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )R1[iR1].ca=str.P1[iP1].x;
               if( atm==" C4 " )R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }

   return;
}
