#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <cmath>

class MEM_cycstp {
private:
   std::vector<int> o_R0sub;            //0={}, 1={Ca} or {Cb} 2={Ca,Cb}
   std::vector<Coordinates> o_R0a;      //position of Ca
   std::vector<Coordinates> o_R0b;      //position of Cb
   std::vector<Coordinates> o_R0c;      //unit vector along Ca--Cb
   std::vector<Coordinates> o_R0g;      //position of sc ellipsoid
   std::vector<int> o_R1ord;            //order
   std::vector<int> o_R1inv;            //inverse order
public:
   MEM_cycstp(int o):
      o_R0sub(o, 0),
      o_R0a(o),
      o_R0b(o),
      o_R0c(o),
      o_R0g(o),
      o_R1ord(o),
      o_R1inv(o)
   {
   }
   int& R0sub(int i){
      return o_R0sub.at( i);  }
   Coordinates& R0a(int i){
      return o_R0a.at( i);  }
   Coordinates& R0b(int i){
      return o_R0b.at( i);  }
   Coordinates& R0c(int i){
      return o_R0c.at( i);  }
   Coordinates& R0g(int i){
      return o_R0g.at( i);  }
   int& R1ord(int i){
      return o_R1ord.at( i);  }
   int& R1inv(int i){
      return o_R1inv.at( i);  }
};

void Structure::CYCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                       std::vector<Search_Subspace>& M0sub,
                       int n){
   int oR0=( Z0[nZ0-1].R0a +Z0[nZ0-1].cR0);
   MEM_cycstp vv(oR0);
//
//
// populate interaction sites
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            if( c1=='a' ){
               std::string atm=P1[iP1].atm;
               if      ( atm==" CA " ){
                  vv.R0a(iR0)=P1[iP1].x;
                  vv.R0sub(iR0)++;
               }else if( atm==" CB " ){
                  vv.R0b(iR0)=P1[iP1].x;
                  vv.R0sub(iR0)++;
               }
            }
         }
      }
   }
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ")||
             (aa=="GLY ")||(aa=="AIB ")||(aa=="H2O ") )continue;
         if( vv.R0sub(iR0)<2 )continue;
         int iL0=R0[iR0].L0;
         double del= residue_mappings.L0[iL0].del;
         vv.R0c(iR0)=( vv.R0b(iR0) -vv.R0a(iR0));
         vv.R0g(iR0)=( vv.R0b(iR0) +del*vv.R0c(iR0));
         vv.R0c(iR0).normalize();
      }
   }
//
//
// collection of search subspaces
//
   int jZ0=0;
   int mR0=Z0[jZ0].R0a;
   int nR0=(mR0-1+Z0[jZ0].cR0);
   {
      char c1=R0[mR0].c1;
      bool PEPTIDE=( (c1=='a')||(c1=='e') );
      while( !PEPTIDE ){
         if( jZ0==(nZ0-1) ){
            return;
//          std::cerr<<"ERROR: No peptide chain found in Structure.\n";
//          std::exit( 1);
         }
         jZ0++;
         mR0=Z0[jZ0].R0a;
         nR0=(mR0-1+Z0[jZ0].cR0);
         c1=R0[mR0].c1;
         PEPTIDE=( (c1=='a')||(c1=='e') );
      }
   }
   int pR0=mR0;
   for(int iM0=0;;iM0++){
      int jR0min=( pR0==mR0 )? mR0: (pR0-1);
      int jR0max=(pR0+(n-1));
      if( jR0max>nR0 )break;
      M0sub.push_back( Search_Subspace());
//
//
// initiate search subspace with variable segment
//
      M0sub[iM0].nR1=0;
      for(int jR0=jR0min;jR0<=jR0max;jR0++){
         M0sub[iM0].R1.push_back( Search_Subspace::tR1());
         int jL0=R0[jR0].L0;
         std::string aa=R0[jR0].aa;
         std::string ab=aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         M0sub[iM0].R1[ M0sub[iM0].nR1].Z0=jZ0;
         M0sub[iM0].R1[ M0sub[iM0].nR1].R0=jR0;
         M0sub[iM0].R1[ M0sub[iM0].nR1].L0=jL0;
         M0sub[iM0].R1[ M0sub[iM0].nR1].aa=aa;
         M0sub[iM0].R1[ M0sub[iM0].nR1].bb=( jR0<pR0 )? 0: 2;
         int sc=2;
         if( residue_mappings.L0[jL0].cU0==0 )sc=0;
         if( residue_mappings.L0[jL0].cU0==1 )sc=1;
         if( ab=="AIB " )sc=1;
         if( ab=="PRO " )sc=1;
         M0sub[iM0].R1[ M0sub[iM0].nR1].sc=( jR0<pR0 )? 0: sc;
         M0sub[iM0].R1[ M0sub[iM0].nR1].pt=( jR0==pR0 )? 7: 0;
         M0sub[iM0].nR1++;
      }
//
//
// add side chains in contact with variable segment
//
      for(int iZ0=0;iZ0<nZ0;iZ0++){
         int mR0=Z0[iZ0].R0a;
         int nR0=(mR0-1+Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            if( (iZ0==jZ0)&&(iR0>=pR0)&&(iR0<=jR0max) )continue;
            if( vv.R0sub(iR0)<2 )continue;
            int iL0=R0[iR0].L0;
            if( residue_mappings.L0[iL0].cU0<=1 )continue;
            std::string aa=R0[iR0].aa;
            std::string ab=aa;
            if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
            if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
            if( ab=="PRO " )continue;
            double aai= std::pow(residue_mappings.L0[iL0].ea,2);
            double bbi= std::pow(residue_mappings.L0[iL0].eb,2);

            for(int jR0=pR0;jR0<=jR0max;jR0++){
               if( vv.R0sub(jR0)<2 )continue;
               int jL0=R0[jR0].L0;
               if( residue_mappings.L0[jL0].cU0<=1 )continue;
               double aaj= std::pow(residue_mappings.L0[jL0].ea,2);
               double bbj= std::pow(residue_mappings.L0[jL0].eb,2);
               Coordinates zD=( vv.R0g(iR0) -vv.R0g(jR0));
               double zR= zD.r();
               zD/=zR;
               double CTi= dot( zD,vv.R0c(iR0));
               double CTCTi= CTi*CTi;
               double STSTi=( (1.00) -CTCTi);
               double CTj= dot( zD,vv.R0c(jR0));
               double CTCTj= CTj*CTj;
               double STSTj=( (1.00) -CTCTj);
               double zRi= std::sqrt( aai*CTCTi +bbi*STSTi);
               double zRj= std::sqrt( aaj*CTCTj +bbj*STSTj);
               if( zR<(.750)*( zRi +zRj) ){
                  if( iR0==jR0min ){
                     M0sub[iM0].R1[ 0].sc=2;
                  }else{
                     M0sub[iM0].R1.push_back( Search_Subspace::tR1());
                     M0sub[iM0].R1[ M0sub[iM0].nR1].Z0=iZ0;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].R0=iR0;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].L0=iL0;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].aa=aa;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].bb=0;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].sc=2;
                     M0sub[iM0].R1[ M0sub[iM0].nR1].pt=0;
                     M0sub[iM0].nR1++;
                  }
                  break;
               }
            }

         }
      }
//
//
// sort residues of search subspace
//
      int oR1=M0sub[iM0].nR1;
      for(int iR1=0;iR1<oR1;iR1++){
         vv.R1ord(iR1)=iR1;
      }
      for(int jR1max=(oR1-1);jR1max> 0;jR1max--){
         bool ORDERED=true;
         int i=M0sub[iM0].R1[vv.R1ord( 0)].R0;
         for(int jR1= 1;jR1<=jR1max;jR1++){
            int j=M0sub[iM0].R1[vv.R1ord(jR1)].R0;
            if( j<i ){
               int L=vv.R1ord(jR1);
               vv.R1ord(jR1)=vv.R1ord(jR1-1);
               vv.R1ord(jR1-1)=L;
               ORDERED=false;
            }else{
               i=j;
            }
         }
         if( ORDERED )break;
      }
      for(int iR1=0;iR1<oR1;iR1++){
         vv.R1inv(vv.R1ord(iR1))=iR1;
      }
      for(int iR1=0;iR1<oR1;iR1++){
         int jR1=vv.R1ord(iR1);
         int kR1=vv.R1inv(iR1);
         int iZ0=M0sub[iM0].R1[iR1].Z0;
         M0sub[iM0].R1[iR1].Z0=M0sub[iM0].R1[jR1].Z0;
         M0sub[iM0].R1[jR1].Z0=iZ0;
         int iR0=M0sub[iM0].R1[iR1].R0;
         M0sub[iM0].R1[iR1].R0=M0sub[iM0].R1[jR1].R0;
         M0sub[iM0].R1[jR1].R0=iR0;
         int iL0=M0sub[iM0].R1[iR1].L0;
         M0sub[iM0].R1[iR1].L0=M0sub[iM0].R1[jR1].L0;
         M0sub[iM0].R1[jR1].L0=iL0;
         std::string aa=M0sub[iM0].R1[iR1].aa;
         M0sub[iM0].R1[iR1].aa=M0sub[iM0].R1[jR1].aa;
         M0sub[iM0].R1[jR1].aa=aa;
         int bb=M0sub[iM0].R1[iR1].bb;
         M0sub[iM0].R1[iR1].bb=M0sub[iM0].R1[jR1].bb;
         M0sub[iM0].R1[jR1].bb=bb;
         int sc=M0sub[iM0].R1[iR1].sc;
         M0sub[iM0].R1[iR1].sc=M0sub[iM0].R1[jR1].sc;
         M0sub[iM0].R1[jR1].sc=sc;
         int pt=M0sub[iM0].R1[iR1].pt;
         M0sub[iM0].R1[iR1].pt=M0sub[iM0].R1[jR1].pt;
         M0sub[iM0].R1[jR1].pt=pt;
         vv.R1ord(iR1)=iR1;
         vv.R1inv(iR1)=iR1;
         vv.R1ord(kR1)=jR1;
         vv.R1inv(jR1)=kR1;
      }
//
//
// populate Search_Subspace to level of fil2stp
//
      for(int iR1=0;iR1<oR1;iR1++){
         M0sub[iM0].R1[iR1].R3a=iR1;
         M0sub[iM0].R1[iR1].cR3=1;
         M0sub[iM0].R1[iR1].jR3=iR1;
         M0sub[iM0].R3.push_back( Search_Subspace::tR3());
         M0sub[iM0].R3[iR1].aa=M0sub[iM0].R1[iR1].aa;
         M0sub[iM0].R3[iR1].L0=M0sub[iM0].R1[iR1].L0;
      }
      M0sub[iM0].mBOD=0;
      if( nZ0> 1 ){
         for(int iR1=0;iR1<oR1;iR1++){
            if( M0sub[iM0].R1[iR1].bb==0 )continue;
            int iZ0=M0sub[iM0].R1[iR1].Z0;
            int iR0=M0sub[iM0].R1[iR1].R0;
            int mR0=Z0[iZ0].R0a;
            if( iR0==mR0 )M0sub[iM0].mBOD=1;
         }
      }
      int mT5=0;
      for(int iR1=0;iR1<oR1;iR1++){
         int iR0=M0sub[iM0].R1[iR1].R0;
         M0sub[iM0].R1[iR1].T5a=mT5;
         M0sub[iM0].R1[iR1].cT5=R0[iR0].cT1;
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            M0sub[iM0].T5.push_back( Search_Subspace::tT5());
            M0sub[iM0].T5[iT1-mT1+mT5].tor=T1[iT1].tor;
         }
         mT5+=M0sub[iM0].R1[iR1].cT5;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            if      ( atm==" CA " ){
               M0sub[iM0].R1[iR1].ca=P1[iP1].x;
            }else if( atm==" CB " ){
               M0sub[iM0].R1[iR1].cb=P1[iP1].x;
            }
         }
      }

      if( jR0max==nR0 ){
         if( jZ0==(nZ0-1) )break;
         jZ0++;
         mR0=Z0[jZ0].R0a;
         nR0=(mR0-1+Z0[jZ0].cR0);
         {
            char c1=R0[mR0].c1;
            bool PEPTIDE=( (c1=='a')||(c1=='e') );
            while( !PEPTIDE ){
               if( jZ0==(nZ0-1) )break;
               jZ0++;
               mR0=Z0[jZ0].R0a;
               nR0=(mR0-1+Z0[jZ0].cR0);
               c1=R0[mR0].c1;
               PEPTIDE=( (c1=='a')||(c1=='e') );
            }
            if( !PEPTIDE )break;
         }
         pR0=mR0;
      }else{
         pR0+=(n+1)/2;
         if( (pR0+(n-1))>nR0 )pR0=(nR0-(n-1));
      }
   }
//
//
// output stp files
//
   std::string bse="g";
   int nM0=M0sub.size();
   int iM0=0;
   for(int i1=0;i1<=9&&(iM0<nM0);i1++){
      char a1=char('0'+i1);
      for(int i2=0;i2<=9&&(iM0<nM0);i2++){
         char a2=char('0'+i2);
         for(int i3=0;i3<=9&&(iM0<nM0);i3++){
            char a3=char('0'+i3);
            std::string seg=bse+a1+a2+a3;
            std::string filename="../../"+fam+"/stp/stp."+seg+"."+mol;
            std::ofstream ofile(filename.c_str());

            int oR1=M0sub[iM0].nR1;
            ofile<< std::setw( 4)<<oR1<<'\n';
            for(int iR1= 0;iR1<oR1;iR1++){
               int iZ0=M0sub[iM0].R1[iR1].Z0;
               int iR0=M0sub[iM0].R1[iR1].R0;
               ofile<<'['<< std::setw( 2)<<(iZ0+1)
                    <<':'<< std::setw( 4)<<(iR0+1)<<"] "
                    << std::setw( 2)<<M0sub[iM0].R1[iR1].bb
                    << std::setw( 2)<<M0sub[iM0].R1[iR1].sc
                    << std::setw( 2)<<M0sub[iM0].R1[iR1].pt<<"  "
                    <<M0sub[iM0].R1[iR1].aa<<'\n';
            }

            ofile.close();
            iM0++;
         }
      }
   }
   return;
}
