#include "../fil/Structure.hh"
#include <string>
#include <fstream>
#include <iomanip>

void Structure::CAR2FIL() const{
   std::string filename="../../"+fam+"/car/"+mol+"."+cnf+".pdb";
   std::ofstream ofile(filename.c_str());
   ofile<< std::fixed<< std::setprecision(3);
   int i=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
         if( aa=="HIE " )aa="HIS ";
         if( aa=="HIP " )aa="HIS ";
         if( aa=="CYH " )aa="CYS ";
         char cha=R0[iR0].cha;
         int res=R0[iR0].res;
         char ins=R0[iR0].ins;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (aa=="CYS ")&&(atm==" HG ") )iT2=5;
            if( iT2== 0 )continue;
            if( iT2== 3 )continue;
            i++;
            ofile<<"ATOM  "
                 << std::setw( 5)<<i<<" "<<atm<<" "
                 <<aa.substr(0,3)<<" "<<cha<< std::setw( 4)<<res<<ins<<"   "
                 <<P1[iP1].x<<'\n';
         }
      }
      ofile<<"TER\n";
   }
   ofile.close();
   return;
}
