#ifndef DEF_TRAJECTORY
#define DEF_TRAJECTORY

#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>

class Trajectory {
public:
   class tM0 { /*system of molecules of a trajectory*/
   public:
      class tM0Z0 { /*chain in system of molecules*/
      public:
         Coordinates trans;     //translation (bohr)
         Coordinates rot;       //rotation euler angles (radian)
         tM0Z0(){}
      };
      class tM0R0 { /*residue in chains*/
      public:
         int C7;                //secondary structure state
         tM0R0(){}
      };
      class tM0P1 { /*physical atom in chains [iupac order]*/
      public:
         int sub;               //position coordinates flag, {unset,set}={0,1}
         Coordinates x;         //atom coordinates (angstrom)
         tM0P1(){}
      };
      class tM0T1 { /*torsion in chains [iupac order]*/
      public:
         double chi;            //torsion value (degree)
         tM0T1(){}
      };
      class tM0R1 { /*residue of search subspace containing variable torsions*/
      public:
         int Z0;                //index into set of chains
         int R0;                //index into set of residues
         int bb;                //bb search parameter
         int sc;                //sc search parameter
         int pt;                //length of variable segment
         tM0R1(){}
      };

   public:
      std::string cnf;          //name of conformation
      int nZ0;                  //number
      std::vector<tM0Z0> Z0;    //set of chains
      std::vector<tM0R0> R0;    //set of residues
      std::vector<tM0P1> P1;    //set of physical atoms
      std::vector<tM0T1> T1;    //set of torsions
      std::string QSUB;         //name of subset of degrees of freedom
      int nR1;                  //number
      std::vector<tM0R1> R1;    //set of residues of search subspace

      tM0(){}

      void operator=(const Structure& a);
      void operator=(const Search_Subspace& a);
   };

public:
   int nM0;                     //number
   std::vector<tM0> M0;         //set of systems of molecules

   void STR2TRA(int jM0,const Structure& a);

   Trajectory():
      nM0(0)
   {
   }
};

#endif
