#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"

void Trajectory::tM0::operator=(const Structure& a){
   cnf=a.cnf;
   nZ0=a.nZ0;
   Z0.clear();
   R0.clear();
   P1.clear();
   T1.clear();
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      Z0.push_back( tM0Z0());
      Z0[iZ0].trans=a.Z0[iZ0].trans;
      Z0[iZ0].rot=a.Z0[iZ0].rot;
      int mR0=a.Z0[iZ0].R0a;
      int nR0=(mR0-1+a.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tM0R0());
         R0[iR0].C7=a.R0[iR0].C7;
         int mP1=a.R0[iR0].P1a;
         int nP1=(mP1-1+a.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1.push_back( tM0P1());
            P1[iP1].sub=a.P1[iP1].sub;
            P1[iP1].x=a.P1[iP1].x;
         }
         int mT1=a.R0[iR0].T1a;
         int nT1=(mT1-1+a.R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            T1.push_back( tM0T1());
            T1[iT1].chi= a.T1[iT1].chi;
         }
      }
   }
   return;
}

void Trajectory::tM0::operator=(const Search_Subspace& a){
   QSUB="";
   nR1=a.nR1;
   R1.clear();
   for(int iR1=0;iR1<nR1;iR1++){
      R1.push_back( tM0R1());
      R1[iR1].Z0=a.R1[iR1].Z0;
      R1[iR1].R0=a.R1[iR1].R0;
      R1[iR1].bb=a.R1[iR1].bb;
      R1[iR1].sc=a.R1[iR1].sc;
      R1[iR1].pt=a.R1[iR1].pt;
   }
   return;
}
