#ifndef DEF_STRUCTURE
#define DEF_STRUCTURE

#include "../dat/DAT_ARRAY_CONSTS.hh"
class DAT_ENERGY_PARAMS;
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
class DAT_RESIDUE_MAPPINGS;
#include "../dom/Domain_Definitions.hh"
class Family;
class Search_Subspace;
class Trajectory;
#include "../med/Defect_Automatic.hh"
class Dielec_Continu;
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <vector>

class Structure {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      int R0a;                  //start index into set of residues
      int cR0;                  //number of residues
      Coordinates trans;        //translation (bohr)
      Coordinates rot;          //rotation euler angles (radian)
      tZ0(){}
   };
   class tR0 { /*residues in chains*/
   public:
      std::string aa;           //4 char residue name
      int L0;                   //index into set of residue types
      char c1;                  //1 char class name
      char cha;                 //pdb chain identifier
      int res;                  //pdb residue sequence number
      char ins;                 //pdb insertion character
      char core;                //core=: or surface=| character
      int C7;                   //ss state {1=helix,2=sheet,3=coil}
      int P1a;                  //start index into set of atoms
      int cP1;                  //number of atoms
      int T1a;                  //start index into set of torsions
      int cT1;                  //number of torsions
      int Z0;                   //index into set of chains
      int L1;                   //index into 20 natural amino acids
      char path;                //allowable ss states {-,H,E,C}={none,H,E,C}
      bool ss;                  //Cys contributing to disulfide crosslink
      tR0(){}
   };
   class tP1 { /*physical atoms in chains [iupac order]*/
   public:
      std::string atm;          //4 char atom name
      int typ;                  //atom type
      int sc;                   //side chain atom flag, {bb,sc}={0,1}
      int sub;                  //position coordinates flag, {unset,set}={0,1}
      Coordinates x;            //atom coordinates (angstrom)
      tP1(){}
   };
   class tT1 { /*torsions in chains [iupac order]*/
   public:
      std::string tor;          //3 char torsion name
      double chi;               //torsion value (degree)
      tT1(){}
   };
   class tS0 { /*disulfide bonds in system of molecules*/
   public:
      tS0(){}
   };
   class tV0 { /*ionizable groups in system of molecules*/
   public:
      bool PROTONATED;          //charges consistent with protonated form
      bool IONIZED;             //charges consistent with ionized form
      int T;                    //index of model peptide
      double g;                 //peptide dG of DH<-->D +H at pH=0 (kcal/mol)
      double f;                 //peptide d(Fe+Fm) of DH<-->D (kcal/mol)
      int R0;                   //index into set of residues
      double hbc;               //hbond to unprotonated ionizable group
      double pKa;               //pKa calculated
      tV0(){}
   };

private:
   std::vector<int> o_R0H3Z0;   //chain of H-bond contact
   std::vector<int> o_R0H3R0;   //residue
   int& R0H3Z0(int i,int j){
      return o_R0H3Z0.at( i*8 +j);
   }
   int& R0H3R0(int i,int j){
      return o_R0H3R0.at( i*8 +j);
   }

public:
   std::string fam;             //name of family
   std::string mol;             //name of system of molecules
   std::string cnf;             //name of conformation
   int nZ0;                     //number of chains
   std::vector<tZ0> Z0;         //set of chains
   std::vector<tR0> R0;         //set of residues
   std::vector<tP1> P1;         //set of atoms
   std::vector<tT1> T1;         //set of torsions
   int nS0;                     //number of disulfide crosslinks
   std::vector<tS0> S0;         //set of disulfide crosslinks
   std::vector<int> o_S0N2Z0;   //pair of indexes into set of chains
   std::vector<int> o_S0N2R0;   //pair of indexes into set of residues
   int nV0;                     //number of ionizable groups
   std::vector<tV0> V0;         //set of ionizable groups

   int& S0N2Z0(int i,int j){
      return o_S0N2Z0.at( i*2 +j);
   }
   const int& S0N2Z0(int i,int j) const {
      return o_S0N2Z0.at( i*2 +j);
   }
   int& S0N2R0(int i,int j){
      return o_S0N2R0.at( i*2 +j);
   }
   const int& S0N2R0(int i,int j) const {
      return o_S0N2R0.at( i*2 +j);
   }
//
   void REFORM(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_RESIDUE_MAPPINGS& residue_mappings);
   void POLARH(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_RESIDUE_MAPPINGS& residue_mappings);
   void TOR(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_RESIDUE_MAPPINGS& residue_mappings);
   void REG(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            Output_Streams& out);
   void STA(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_REGION_MAPS& region_maps);
   void CAR(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_RESIDUE_MAPPINGS& residue_mappings);
   double SUP(const DAT_PHYSICS_CONSTS& physics_consts,
              Output_Streams& out,
              const Trajectory& tra);
   void PAIRCNF(const DAT_PHYSICS_CONSTS& physics_consts,
                Output_Streams& out,
                const std::vector<Structure>& Zstr,
                std::vector<Coordinates>& ZZtrans,
                std::vector<Coordinates>& ZZrot,
                std::vector<double>& ZZr);
   void SEQ2FIL() const;
   void TOR2FIL(const DAT_PHYSICS_CONSTS& physics_consts) const;
   void CAR2FIL() const;
   void FIL2SEQ(const DAT_RESIDUE_MAPPINGS& residue_mappings);
   void FIL2TOR(const DAT_PHYSICS_CONSTS& physics_consts);
   void FIL2CAR();
   void FIL2CHA(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const DAT_IGOR_DATA& igor_data);
   void TRA2STR(int jM0,const Trajectory& a);
   void FAM2STR(int jM1,const Family& a);
   void CYCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
               std::vector<Search_Subspace>& M0sub,
               int n);
   bool DOM_REFORM(const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const Domain_Definitions& dom,
                   Output_Streams& out);
//
   void DEFECT(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const DAT_REGION_MAPS& region_maps,
               const DAT_IGOR_DATA& igor_data,
               Thread_Options& opt,
               Output_Streams& out);
   void DEFECT_OLP(Defect_Automatic& aut,
                   Output_Streams& out);
   void DEFECT_CNF(Defect_Automatic& aut,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const DAT_REGION_MAPS& region_maps,
                   Output_Streams& out);
   void DEFECT_FLAG(Defect_Automatic& aut,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    int iR0,int iT1,const char typ);
   void DEFECT_CAV(Defect_Automatic& aut,
                   Dielec_Continu& mlg,
                   Dielec_Continu& med,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const DAT_ENERGY_PARAMS& energy_params,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   Output_Streams& out);
   void DEFECT_MOL(Defect_Automatic& aut,
                   Dielec_Continu& med,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ENERGY_PARAMS& energy_params);
   void DEFECT_SURF(Dielec_Continu& med,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    Output_Streams& out);
   void DEFECT_EHP(Defect_Automatic& aut,
                   Dielec_Continu& med,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   Output_Streams& out);
   void DEFECT_BCHG(Defect_Automatic& aut,
                    Dielec_Continu& mlg,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    Output_Streams& out);
   int DEFECT_CHG(int iR0,int iP1);
   void DEFECT_HBND(Defect_Automatic& aut,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    Output_Streams& out);
   void DEFECT_SSP(Defect_Automatic& aut,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const DAT_IGOR_DATA& igor_data,
                   Thread_Options& opt,
                   Output_Streams& out);
   void DEFECT_CON(Defect_Automatic& aut,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   Output_Streams& out);
   void DEFECT_STP(Defect_Automatic& aut,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings);
//
   void TRA_STP(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const DAT_REGION_MAPS& region_maps,
                Search_Subspace& ful,
                Search_Subspace& sub,
                Output_Streams& out);
   void TRA_STP_OLP(Stp_Automatic& aut);
   void TRA_STP_CNF(Stp_Automatic& aut,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    const DAT_REGION_MAPS& region_maps);
   void TRA_STP_CAV(Stp_Automatic& aut,
                    Dielec_Continu& mlg,
                    Dielec_Continu& med,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const DAT_ENERGY_PARAMS& energy_params,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out);
   void TRA_STP_MOL(Stp_Automatic& aut,
                    Dielec_Continu& med,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ENERGY_PARAMS& energy_params);
   void TRA_STP_SURF(Dielec_Continu& med,
                     const DAT_PHYSICS_CONSTS& physics_consts);
   void TRA_STP_EHP(Stp_Automatic& aut,
                    Dielec_Continu& med,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings);
   void TRA_STP_BCHG(Stp_Automatic& aut,
                     Dielec_Continu& mlg,
                     const DAT_PHYSICS_CONSTS& physics_consts);
   int TRA_STP_CHG(int iR0,int iP1);
   void TRA_STP_HBND(Stp_Automatic& aut,
                     const DAT_PHYSICS_CONSTS& physics_consts);
   void TRA_STP_SSP(Stp_Automatic& aut);
   void TRA_STP_STP(Stp_Automatic& aut,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out,
                    Search_Subspace& ful,
                    Search_Subspace& sub);

   Structure(){
   }
   Structure(const DAT_RESIDUE_MAPPINGS& residue_mappings,
             const Structure& a,
             const Search_Subspace& sub);
   int iatom(int iR0,std::string atm) const;
   int itorsion(int iR0,std::string tor) const;
   void operator=(const Structure& a);
   void operator+=(const Structure& a);
   void generate(const Coordinates& TRANS,
                 const Rotation_Matrix& ROT,
                 const Structure& a);
};

#endif
