#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <cmath>

Structure::Structure(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                     const Structure& a,
                     const Search_Subspace& sub){
   fam=a.fam;
   mol=a.mol;
   cnf=a.cnf;
   nZ0=a.nZ0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      Z0.push_back( tZ0());
      Z0[iZ0].R0a=a.Z0[iZ0].R0a;
      Z0[iZ0].cR0=a.Z0[iZ0].cR0;
      Z0[iZ0].trans=a.Z0[iZ0].trans;
      Z0[iZ0].rot=a.Z0[iZ0].rot;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tR0());
         R0[iR0].aa=a.R0[iR0].aa;
         R0[iR0].L0=a.R0[iR0].L0;
         R0[iR0].c1=a.R0[iR0].c1;
         R0[iR0].cha=a.R0[iR0].cha;
         R0[iR0].res=a.R0[iR0].res;
         R0[iR0].ins=a.R0[iR0].ins;
         R0[iR0].core=a.R0[iR0].core;
      }
   }
   nS0=a.nS0;
   for(int iS0=0;iS0<nS0;iS0++){
      S0.push_back( tS0());
      for(int iN2=0;iN2<2;iN2++){
         o_S0N2Z0.push_back( a.S0N2Z0(iS0,iN2));
         o_S0N2R0.push_back( a.S0N2R0(iS0,iN2));
      }
   }
   for(int jR1= 0;jR1<sub.nR1;jR1++){
      int jR0=sub.R1[jR1].R0;
      int iR3=sub.R1[jR1].jR3;
      R0[jR0].aa=sub.R3[iR3].aa;
      R0[jR0].L0=sub.R3[iR3].L0;
   }
   int iT1=0;
   int iP1=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=R0[iR0].L0;
         int mT0=residue_mappings.L0[iL0].T0a;
         int nT0=(mT0-1+residue_mappings.L0[iL0].cT0);
         R0[iR0].T1a=iT1;
         R0[iR0].cT1=(nT0-mT0+1);
         for(int iT0=mT0;iT0<=nT0;iT0++){
            T1.push_back( tT1());
            T1[iT1].tor=residue_mappings.T0[iT0].tor;
            iT1++;
         }
         int mP0=residue_mappings.L0[iL0].P0a;
         int nP0=(mP0-1+residue_mappings.L0[iL0].cP0);
         R0[iR0].P1a=iP1;
         R0[iR0].cP1=(nP0-mP0+1);
         for(int iP0=mP0;iP0<=nP0;iP0++){
            P1.push_back( tP1());
            P1[iP1].atm=residue_mappings.P0[iP0].atm;
            P1[iP1].typ=residue_mappings.P0[iP0].typ;
            P1[iP1].sc=residue_mappings.P0[iP0].sc;
            P1[iP1].sub=0;
            iP1++;
         }
      }
   }
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         std::string ab=a.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
            if( (ab[0]=='e')||
                (ab[0]=='z') )ab=ab.substr(1,3)+' ';
            if( (ab[3]=='e')||
                (ab[3]=='z') )ab=ab.substr(0,3)+' ';
         }
         bool MUTATION=( aa!=ab );
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         int aP1=a.R0[iR0].P1a;
         int bP1=(aP1-1+a.R0[iR0].cP1);
         if( MUTATION ){
            if      ( c1=='a' ){
               if( nP1>(mP1+6) )nP1=(mP1+6);
               if( bP1>(aP1+6) )bP1=(aP1+6);
            }else if( c1=='e' ){
               if( nP1>(mP1  ) )nP1=(mP1  );
               if( bP1>(aP1  ) )bP1=(aP1  );
            }else if( c1=='r' ){
            }else if( c1=='b' ){
               bool aaPURINE=((aa[0]=='A')||(aa[0]=='G'));
               bool aaPYRIMIDINE=((aa[0]=='T')||(aa[0]=='C')||(aa[0]=='U'));
               bool abPURINE=((ab[0]=='A')||(ab[0]=='G'));
               bool abPYRIMIDINE=((ab[0]=='T')||(ab[0]=='C')||(ab[0]=='U'));
               if( (aaPURINE&&abPURINE)||
                   (aaPYRIMIDINE&&abPYRIMIDINE) ){
               }else{
                  if( nP1>(mP1+1) )nP1=(mP1+1);
                  if( bP1>(aP1+1) )bP1=(aP1+1);
                  MUTATION=false;
               }
            }else if( c1=='p' ){
               if( (aa=="PO  ")||(aa=="PSR ")||(aa=="PSS ") ){
                  MUTATION=false;
               }else{
               }
            }else if( c1=='s' ){
            }
         }
         if( MUTATION ){
            for(iP1=mP1;iP1<=nP1;iP1++){
               std::string atm=P1[iP1].atm;
               for(int jP1=aP1;jP1<=bP1;jP1++){
                  if( a.P1[jP1].atm==atm ){
                     P1[iP1].sub=1;
                     P1[iP1].x=a.P1[jP1].x;
                     break;
                  }
               }
            }
         }else{
            for(iP1=mP1;iP1<=nP1;iP1++){
               P1[iP1].sub=1;
               P1[iP1].x=a.P1[iP1-mP1+aP1].x;
            }
         }
         if( MUTATION ){
            if      ( c1=='a' ){
               if( aa=="PRO " ){
                  if( iR0>mR0 ){
                     int i0P1=iatom(iR0  ," N  ");
                     int i1P1=iatom(iR0  ," CA ");
                     int i2P1=iatom(iR0-1," C  ");
                     int i3P1=iatom(iR0  ," CD ");
                     if( (P1[i0P1].sub==1)&&
                         (P1[i1P1].sub==1)&&
                         (P1[i2P1].sub==1) ){
                        Coordinates u=( P1[i1P1].x -P1[i0P1].x).normalize();
                        Coordinates v=( P1[i2P1].x -P1[i0P1].x);
                        double vu= dot(v,u);
                        v-=vu*u;
                        v.normalize();
                        double C= std::cos(( 113.00));
                        double S= std::sin(( 113.00));
                        Coordinates x;
                        x(0)=(  C*u(0) -S*v(0));
                        x(1)=(  C*u(1) -S*v(1));
                        x(2)=(  C*u(2) -S*v(2));
                        P1[i3P1].sub=1;
                        P1[i3P1].x=( P1[i0P1].x +(1.46)*x);
                     }
                  }else{
                     int i0P1=iatom(iR0  ," N  ");
                     int i1P1=iatom(iR0  ," CA ");
                     int i2P1=iatom(iR0  ," C  ");
                     int i3P1=iatom(iR0  ," CD ");
                     if( (P1[i0P1].sub==1)&&
                         (P1[i1P1].sub==1)&&
                         (P1[i2P1].sub==1) ){
                        Coordinates u=( P1[i1P1].x -P1[i0P1].x).normalize();
                        Coordinates v=( P1[i2P1].x -P1[i1P1].x);
                        double vu= dot(v,u);
                        v-=vu*u;
                        v.normalize();
                        v*=(-1.00);
                        Coordinates w= cross(u,v);
                        double C= std::cos((  65.00));
                        double S= std::sin((  65.00));
                        Coordinates p;
                        p(0)=(  C*v(0) +S*w(0));
                        p(1)=(  C*v(1) +S*w(1));
                        p(2)=(  C*v(2) +S*w(2));
                        C= std::cos(( 113.00));
                        S= std::sin(( 113.00));
                        Coordinates x;
                        x(0)=(  C*u(0) +S*p(0));
                        x(1)=(  C*u(1) +S*p(1));
                        x(2)=(  C*u(2) +S*p(2));
                        P1[i3P1].sub=1;
                        P1[i3P1].x=( P1[i0P1].x +(1.46)*x);
                     }
                  }
               }
            }else if( c1=='e' ){
            }else if( c1=='r' ){
            }else if( c1=='b' ){
            }else if( c1=='p' ){
               if( aa=="5PO " ){
                  int i0P1=a.iatom(iR0+1," C4'");
                  int i1P1=a.iatom(iR0+1," C5'");
                  int i2P1=  iatom(iR0  ," O5'");
                  int i3P1=  iatom(iR0  ," P  ");
                  int i4P1=  iatom(iR0  ," O1P");
                  if( (a.P1[i0P1].sub==1)&&
                      (a.P1[i1P1].sub==1)&&
                      (  P1[i2P1].sub==1) ){
                     Coordinates u=(   P1[i2P1].x -a.P1[i1P1].x).normalize();
                     Coordinates v=( a.P1[i0P1].x -a.P1[i1P1].x);
                     double vu= dot(v,u);
                     v-=vu*u;
                     v.normalize();
                     Coordinates w= cross(u,v);
                     double D= (1.621);
                     double CT= std::cos((  60.90));
                     double ST= std::sin((  60.90));
                     double CP= std::cos((-176.50));
                     double SP= std::sin((-176.50));
                     Coordinates p;
                     p(0)= D*CT;
                     p(1)= D*ST*CP;
                     p(2)= D*ST*SP;
                     Coordinates x;
                     x(0)=(  p(0)*u(0) +p(1)*v(0) +p(2)*w(0));
                     x(1)=(  p(0)*u(1) +p(1)*v(1) +p(2)*w(1));
                     x(2)=(  p(0)*u(2) +p(1)*v(2) +p(2)*w(2));
                     P1[i3P1].sub=1;
                     P1[i3P1].x=( P1[i2P1].x +x);
                     u=(   P1[i3P1].x -  P1[i2P1].x).normalize();
                     v=( a.P1[i1P1].x -  P1[i2P1].x);
                     vu= dot(v,u);
                     v-=vu*u;
                     v.normalize();
                     w= cross(u,v);
                     D= (1.514);
                     CT= std::cos((  73.65));
                     ST= std::sin((  73.65));
                     CP= std::cos(( 180.00));
                     SP= std::sin(( 180.00));
                     p(0)= D*CT;
                     p(1)= D*ST*CP;
                     p(2)= D*ST*SP;
                     x(0)=(  p(0)*u(0) +p(1)*v(0) +p(2)*w(0));
                     x(1)=(  p(0)*u(1) +p(1)*v(1) +p(2)*w(1));
                     x(2)=(  p(0)*u(2) +p(1)*v(2) +p(2)*w(2));
                     P1[i4P1].sub=1;
                     P1[i4P1].x=( P1[i3P1].x +x);
                  }
               }
            }else if( c1=='s' ){
            }
         }
      }
   }
}

int Structure::iatom(int iR0,std::string atm) const{
   int mP1=R0[iR0].P1a;
   int nP1=(mP1+R0[iR0].cP1);
   for(int jP1=mP1;jP1<nP1;jP1++){
      if( P1[jP1].atm==atm ){
         return jP1;
      }
   }
   return -1;
}
int Structure::itorsion(int iR0,std::string tor) const{
   int mT1=R0[iR0].T1a;
   int nT1=(mT1+R0[iR0].cT1);
   for(int jT1=mT1;jT1<nT1;jT1++){
      if( T1[jT1].tor==tor ){
         return jT1;
      }
   }
   return -1;
}
void Structure::operator=(const Structure& a){
   Z0.clear();
   R0.clear();
   P1.clear();
   T1.clear();
   S0.clear();
   o_S0N2Z0.clear();
   o_S0N2R0.clear();
   V0.clear();
   fam=a.fam;
   mol=a.mol;
   cnf=a.cnf;
   nZ0=a.nZ0;
   nS0=a.nS0;
   nV0=a.nV0;
   for(int iZ0= 0;iZ0<a.nZ0;iZ0++){
      Z0.push_back( tZ0());
      Z0[iZ0].R0a=a.Z0[iZ0].R0a;
      Z0[iZ0].cR0=a.Z0[iZ0].cR0;
      Z0[iZ0].trans=a.Z0[iZ0].trans;
      Z0[iZ0].rot=a.Z0[iZ0].rot;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tR0());
         R0[iR0].aa=a.R0[iR0].aa;
         R0[iR0].L0=a.R0[iR0].L0;
         R0[iR0].c1=a.R0[iR0].c1;
         R0[iR0].cha=a.R0[iR0].cha;
         R0[iR0].res=a.R0[iR0].res;
         R0[iR0].ins=a.R0[iR0].ins;
         R0[iR0].core=a.R0[iR0].core;
         R0[iR0].C7=a.R0[iR0].C7;
         R0[iR0].P1a=a.R0[iR0].P1a;
         R0[iR0].cP1=a.R0[iR0].cP1;
         R0[iR0].T1a=a.R0[iR0].T1a;
         R0[iR0].cT1=a.R0[iR0].cT1;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1.push_back( tP1());
            P1[iP1].atm=a.P1[iP1].atm;
            P1[iP1].typ=a.P1[iP1].typ;
            P1[iP1].sc=a.P1[iP1].sc;
            P1[iP1].sub=a.P1[iP1].sub;
            P1[iP1].x=a.P1[iP1].x;
         }
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            T1.push_back( tT1());
            T1[iT1].tor=a.T1[iT1].tor;
            T1[iT1].chi= a.T1[iT1].chi;
         }
      }
   }
   for(int iS0= 0;iS0<a.nS0;iS0++){
      S0.push_back( tS0());
      for(int iN2=0;iN2<2;iN2++){
         o_S0N2Z0.push_back( a.S0N2Z0(iS0,iN2));
         o_S0N2R0.push_back( a.S0N2R0(iS0,iN2));
      }
   }
   return;
}
void Structure::operator+=(const Structure& a){
   int oZ0=nZ0;
   int oR0=R0.size();
   int oP1=P1.size();
   int oT1=T1.size();
   nZ0+=a.nZ0;
   nS0+=a.nS0;
   nV0+=a.nV0;
   for(int iZ0= 0;iZ0<a.nZ0;iZ0++){
      Z0.push_back( tZ0());
      Z0[oZ0+iZ0].R0a=(oR0+a.Z0[iZ0].R0a);
      Z0[oZ0+iZ0].cR0=a.Z0[iZ0].cR0;
      Z0[oZ0+iZ0].trans=a.Z0[iZ0].trans;
      Z0[oZ0+iZ0].rot=a.Z0[iZ0].rot;
      int mR0=a.Z0[iZ0].R0a;
      int nR0=(mR0-1+a.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tR0());
         R0[oR0+iR0].aa=a.R0[iR0].aa;
         R0[oR0+iR0].L0=a.R0[iR0].L0;
         R0[oR0+iR0].c1=a.R0[iR0].c1;
         R0[oR0+iR0].cha=a.R0[iR0].cha;
         R0[oR0+iR0].res=a.R0[iR0].res;
         R0[oR0+iR0].ins=a.R0[iR0].ins;
         R0[oR0+iR0].core=a.R0[iR0].core;
         R0[oR0+iR0].C7=a.R0[iR0].C7;
         R0[oR0+iR0].P1a=(oP1+a.R0[iR0].P1a);
         R0[oR0+iR0].cP1=a.R0[iR0].cP1;
         R0[oR0+iR0].T1a=(oT1+a.R0[iR0].T1a);
         R0[oR0+iR0].cT1=a.R0[iR0].cT1;
         int mP1=a.R0[iR0].P1a;
         int nP1=(mP1-1+a.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1.push_back( tP1());
            P1[oP1+iP1].atm=a.P1[iP1].atm;
            P1[oP1+iP1].typ=a.P1[iP1].typ;
            P1[oP1+iP1].sc=a.P1[iP1].sc;
            P1[oP1+iP1].sub=a.P1[iP1].sub;
            P1[oP1+iP1].x=a.P1[iP1].x;
         }
         int mT1=a.R0[iR0].T1a;
         int nT1=(mT1-1+a.R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            T1.push_back( tT1());
            T1[oT1+iT1].tor=a.T1[iT1].tor;
            T1[oT1+iT1].chi= a.T1[iT1].chi;
         }
      }
   }
   for(int iS0= 0;iS0<a.nS0;iS0++){
      S0.push_back( tS0());
      for(int iN2=0;iN2<2;iN2++){
         o_S0N2Z0.push_back( oZ0+a.S0N2Z0(iS0,iN2));
         o_S0N2R0.push_back( oR0+a.S0N2R0(iS0,iN2));
      }
   }
   return;
}
void Structure::generate(const Coordinates& TRANS,
                         const Rotation_Matrix& ROT,
                         const Structure& a){
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1[iP1].x.generate(TRANS,ROT,a.P1[iP1].x);
         }
      }
   }
   return;
}
