#ifndef DEF_SEARCH_SUBSPACE
#define DEF_SEARCH_SUBSPACE

#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
class Mechanical_System;
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Search_Subspace {
public:
   class tR1 { /*residues containing variable torsions*/
   public:
      int Z0;                   //index into set of chains
      int R0;                   //index into set of residues
      int L0;                   //index into set of residue types
      std::string aa;           //4 char residue name
      /*search through conformation space: 0=fixed
                                           1=variable, not searched
                                           2=variable, searched*/
      int bb;                   //bb
      int sc;                   //sc
      int pt;                   //length of variable segment
      /*search through sequence space*/
      int R3a;                  //start index into residues allowed
      int cR3;                  //number
      int jR3;                  //index of current combination
      /*mappings specific to base sequence*/
      int T5a;                  //start index into set of variable torsions
      int cT5;                  //number
      Coordinates ca;           //position of Calp (angstrom)
      Coordinates cb;           //position of Cbet (angstrom)
      int Q1bb;                 //index preceding string of bb torsions
      int Q1sc;                 //index preceding string of sc torsions
      int ortho;                //recent inclusion in hot subset
      tR1(){}
   };
   class tR3 { /*residues allowed at search positions*/
   public:
      std::string aa;           //4 char residue name
      int L0;                   //index into set of residue types
      tR3(){}
   };
   class tT5 { /*torsions in search subspace [iupac order]*/
   public:
      std::string tor;          //3 char tosion name
      tT5(){}
   };

public:
   int nR1;                     //number
   std::vector<tR1> R1;         //set of residues of search subspace
   std::vector<tR3> R3;         //residue ranges combined to form sequence space
   int mBOD;                    //variable chain translation+rotation
   std::vector<tT5> T5;         //set of torsions in search subspace

   void FIL2STP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Structure& str,
                const Thread_Options& opt);
   void UNIONSC(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Structure& str);
   void DOCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const Structure& str,
               const Coordinates& d,
               int jZ0,int jR0);
   void DOCSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const Structure& str);
   void PCKSTP(const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const std::vector<Structure>& G9str);
   void MECHSYS(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Mechanical_System& mol);

   Search_Subspace():
      nR1(0)
   {
   }
   Search_Subspace(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const Search_Subspace& a,
                   const Structure& str);
   int iresidue(int iR0) const;
};

#endif
