#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include <string>

Search_Subspace::Search_Subspace(const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                 const Search_Subspace& a,
                                 const Structure& str){
   nR1=a.nR1;
   for(int jR1=0;jR1<nR1;jR1++){
      R1.push_back( tR1());
      R1[jR1].Z0=a.R1[jR1].Z0;
      R1[jR1].R0=a.R1[jR1].R0;
      int iR3=a.R1[jR1].jR3;
      int iL0=a.R3[iR3].L0;
      char c1=residue_mappings.L0[iL0].c1;
      std::string aa=a.R3[iR3].aa;
      R1[jR1].L0=iL0;
      R1[jR1].aa=aa;
      int bb=a.R1[jR1].bb;
      if( bb> 0 ){
         if      ( c1=='a' ){
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
            if( aa=="5OH " ){
               bb=0;
            }
         }else if( c1=='s' ){
         }
      }
      R1[jR1].bb=bb;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      int sc=a.R1[jR1].sc;
      if( sc==2 ){
         if      ( c1=='a' ){
            if( (aa=="ALA ")||(aa=="PRO ")||(aa=="AIB ") ){
               sc=1;
            }else if( aa=="GLY " ){
               sc=0;
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if( (aa=="D   ")||(aa=="R   ")||(aa=="RF  ")||
                (aa=="LNA ")||(aa=="CET ") ){
               sc=1;
            }
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
      R1[jR1].sc=sc;
      R1[jR1].pt=a.R1[jR1].pt;
      R1[jR1].R3a=jR1;
      R1[jR1].cR3=1;
      R1[jR1].jR3=jR1;
      R3.push_back( tR3());
      R3[jR1].aa=R1[jR1].aa;
      R3[jR1].L0=R1[jR1].L0;
   }
   mBOD=a.mBOD;
   int mT5=0;
   for(int jR1=0;jR1<nR1;jR1++){
      int iR0=R1[jR1].R0;
      int iL0=R1[jR1].L0;
      char c1=residue_mappings.L0[iL0].c1;
      std::string aa=R1[jR1].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      R1[jR1].T5a=mT5;
      R1[jR1].cT5=str.R0[iR0].cT1;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         T5.push_back( tT5());
         T5[iT1-mT1+mT5].tor=str.T1[iT1].tor;
      }
      mT5+=R1[jR1].cT5;
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )R1[jR1].ca=str.P1[iP1].x;
            if( atm==" CB " )R1[jR1].cb=str.P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )R1[jR1].ca=str.P1[iP1].x;
               if( atm==" CM'" )R1[jR1].cb=str.P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )R1[jR1].ca=str.P1[iP1].x;
               if( atm==" CA'" )R1[jR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )R1[jR1].ca=str.P1[iP1].x;
               if( atm==" N1 " )R1[jR1].cb=str.P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )R1[jR1].ca=str.P1[iP1].x;
               if( atm==" C4 " )R1[jR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
}

int Search_Subspace::iresidue(int iR0) const{
   for(int jR1= 0;jR1<nR1;jR1++){
      if( R1[jR1].R0==iR0 ){
         return jR1;
      }
   }
   return -1;
}
