#ifndef DEF_FAMILY
#define DEF_FAMILY

#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include <string>
#include <vector>

class Family { /*related systems of molecules of a family*/
public:
   class tM1 { /*system of molecules of a family*/
   public:
      class tM1Z0 { /*chain in system of molecules*/
      public:
         int R0a;               //start index into set of residues
         int cR0;               //number of residues
         Coordinates trans;     //translation (bohr)
         Coordinates rot;       //rotation euler angles (radian)
         tM1Z0(){}
      };
      class tM1R0 { /*residue in chains*/
      public:
         std::string aa;        //4 char residue name
         int L0;                //index into set of residue types
         char c1;               //1 char class name
         char cha;              //pdb chain identifier
         int res;               //pdb residue sequence number
         char ins;              //pdb insertion character
         char core;             //core/surface character
         int C7;                //secondary structure state
         int P1a;               //start index into set of atoms
         int cP1;               //number of atoms
         int T1a;               //start index into set of torsions
         int cT1;               //number of torsions
         double e;              //defect energy
         int sub;               //C-alpha flag, {no,yes}={0,1}
         Coordinates x;         //C-alpha coordinates (angstrom)
         int Z0;                //index into set of chains
         int L1;                //index into 20 natural amino acids
         bool ss;               //Cys contributing to disulfide crosslink
         char scr;              //{'#'=scr, ' '=non scr}
         int gap;               //{0=cha(1), 1=non scr+scr(1), 3=scr(2,n)}
         tM1R0(){}
      };
      class tM1P1 { /*physical atom in chains [iupac order]*/
      public:
         std::string atm;       //4 char atom name
         int typ;               //atom type
         int sc;                //side chain atom flag, {bb,sc}={0,1}
         int sub;               //position coordinates flag, {unset,set}={0,1}
         Coordinates x;         //atom coordinates (angstrom)
         tM1P1(){}
      };
      class tM1T1 { /*torsion in chains [iupac order]*/
      public:
         std::string tor;       //3 char torsion name
         double chi;            //torsion value (degree)
         tM1T1(){}
      };
      class tM1S0 { /*disulfide bond in system of molecules*/
      public:
         tM1S0(){}
      };
      class tM1X8 { /*virtual Calpha--Calpha bond*/
      public:
         Coordinates x;         //base Calpha coordinates (angstrom)
         Coordinates c;         //virtual bond unit vector
         int Z0;                //mapping to chain
         int R0;                //mapping to residue
         Coordinates t;         //partial sum of unit vectors
         tM1X8(){}
      };
      class tM1U5 { /*structurally conserved region*/
      public:
         int Z0;                //index into set of chains
         int R0a;               //start index into set of residues
         int cR0;               //length
         tM1U5(){}
      };
      class tM1P8 { /*position in alignment*/
      public:
         int aR0;               //residue in target
         int bR0;               //residue in template
         char alp;              //
         char bet;              //
         char scr;              //
         tM1P8(){}
      };

   private:
      std::vector<int> o_S0N2Z0;        //pair of indexes into set of chains
      std::vector<int> o_S0N2R0;        //pair of indexes into set of residues

   public:
      std::string fam;                  //family
      std::string mol;                  //system of molecules
      std::string cnf;                  //conformation
      double e[15];                     //total energy and components
      int nZ0;                          //number of chains
      int nS0;                          //number of disulfide crosslinks
      std::vector<tM1Z0> Z0;            //set of chains
      std::vector<tM1R0> R0;            //set of residues
      std::vector<tM1P1> P1;            //set of physical atoms
      std::vector<tM1T1> T1;            //set of torsions
      std::vector<tM1S0> S0;            //set of disulfide bonds
      int nX8;                          //number
      std::vector<tM1X8> X8;            //set of virtual Calpha--Calpha bonds
      double pid;                       //percent identity
      std::vector<tM1U5> U5;            //set of structurally conserved regions
      int nP8;                          //number
      std::vector<tM1P8> P8;            //set of positions in alignment

      int& S0N2Z0(int i,int j){
         return o_S0N2Z0.at( i*2 +j);
      }
      const int& S0N2Z0(int i,int j) const {
         return o_S0N2Z0.at( i*2 +j);
      }
      int& S0N2R0(int i,int j){
         return o_S0N2R0.at( i*2 +j);
      }
      const int& S0N2R0(int i,int j) const {
         return o_S0N2R0.at( i*2 +j);
      }

      tM1(){}

      void operator=(const Structure& a);
   };

private:
   std::vector<int> o_M1ord;    //order

public:
   int nM1;                     //number
   std::vector<tM1> M1;         //set
   int nU5;                     //number of structurally conserved regions

   int& M1ord(int i){
      return o_M1ord.at( i);
   }

   void STR2FAM(int jM1,const Structure& a);
   void sort();

   Family():
      nM1(0)
   {
   }
};

#endif
