#include "../fil/Structure.hh"
#include "../fil/Family.hh"

void Family::tM1::operator=(const Structure& a){
   Z0.clear();
   R0.clear();
   P1.clear();
   T1.clear();
   X8.clear();
   U5.clear();
   P8.clear();
   fam=a.fam;
   mol=a.mol;
   cnf=a.cnf;
   nZ0=a.nZ0;
   nS0=a.nS0;
   nX8=0;
   nP8=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      Z0.push_back( tM1Z0());
      Z0[iZ0].R0a=a.Z0[iZ0].R0a;
      Z0[iZ0].cR0=a.Z0[iZ0].cR0;
      Z0[iZ0].trans=a.Z0[iZ0].trans;
      Z0[iZ0].rot=a.Z0[iZ0].rot;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         R0.push_back( tM1R0());
         R0[iR0].aa=a.R0[iR0].aa;
         R0[iR0].L0=a.R0[iR0].L0;
         R0[iR0].c1=a.R0[iR0].c1;
         R0[iR0].cha=a.R0[iR0].cha;
         R0[iR0].res=a.R0[iR0].res;
         R0[iR0].ins=a.R0[iR0].ins;
         R0[iR0].core=a.R0[iR0].core;
         R0[iR0].C7=a.R0[iR0].C7;
         R0[iR0].P1a=a.R0[iR0].P1a;
         R0[iR0].cP1=a.R0[iR0].cP1;
         R0[iR0].T1a=a.R0[iR0].T1a;
         R0[iR0].cT1=a.R0[iR0].cT1;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            P1.push_back( tM1P1());
            P1[iP1].atm=a.P1[iP1].atm;
            P1[iP1].typ=a.P1[iP1].typ;
            P1[iP1].sc=a.P1[iP1].sc;
            P1[iP1].sub=a.P1[iP1].sub;
            P1[iP1].x= a.P1[iP1].x;
         }
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            T1.push_back( tM1T1());
            T1[iT1].tor=a.T1[iT1].tor;
            T1[iT1].chi= a.T1[iT1].chi;
         }
      }
   }
   S0.clear();
   o_S0N2Z0.clear();
   o_S0N2R0.clear();
   for(int iS0= 0;iS0<nS0;iS0++){
      S0.push_back( tM1S0());
      for(int iN2=0;iN2<2;iN2++){
         o_S0N2Z0.push_back(a.S0N2Z0(iS0,iN2));
         o_S0N2R0.push_back(a.S0N2R0(iS0,iN2));
      }
   }
   return;
}

void Family::sort(){
   if( nM1<= 1 )return;
   for(int jM1max=(nM1-1);jM1max> 0;jM1max--){
      bool ORDERED=true;
      double z1= M1[M1ord( 0)].e[ 0];
      for(int jM1= 1;jM1<=jM1max;jM1++){
         double z2= M1[M1ord(jM1)].e[ 0];
         if( z2<z1 ){
            int L=M1ord(jM1);
            M1ord(jM1)=M1ord(jM1-1);
            M1ord(jM1-1)=L;
            ORDERED=false;
         }else{
            z1= z2;
         }
      }
      if( ORDERED )break;
   }
   return;
}
