#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_dst {
public:
   class tT4 { /*atom type used in distance constraints*/
   public:
      class tT4O4 { /*occurrence of atom type in system of molecules*/
      public:
         int Z0;                //index of chain
         int R0;                //index of residue
         int P1;                //index of atom
         tT4O4(){}
      };
   public:
      std::string atm;          //4 char atom name
      int nO4;                  //number of occurrences
      std::vector<tT4O4> O4;    //set of occurrences
      tT4(){}
   };
   class tY4 { /*pair of atom types used in distance constraints*/
   public:
      class tY4R0 { /*residues*/
      public:
         int nC0;               //number of constraints
         tY4R0(){}
      };
   public:
      int N2T4[2];              //pair of atom types
      int pR0;                  //threshold for short range exclusion
      int pS;                   //number of shells
      int pC0;                  //target number of constraints per residue
      int W0;                   //index into harmonic coeffs
      std::vector<tY4R0> R0;    //set of residues
      tY4(){}
   };

public:
   std::vector<tT4> T4;         //set of atom types
   std::vector<tY4> Y4;         //set of pairs of atom types

   MEM_dst(int t):
      T4(t),
      Y4(t*(t+1)/2)
   {
   }
};

Distance_Constraints::Distance_Constraints(
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Thread_Options& opt,
                Output_Streams& out,
                const Structure& str,
                const Search_Subspace& sub){
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oT4;
   if( opt.MODE=="loc" ){
      oT4=8;
   }else{
      oT4=3;
   }
   MEM_dst vv(oT4);
   int oY4=(oT4*(oT4+1)/2);
//
//
// atom types, pairs of atom types
//
   if( opt.MODE=="loc" ){
      vv.T4[ 0].atm=" N  ";
      vv.T4[ 1].atm=" CA ";
      vv.T4[ 2].atm=" O  ";
      vv.T4[ 3].atm=" CB ";
      vv.T4[ 4].atm=" C5'";
      vv.T4[ 5].atm=" C3'";
      vv.T4[ 6].atm=" P  ";
      vv.T4[ 7].atm=" C1'";
//    vv.T4[ 8].atm=" N3 ";
      int iY4=0;
      for(int iT4=0;iT4<oT4;iT4++){
         for(int jT4=iT4;jT4<oT4;jT4++){
            vv.Y4[iY4].N2T4[ 0]=iT4;
            vv.Y4[iY4].N2T4[ 1]=jT4;
            vv.Y4[iY4].pR0= 5;
            vv.Y4[iY4].pS=12;
            vv.Y4[iY4].pC0= 6;
            vv.Y4[iY4].W0=2;
            vv.Y4[iY4].R0.resize(oR0);
            iY4++;
         }
      }

   }else{
      vv.T4[ 0].atm=" CA ";
      vv.T4[ 1].atm=" C3'";
      vv.T4[ 2].atm=" O5'";
      int iY4=0;
      for(int iT4=0;iT4<oT4;iT4++){
         for(int jT4=iT4;jT4<oT4;jT4++){
            vv.Y4[iY4].N2T4[ 0]=iT4;
            vv.Y4[iY4].N2T4[ 1]=jT4;
            vv.Y4[iY4].pR0= 8;
            vv.Y4[iY4].pS=32;
            vv.Y4[iY4].pC0= 2;
            vv.Y4[iY4].W0=6;
            vv.Y4[iY4].R0.resize(oR0);
            iY4++;
         }
      }

   }
//
//
// occurrences
//
   for(int iT4=0;iT4<oT4;iT4++){
      vv.T4[iT4].nO4=0;
   }
   int oR1=sub.nR1;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int bb=0;
         for(int iR1= 0;iR1<oR1;iR1++){
            if( sub.R1[iR1].R0!=iR0 )continue;
            bb=sub.R1[iR1].bb;
            break;
         }
         if( bb>0 )continue;
         int mP1=str.R0[iR0].P1a;
         int nP1=(mP1-1+str.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( str.P1[iP1].sub==0 )continue;
            std::string atm=str.P1[iP1].atm;
            for(int iT4=0;iT4<oT4;iT4++){
               if( vv.T4[iT4].atm!=atm )continue;
               vv.T4[iT4].O4.push_back( MEM_dst::tT4::tT4O4());
               vv.T4[iT4].O4[vv.T4[iT4].nO4  ].Z0=iZ0;
               vv.T4[iT4].O4[vv.T4[iT4].nO4  ].R0=iR0;
               vv.T4[iT4].O4[vv.T4[iT4].nO4++].P1=iP1;
               break;
            }
         }
      }
   }
//
//
// distance constraints
//
   nC0=0;
   for(int iY4= 0;iY4<oY4;iY4++){
      int iT4=vv.Y4[iY4].N2T4[ 0];
      int jT4=vv.Y4[iY4].N2T4[ 1];
      for(int iR0= 0;iR0<oR0;iR0++){
         vv.Y4[iY4].R0[iR0].nC0=0;
      }
      double zRCUT= (2.00);
      double zSCUT= (3.00);
      for(int iS= 0;iS<vv.Y4[iY4].pS;iS++){
         zRCUT+=(1.00);
         zSCUT+=(1.00);
         for(int jO4= 0;jO4<vv.T4[jT4].nO4;jO4++){
            int jZ0=vv.T4[jT4].O4[jO4].Z0;
            int jR0=vv.T4[jT4].O4[jO4].R0;
            int jP1=vv.T4[jT4].O4[jO4].P1;
            int iO4max=( jT4==iT4 )? jO4: vv.T4[iT4].nO4;
            for(int iO4= 0;iO4<iO4max;iO4++){
               int iZ0=vv.T4[iT4].O4[iO4].Z0;
               int iR0=vv.T4[iT4].O4[iO4].R0;
               int iP1=vv.T4[iT4].O4[iO4].P1;
               if( (std::abs(jZ0-iZ0)==0)&&
                   (std::abs(jR0-iR0)<vv.Y4[iY4].pR0) )continue;
               double zR=( str.P1[jP1].x -str.P1[iP1].x).r();
               if( (zR>=zRCUT)&&(zR<zSCUT) ){
                  if( vv.Y4[iY4].R0[jR0].nC0>=vv.Y4[iY4].pC0 )continue;
// C0N2R0(iC0,0) should be less than C0N2R0(iC0,1)
                  int iN2=0;
                  int jN2=1;
                  if( jR0<iR0 ){
                     iN2=1;
                     jN2=0;
                  }
                  C0.push_back( tC0());
                  for(int i=0;i<2;i++){
                     o_C0N2Z0.push_back(-1);
                     o_C0N2R0.push_back(-1);
                     o_C0N2atm.push_back("    ");
                     o_C0N2F0.push_back(-1);
                     o_C0N2G0.push_back(-1);
                     o_C0N2B0.push_back(-1);
                  }
                  C0N2Z0(nC0,iN2)=iZ0;
                  C0N2Z0(nC0,jN2)=jZ0;
                  C0N2R0(nC0,iN2)=iR0;
                  C0N2R0(nC0,jN2)=jR0;
                  C0N2atm(nC0,iN2)=vv.T4[iT4].atm;
                  C0N2atm(nC0,jN2)=vv.T4[jT4].atm;
                  C0[nC0].CYCLE=false;
                  C0[nC0].W0=vv.Y4[iY4].W0;
                  C0[nC0].a0= (0.00);           //not used
                  C0[nC0].d0= (zR/physics_consts.ANG);
                  nC0++;
                  vv.Y4[iY4].R0[iR0].nC0++;
                  vv.Y4[iY4].R0[jR0].nC0++;
               }
            }
         }
      }
   }
//
//
// ring closure crosslinks
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=str.R0[iR0].L0;
         int mK0=residue_mappings.L0[iL0].K0a;
         int nK0=(mK0-1+residue_mappings.L0[iL0].cK0);
         if( nK0<mK0 )continue;
         for(int iK0=mK0;iK0<=nK0;iK0++){
            C0.push_back( tC0());
            for(int iN2=0;iN2<2;iN2++){
               o_C0N2Z0.push_back(iZ0);
               o_C0N2R0.push_back(iR0);
               o_C0N2atm.push_back(residue_mappings.K0N2atm(iK0,iN2));
               o_C0N2F0.push_back(-1);
               o_C0N2G0.push_back(-1);
               o_C0N2B0.push_back(-1);
            }
            C0[nC0].CYCLE=true;
            C0[nC0].W0=-8;                      //not used
            C0[nC0].a0= residue_mappings.K0[iK0].a;
            C0[nC0].d0= residue_mappings.K0[iK0].r;
            nC0++;
         }
      }
   }
//
//
// indexes into atom sets
//
   if( nC0>0 ){
      int jC0=0;
      for(int iC0= 0;iC0<nC0;iC0++){
         C0[jC0].CYCLE=C0[iC0].CYCLE;
         C0[jC0].W0=C0[iC0].W0;
         C0[jC0].a0=C0[iC0].a0;
         C0[jC0].d0=C0[iC0].d0;
         for(int iN2=0;iN2<2;iN2++){
            int iZ0=C0N2Z0(iC0,iN2);
            int iR0=C0N2R0(iC0,iN2);
            std::string atm=C0N2atm(iC0,iN2);
            int iL0=str.R0[iR0].L0;
            C0N2Z0(jC0,iN2)=iZ0;
            C0N2R0(jC0,iN2)=iR0;
            C0N2atm(jC0,iN2)=atm;
            C0N2F0(jC0,iN2)=residue_mappings.if0atom(iL0,atm);
            if( C0N2F0(jC0,iN2)==-1 ){
               std::cerr<<"Unmatched atom name in distance constraint."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-str.Z0[iZ0].R0a+1)
                        <<" atm="<<atm
                        <<".\n";
               jC0--;
               break;
            }
            C0N2G0(jC0,iN2)=residue_mappings.ig0atom(iL0,atm);
            C0N2B0(jC0,iN2)=residue_mappings.ib0atom(iL0,atm);
         }
         jC0++;
      }
      nC0=jC0;
   }
//
//
// diagnostic output
//
// if( out.VERBOSE ){
//    out.FILE3<<" nC0="<< std::setw( 6)<<nC0<<'\n';
// }
// if( nC0> 0 ){
//    out.FILE3<< std::fixed;
//    for(int iC0= 0;iC0<nC0;iC0++){
//       for(int iN2=0;iN2<2;iN2++){
//          out.FILE3<<'['<< std::setw( 2)<<C0N2Z0(iC0,iN2)<<' '
//                        << std::setw( 4)<<C0N2R0(iC0,iN2)<<' '
//                        <<C0N2atm(iC0,iN2)<<']';
//       }
//       out.FILE3<<' '<< std::setw( 1)<<int(C0[iC0].CYCLE)
//                <<' '<< std::setw( 3)<<C0[iC0].W0
//                << std::setprecision(2)
//                <<' '<< std::setw( 9)<<(physics_consts.CAL*C0[iC0].a0)
//                << std::setprecision(4)
//                <<' '<< std::setw( 9)<<(physics_consts.ANG*C0[iC0].d0)<<'\n';
//    }
// }
// out.FILE3<<"Y4\n";
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mR0=str.Z0[iZ0].R0a;
//    int nR0=(mR0-1+str.Z0[iZ0].cR0);
//    for(int iR0=mR0;iR0<=nR0;iR0++){
//       out.FILE3<<'['<< std::setw( 2)<<iZ0<<','<< std::setw( 4)<<iR0<<']';
//       for(int iY4= 0;iY4<oY4;iY4++){
//          out.FILE3<< std::setw( 4)<<vv.Y4[iY4].R0[iR0].nC0;
//       }
//       out.FILE3<<'\n';
//    }
// }
}
