#ifndef DEF_DISTANCE_CONSTRAINTS
#define DEF_DISTANCE_CONSTRAINTS

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Distance_Constraints {
public:
   class tC0 { /*atom pairs with distance constraint in system of molecules*/
   public:
      bool CYCLE;               //closes an intraresidue covalent cycle
      int W0;                   //index into harmonic coeffs
      double a0;                //harmonic coeff (hart/bohr**2)
      double d0;                //target distance (bohr)
      tC0(){}
   };

private:
   std::vector<int> o_C0N2Z0;           //indexes into chains
   std::vector<int> o_C0N2R0;           //indexes into residues
   std::vector<std::string> o_C0N2atm;  //atom names
   std::vector<int> o_C0N2F0;           //indexes into atoms of residues
   std::vector<int> o_C0N2G0;           //indexes into residue forward groups
   std::vector<int> o_C0N2B0;           //indexes into residue base groups

   int& C0N2Z0(int i,int j){
      return o_C0N2Z0.at( i*2 +j);
   }
   int& C0N2R0(int i,int j){
      return o_C0N2R0.at( i*2 +j);
   }
   std::string& C0N2atm(int i,int j){
      return o_C0N2atm.at( i*2 +j);
   }
   int& C0N2F0(int i,int j){
      return o_C0N2F0.at( i*2 +j);
   }
   int& C0N2G0(int i,int j){
      return o_C0N2G0.at( i*2 +j);
   }
   int& C0N2B0(int i,int j){
      return o_C0N2B0.at( i*2 +j);
   }

public:
   int nC0;                     //number
   std::vector<tC0> C0;         //set of atom pairs with distance constraint

   const int& C0N2Z0(int i,int j) const {
      return o_C0N2Z0.at( i*2 +j);
   }
   const int& C0N2R0(int i,int j) const {
      return o_C0N2R0.at( i*2 +j);
   }
   const int& C0N2F0(int i,int j) const {
      return o_C0N2F0.at( i*2 +j);
   }
   const int& C0N2G0(int i,int j) const {
      return o_C0N2G0.at( i*2 +j);
   }
   const int& C0N2B0(int i,int j) const {
      return o_C0N2B0.at( i*2 +j);
   }

   Distance_Constraints(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const Thread_Options& opt,
                        Output_Streams& out,
                        const Structure& str,
                        const Search_Subspace& sub);
   Distance_Constraints():
      nC0(0)
   {
   }
};

#endif
