#ifndef DEF_DOMAIN_DEFINITIONS
#define DEF_DOMAIN_DEFINITIONS

#include <string>
#include <vector>

class Domain_Definitions {
public:
   class tQ8 { /*SCOP domain definition*/
   public:
      std::string mol;          //6-char SCOP domain name
      int nZ1;                  //number of segments
      tQ8(){}
   };

private:
   std::vector<char> o_Q8Z1cha;         //chain id
   std::vector<int> o_Q8Z1N2res;        //residue indexes of start and end
   std::vector<char> o_Q8Z1N2ins;       //insertion characters of start and end

   char& Q8Z1cha(int i,int j){
      return o_Q8Z1cha[ i*4 +j];
   }
   int& Q8Z1N2res(int i,int j,int k){
      return o_Q8Z1N2res[ i*8 +j*2 +k];
   }
   char& Q8Z1N2ins(int i,int j,int k){
      return o_Q8Z1N2ins[ i*8 +j*2 +k];
   }

public:
   int nQ8;                     //number
   std::vector<tQ8> Q8;         //set of SCOP domain definitions
   int iQ8;                     //

   const char& Q8Z1cha(int i,int j) const {
      return o_Q8Z1cha[ i*4 +j];
   }
   const int& Q8Z1N2res(int i,int j,int k) const {
      return o_Q8Z1N2res[ i*8 +j*2 +k];
   }
   const char& Q8Z1N2ins(int i,int j,int k) const {
      return o_Q8Z1N2ins[ i*8 +j*2 +k];
   }

   Domain_Definitions(std::string FAMILY);
};

#endif
