#include "../dom/Domain_Definitions.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_Domain_Definitions {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_Domain_Definitions(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

Domain_Definitions::Domain_Definitions(std::string FAMILY){
   MEM_Domain_Definitions vv;
   std::string rec;
   {
      std::string filename="../../"+FAMILY+"/arg/domains";
      std::ifstream ifile(filename.c_str());
      while( !std::getline(ifile,rec).eof() ){
         vv.o_Lrec.push_back(rec);
      }
      ifile.close();
   }
   int p=0;
   std::istringstream(vv.Lrec(p++))>>nQ8;
   Q8.resize(nQ8);
   o_Q8Z1cha.resize(nQ8*4, ' ');
   o_Q8Z1N2res.resize(nQ8*4*2, -1);
   o_Q8Z1N2ins.resize(nQ8*4*2, ' ');
   for(int iQ8=0;iQ8<nQ8;iQ8++){
      Q8[iQ8].mol=vv.Lrec(p  ).substr( 0, 6);
      Q8[iQ8].nZ1=((vv.Lrec(p  ).size()-6)/16);
      for(int iZ1=0;iZ1<Q8[iQ8].nZ1;iZ1++){
         int m=( 6 +16*iZ1);
         rec=vv.Lrec(p  ).substr( m,16);
         if( (rec[ 1]!='(')||(rec[ 3]!=':')||(rec[ 9]!='-')||(rec[15]!=')') ){
            std::cerr<<"ERROR: Inconsistency in domain definition, iQ8="
                     << std::setw( 4)<<iQ8<<".\n";
            std::exit( 1);
         }
         Q8Z1cha(iQ8,iZ1)=rec[ 2];
         Q8Z1N2ins(iQ8,iZ1, 0)=rec[ 8];
         Q8Z1N2ins(iQ8,iZ1, 1)=rec[14];
         if( rec.substr( 4,11)=="     -     " ){
            Q8Z1N2res(iQ8,iZ1, 0)=-9999;
            Q8Z1N2res(iQ8,iZ1, 1)= 9999;
         }else{
            std::istringstream(rec.substr( 4, 4))>>Q8Z1N2res(iQ8,iZ1, 0);
            std::istringstream(rec.substr(10, 4))>>Q8Z1N2res(iQ8,iZ1, 1);
         }
      }
      p++;
   }
}
