#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <cmath>

class MEM_deg {
private:
   std::vector<int> o_R0K2;             //pattern of degrees of freedom
   std::vector<Coordinates> o_R1c;      //unit vector along CA-->CB
   std::vector<Coordinates> o_R1g;      //center of sc ellipsoid
   int oR1;                             //
   std::vector<bool> o_R1R1sub;         //contact is possible for sc pair
   std::vector<bool> o_R1sub;           //sc is contained in packing unit
   std::vector<int> o_R1I3a;            //start index of sc contacts
   std::vector<int> o_R1cI3;            //number of sc contacts
   std::vector<int> o_R1I3b;            //start of higher index sc contacts
   std::vector<int> o_R1dI3;            //number of lower index sc contacts
   std::vector<int> o_Y3iR1;            //packing unit of size oY3
public:
   std::vector<int> o_I3R1;             //mapping to index of sc
   MEM_deg(int o0,int o1):
      o_R0K2(o0),
      o_R1c(o1),
      o_R1g(o1),
      oR1(o1),
      o_R1R1sub(o1*o1,false),
      o_R1sub(o1),
      o_R1I3a(o1),
      o_R1cI3(o1, 0),
      o_R1I3b(o1),
      o_R1dI3(o1, 0),
      o_Y3iR1(12)
   {
   }
   int& R0K2(int i){
      return o_R0K2.at( i);  }
   Coordinates& R1c(int i){
      return o_R1c.at( i);  }
   Coordinates& R1g(int i){
      return o_R1g.at( i);  }
   void R1R1sub(int i,int j,bool a){
      o_R1R1sub[ i*oR1 +j]=a;  }
   bool R1R1sub(int i,int j){
      return o_R1R1sub[ i*oR1 +j];  }
   void R1sub(int i,bool a){
      o_R1sub[ i]=a;  }
   bool R1sub(int i){
      return o_R1sub[ i];  }
   int& R1I3a(int i){
      return o_R1I3a.at( i);  }
   int& R1cI3(int i){
      return o_R1cI3.at( i);  }
   int& R1I3b(int i){
      return o_R1I3b.at( i);  }
   int& R1dI3(int i){
      return o_R1dI3.at( i);  }
   int& I3R1(int i){
      return o_I3R1.at( i);  }
   int& Y3iR1(int i){
      return o_Y3iR1.at( i);  }
};

Subset_Contracted_System::Subset_Contracted_System(
                const DAT_DISULFIDE_LINKS& disulfide_links,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const Thread_Options& opt,
                const Structure& str,
                const Search_Subspace& sub){
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oS0=str.nS0;
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oH1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oH1+=residue_mappings.L0[iL0].cH0;
   }
   int oR1=sub.nR1;
   MEM_deg vv(oR0,oR1);
//
// generate a collection of subsets of degrees of freedom
// and initiate subset contractions of the mechanical system
//
// iK2   amino acid degs of free
//  0  {}
//  1  { omega, phi, psi, chi}
//  2  { phi, psi, chi}
//  3  { omega, phi, psi}
//  4  { phi, psi}
//  5  { chi}
//  6  { omega, phi, psi, ch1}
//  7  { ch1}
// iK2   nucleotide degs of free
//  0  {}
//  1  { eps+zet+alp, bet+gam+del+nu+the, chi}
//  2  { eps+zet+alp, bet+the, chi}
//  3  { eps+zet+alp, bet+gam+del+nu}
//  4  { eps+zet+alp, bet}
//  5  { the, chi}
//  6  { eps+zet+alp, bet+gam+del+nu+th1, ch1}
//  7  { th1, ch1}
//
   if      ( opt.MODE=="loc" ){
      int jR0min=0;
      nM3=0;
      for(int i1= 0;i1<10;i1++){
         char a1=char('0'+i1);
         for(int i2= 0;i2<10;i2++){
            char a2=char('0'+i2);

            int oQ2=oZ0;
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               int mR0=str.Z0[iZ0].R0a;
               int nR0=(mR0+str.Z0[iZ0].cR0);
               for(int iR0=mR0;iR0<nR0;iR0++){
                  int iL0=str.R0[iR0].L0;
                  char c1=residue_mappings.L0[iL0].c1;
                  bool FLEX=false;
                  if      ( c1=='a' ){
                     if( ((iR0-mR0+1)% 8)==0 ){
                        FLEX=true;
                     }
                  }else if( c1=='r' ){
                     if( ((iR0-mR0+2)%15)==0 ){
                        FLEX=true;
                     }
                  }else if( c1=='p' ){
                     if( ((iR0-mR0+3)%15)==0 ){
                        FLEX=true;
                     }
                  }else{
                  }
                  if( FLEX ){
                     vv.R0K2(iR0)=4;
                     int mQ0=residue_mappings.L0[iL0].Q0a;
                     int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
                     for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
                        if( residue_mappings.Q0K2sub(iQ0, 4) )oQ2++;
                     }
                  }else{
                     vv.R0K2(iR0)=0;
                  }
               }
            }
            int jR0max=jR0min;
            for(int jR0=jR0min;jR0<oR0;jR0++){
               jR0max=jR0;
               int jL0=str.R0[jR0].L0;
               int mQ0=residue_mappings.L0[jL0].Q0a;
               int nQ0=(mQ0+residue_mappings.L0[jL0].cQ0);
               int jK2=vv.R0K2(jR0);
               for(int jQ0=mQ0;jQ0<nQ0;jQ0++){
                  if( residue_mappings.Q0K2sub(jQ0,jK2) )oQ2--;
                  if( residue_mappings.Q0K2sub(jQ0,  1) )oQ2++;
               }
               vv.R0K2(jR0)=1;
               if( oQ2>=1700 )break;
            }
            M3.push_back( tM3(oZ0,oR0,oQ1,oU1,oF1,oH1,oQ2));
            M3[nM3].QSUB=std::string("a")+a1+a2;
            M3[nM3].Z0[ 0].sub=false;
            for(int iZ0= 1;iZ0<oZ0;iZ0++){
               M3[nM3].Z0[iZ0].sub=true;
            }
            for(int iR0= 0;iR0<oR0;iR0++){
               int iK2=vv.R0K2(iR0);
               int iL0=str.R0[iR0].L0;
               int mQ0=residue_mappings.L0[iL0].Q0a;
               int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
               for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
                  M3[nM3].R0Q0sub(iR0,iQ0-mQ0,
                                  residue_mappings.Q0K2sub(iQ0,iK2));
               }
            }

            nM3++;
            if( jR0max==(oR0-1) ){
               i1=9;
               break;
            }else{
               jR0min=(jR0max-14);
            }
         }
      }

   }else if( opt.MODE=="bb " ){
      for(int iR0= 0;iR0<oR0;iR0++){
         vv.R0K2(iR0)=0;
      }
      int oQ2=oZ0;
      for(int iR1= 0;iR1<oR1;iR1++){
         int iR0=sub.R1[iR1].R0;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
         if      ( sub.R1[iR1].bb==0 ){
            if( sub.R1[iR1].sc==2 ){
               vv.R0K2(iR0)=7;
               for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
                  if( residue_mappings.Q0K2sub(iQ0, 7) )oQ2++;
               }
            }
         }else if( sub.R1[iR1].bb>=1 ){
            vv.R0K2(iR0)=6;
            for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
               if( residue_mappings.Q0K2sub(iQ0, 6) )oQ2++;
            }
         }
      }
      nM3=1;
      M3.push_back( tM3(oZ0,oR0,oQ1,oU1,oF1,oH1,oQ2));
      M3[ 0].QSUB=opt.QSUB;
      M3[ 0].Z0[ 0].sub=false;
      for(int iZ0= 1;iZ0<oZ0;iZ0++){
         M3[ 0].Z0[iZ0].sub=false;
      }
      for(int iR0= 0;iR0<oR0;iR0++){
         int iK2=vv.R0K2(iR0);
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
            M3[ 0].R0Q0sub(iR0,iQ0-mQ0,
                           residue_mappings.Q0K2sub(iQ0,iK2));
         }
      }

   }else if( opt.MODE=="sc " ){
//
//
// position sc ellipsoids
//
      for(int iR1= 0;iR1<oR1;iR1++){
         if( sub.R1[iR1].sc!=2 )continue;
//       int iZ0=sub.R1[iR1].Z0;
//       int iR0=sub.R1[iR1].R0;
         int iL0=sub.R1[iR1].L0;
         double z= residue_mappings.L0[iL0].del;
         vv.R1c(iR1)=( sub.R1[iR1].cb -sub.R1[iR1].ca);
         vv.R1g(iR1)=( sub.R1[iR1].cb +z*vv.R1c(iR1));
         vv.R1c(iR1).normalize();
      }
//
//
// calculate sc contacts
//
      for(int iR1= 0;iR1<(oR1-1);iR1++){
         if( sub.R1[iR1].sc!=2 )continue;
         int iL0=sub.R1[iR1].L0;
         double aai= std::pow(residue_mappings.L0[iL0].ea,2);
         double bbi= std::pow(residue_mappings.L0[iL0].eb,2);
         for(int jR1=(iR1+1);jR1<oR1;jR1++){
            if( sub.R1[jR1].sc!=2 )continue;
            int jL0=sub.R1[jR1].L0;
            double aaj= std::pow(residue_mappings.L0[jL0].ea,2);
            double bbj= std::pow(residue_mappings.L0[jL0].eb,2);
            Coordinates zD=( vv.R1g(jR1) -vv.R1g(iR1));
            double zR= zD.r();
            zD/=zR;
            double CTi= dot( zD,vv.R1c(iR1));
            double CTCTi= CTi*CTi;
            double STSTi=( (1.00) -CTCTi);
            double CTj= dot( zD,vv.R1c(jR1));
            double CTCTj= CTj*CTj;
            double STSTj=( (1.00) -CTCTj);
            double zRi= std::sqrt( aai*CTCTi +bbi*STSTi);
            double zRj= std::sqrt( aaj*CTCTj +bbj*STSTj);
            if( zR<( ( zRi +zRj) +(3.20)) ){
               vv.R1R1sub(iR1,jR1, true);
            }
         }
      }
      int mI3=0;
      for(int iR1= 0;iR1<oR1;iR1++){
         vv.R1I3a(iR1)=mI3;
         int n=vv.R1cI3(iR1);
         for(int i=0;i<n;i++){
            vv.o_I3R1.push_back(-1);
            mI3++;
         }
         vv.R1I3b(iR1)=mI3;
         for(int jR1=(iR1+1);jR1<oR1;jR1++){
            if( vv.R1R1sub(iR1,jR1) ){
               vv.o_I3R1.push_back(jR1);
               vv.R1cI3(iR1)++;
               vv.R1cI3(jR1)++;
               mI3++;
            }
         }
      }
      for(int iR1= 0;iR1<(oR1-1);iR1++){
         int iI3min=vv.R1I3b(iR1);
         int iI3max=(vv.R1I3a(iR1)+vv.R1cI3(iR1));
         for(int iI3=iI3min;iI3<iI3max;iI3++){
            int jR1=vv.I3R1(iI3);
            vv.I3R1(vv.R1I3a(jR1)+vv.R1dI3(jR1))=iR1;
            vv.R1dI3(jR1)++;
         }
      }
      for(int iR1= 0;iR1<oR1;iR1++){
         int iI3min=vv.R1I3a(iR1);
         int iI3max=(iI3min+vv.R1cI3(iR1));
         for(int iI3=iI3min;iI3<iI3max;iI3++){
            int jR1=vv.I3R1(iI3);
            int jI3min=vv.R1I3a(jR1);
            int jI3max=(jI3min+vv.R1cI3(jR1));
            for(int jI3=jI3min;jI3<jI3max;jI3++){
               int kR1=vv.I3R1(jI3);
               if( kR1>iR1 ){
                  vv.R1R1sub(iR1,kR1, true);
               }
            }
         }
      }
//
//
// partition side chains into packing units
//
      for(int iR1= 0;iR1<oR1;iR1++){
         vv.R1sub(iR1,( sub.R1[iR1].sc==2 )? false: true);
      }
      nM3=0;
      for(int oY3=( oR1<10 )? oR1: 10;oY3> 0;oY3--){
         int iY3= 0;
         vv.Y3iR1( 0)=-1;
         bool GROUP=true;
         for(;;){
            vv.Y3iR1(iY3)++;
            if( (oY3-iY3)>(oR1-vv.Y3iR1(iY3))||
                !GROUP ){
               if( iY3== 0 ){
                  break;
               }else{
                  iY3--;
                  if( iY3== 0 )GROUP=true;
                  continue;
               }

            }else{
               if( vv.R1sub(vv.Y3iR1(iY3)) )continue;
               bool PASS=false;
               for(int jY3= 0;jY3<iY3;jY3++){
                  if( !vv.R1R1sub(vv.Y3iR1(jY3),vv.Y3iR1(iY3)) )PASS=true;
               }
               if( PASS )continue;
               if( iY3==(oY3-1) ){
                  int oQ2=oZ0;
                  for(int jY3= 0;jY3<oY3;jY3++){
                     int jR1=vv.Y3iR1(jY3);
                     vv.R1sub(jR1, true);
                     int jL0=sub.R1[jR1].L0;
                     int mQ0=residue_mappings.L0[jL0].Q0a;
                     int nQ0=(mQ0+residue_mappings.L0[jL0].cQ0);
                     for(int jQ0=mQ0;jQ0<nQ0;jQ0++){
                        if( residue_mappings.Q0K2sub(jQ0, 5) )oQ2++;
                     }
                  }
                  M3.push_back( tM3(oZ0,oR0,oQ1,oU1,oF1,oH1,oQ2));
                  M3[nM3].QSUB=opt.QSUB;
                  M3[nM3].nY3=oY3;
                  for(int jY3= 0;jY3<oY3;jY3++){
                     M3[nM3].Y3R1(jY3)=vv.Y3iR1(jY3);
                  }
                  nM3++;
                  if( iY3== 0 ){
                  }else{
                     GROUP=false;
                  }
               }else{
                  iY3++;
                  vv.Y3iR1(iY3)=vv.Y3iR1(iY3-1);
               }

            }
         }
      }
//
//
// populate degrees of freedom in subset contractions
//
      for(int iM3= 0;iM3<nM3;iM3++){
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            M3[iM3].Z0[iZ0].sub=false;
         }
         for(int iR0= 0;iR0<oR0;iR0++){
            vv.R0K2(iR0)=0;
         }
         int nY3=M3[iM3].nY3;
         for(int iY3= 0;iY3<nY3;iY3++){
            int iR1=M3[iM3].Y3R1(iY3);
            int iR0=sub.R1[iR1].R0;
            vv.R0K2(iR0)=5;
         }
         for(int iR0= 0;iR0<oR0;iR0++){
            int iK2=vv.R0K2(iR0);
            int iL0=str.R0[iR0].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
            for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
               M3[iM3].R0Q0sub(iR0,iQ0-mQ0,
                   residue_mappings.Q0K2sub(iQ0,iK2));
            }
         }
      }

   }else if( opt.MODE=="lp " ){
      for(int iR0= 0;iR0<oR0;iR0++){
         vv.R0K2(iR0)=0;
      }
      int oQ2=oZ0;
      for(int iR1= 0;iR1<oR1;iR1++){
         int iR0=sub.R1[iR1].R0;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
         if      ( sub.R1[iR1].bb==0 ){
            if( sub.R1[iR1].sc>=1 ){
               vv.R0K2(iR0)=5;
               for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
                  if( residue_mappings.Q0K2sub(iQ0, 5) )oQ2++;
               }
            }
         }else if( sub.R1[iR1].bb>=1 ){
            vv.R0K2(iR0)=1;
            for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
               if( residue_mappings.Q0K2sub(iQ0, 1) )oQ2++;
            }
         }
      }
      nM3=1;
      M3.push_back( tM3(oZ0,oR0,oQ1,oU1,oF1,oH1,oQ2));
      M3[ 0].QSUB=opt.QSUB;
      M3[ 0].Z0[ 0].sub=false;
      for(int iZ0= 1;iZ0<oZ0;iZ0++){
         M3[ 0].Z0[iZ0].sub=false;
         int mR0=str.Z0[iZ0].R0a;
         int iR1=sub.iresidue(mR0);
         if( iR1==-1 ){
         }else if( sub.R1[iR1].bb>=1 ){
            M3[ 0].Z0[iZ0].sub=true;
         }
      }
      for(int iR0= 0;iR0<oR0;iR0++){
         int iK2=vv.R0K2(iR0);
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
            M3[ 0].R0Q0sub(iR0,iQ0-mQ0,
                           residue_mappings.Q0K2sub(iQ0,iK2));
         }
      }
      if( opt.QSUB=="pck" ){
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            M3[ 0].Z0[iZ0].sub=true;
         }
      }

    }
//
//
// subset contractions of disulfide bonds
//
   int Tsub[6];
   for(int iM3= 0;iM3<nM3;iM3++){
      M3[iM3].oS1=0;
      if( oS0==0 )continue;
      int jS1=0;
      for(int iS0= 0;iS0<oS0;iS0++){
         int iZ0=str.S0N2Z0(iS0, 0);
         int iR0=str.S0N2R0(iS0, 0);
         int iL0=str.R0[iR0].L0;
         int jZ0=str.S0N2Z0(iS0, 1);
         int jR0=str.S0N2R0(iS0, 1);
         int jL0=str.R0[jR0].L0;
//
//
// topology of forward groups
//
         for(int iT=0;iT<6;iT++){
            Tsub[iT]=0;
         }
         int iO5;
         if( iZ0==jZ0 ){
            int omg,phi,ch1,ch2,psi;
            ch2=(residue_mappings.L0[iL0].cQ0-2);
            ch1=(residue_mappings.L0[iL0].cQ0-3);
            psi=(residue_mappings.L0[iL0].cQ0-1);
            if( M3[iM3].R0Q0sub(iR0,ch2) )Tsub[ 0]=1;
            if( M3[iM3].R0Q0sub(iR0,ch1) )Tsub[ 1]=1;
            if( M3[iM3].R0Q0sub(iR0,psi) )Tsub[ 2]=1;
            omg=0;
            phi=1;
            for(iR0++;iR0<jR0;iR0++){
               iL0=str.R0[iR0].L0;
               psi=(residue_mappings.L0[iL0].cQ0-1);
               if( M3[iM3].R0Q0sub(iR0,omg) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(iR0,phi) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(iR0,psi) )Tsub[ 2]=1;
            }
            ch1=2;
            ch2=3;
            if( M3[iM3].R0Q0sub(jR0,omg) )Tsub[ 2]=1;
            if( M3[iM3].R0Q0sub(jR0,phi) )Tsub[ 3]=1;
            if( M3[iM3].R0Q0sub(jR0,ch1) )Tsub[ 4]=1;
            if( M3[iM3].R0Q0sub(jR0,ch2) )Tsub[ 5]=1;
            iO5=disulfide_links.N1N1N1N1N1N1O5(Tsub[ 0],Tsub[ 1],Tsub[ 2],
                                               Tsub[ 3],Tsub[ 4],Tsub[ 5]);
         }else{
            int omg,phi,ch1,ch2,psi;
            if( (M3[iM3].Z0[iZ0].sub)||
                (M3[iM3].Z0[jZ0].sub) )Tsub[ 2]=1;
            ch2=(residue_mappings.L0[iL0].cQ0-2);
            ch1=(residue_mappings.L0[iL0].cQ0-3);
            phi=(residue_mappings.L0[iL0].cQ0-4);
            omg=0;
            if( M3[iM3].R0Q0sub(iR0,ch2) )Tsub[ 2]=1;
            if( M3[iM3].R0Q0sub(iR0,ch1) )Tsub[ 2]=1;
            if( M3[iM3].R0Q0sub(iR0,phi) )Tsub[ 2]=1;
            if( M3[iM3].R0Q0sub(iR0,omg) )Tsub[ 2]=1;
            int iR0min=str.Z0[iZ0].R0a;
            for(iR0--;iR0>=iR0min;iR0--){
               iL0=str.R0[iR0].L0;
               phi=( iR0==iR0min )? 0: 1;
               psi=(residue_mappings.L0[iL0].cQ0-1);
               if( M3[iM3].R0Q0sub(iR0,omg) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(iR0,phi) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(iR0,psi) )Tsub[ 2]=1;
            }
            ch2=(residue_mappings.L0[jL0].cQ0-2);
            ch1=(residue_mappings.L0[jL0].cQ0-3);
            phi=(residue_mappings.L0[jL0].cQ0-4);
            if( M3[iM3].R0Q0sub(jR0,ch2) )Tsub[ 5]=1;
            if( M3[iM3].R0Q0sub(jR0,ch1) )Tsub[ 4]=1;
            if( M3[iM3].R0Q0sub(jR0,phi) )Tsub[ 3]=1;
            int jR0min=str.Z0[jZ0].R0a;
            if( jR0>jR0min ){
               if( M3[iM3].R0Q0sub(jR0,omg) )Tsub[ 2]=1;
            }
            for(jR0--;jR0>=jR0min;jR0--){
               jL0=str.R0[jR0].L0;
               phi=( jR0==jR0min )? 0: 1;
               psi=(residue_mappings.L0[jL0].cQ0-1);
               if( M3[iM3].R0Q0sub(jR0,omg) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(jR0,phi) )Tsub[ 2]=1;
               if( M3[iM3].R0Q0sub(jR0,psi) )Tsub[ 2]=1;
            }
            iO5=disulfide_links.N1N1N1N1O5(Tsub[ 2],Tsub[ 3],Tsub[ 4],
                                           Tsub[ 5]);
         }
         if( iO5==-1 )continue;
//
//
// include subset contracted disulfide bond
//
         M3[iM3].S1.push_back( tM3::tM3S1());
         for(int iN2=0;iN2<2;iN2++){
            M3[iM3].o_S1N2Z0.push_back(-1);
            M3[iM3].o_S1N2R0.push_back(-1);
            for(int j=  0;j< 16;j++){
               M3[iM3].o_S1N2Q0sq.push_back(-1);
               M3[iM3].o_S1N2X0sx.push_back(-1);
            }
            for(int j=  0;j<256;j++){
               M3[iM3].o_S1N2F0sf.push_back(-1);
               M3[iM3].o_S1N2G0sg.push_back(-1);
            }
            for(int j=  0;j< 64;j++){
               M3[iM3].o_S1N2B0sb.push_back(-1);
            }
         }
//
//
// mappings dependent on topology of forward groups
//
         for(int iN2=0;iN2<2;iN2++){
            int pZ0=str.S0N2Z0(iS0,iN2);
            int pR0=str.S0N2R0(iS0,iN2);
            M3[iM3].S1N2Z0(jS1,iN2)=pZ0;
            M3[iM3].S1N2R0(jS1,iN2)=pR0;
            int pL0=str.R0[pR0].L0;
            int mQ0=residue_mappings.L0[pL0].Q0a;
            int nQ0=(mQ0+residue_mappings.L0[pL0].cQ0);
            if( nQ0>mQ0 ){
               for(int iQ0=mQ0;iQ0<nQ0;iQ0++){
                  int iX0=residue_mappings.Q0[iQ0].X0;
                  std::string tor=residue_mappings.Q0[iQ0].tor;
                  int iJ5=disulfide_links.ij5torsion(tor);
                  if( iJ5==-1 ){
                     M3[iM3].S1N2Q0sq(jS1,iN2,iQ0-mQ0)=0;
                  }else{
                     M3[iM3].S1N2Q0sq(jS1,iN2,iQ0-mQ0)=
                       (jS1+1)*disulfide_links.O5N2J5sq(iO5,iN2,iJ5);
                  }
                  int iK5=disulfide_links.ik5torsion(tor);
                  if( iK5==-1 ){
                     M3[iM3].S1N2X0sx(jS1,iN2,iX0-mQ0)=0;
                  }else{
                     M3[iM3].S1N2X0sx(jS1,iN2,iX0-mQ0)=
                       (jS1+1)*disulfide_links.O5N2K5sx(iO5,iN2,iK5);
                  }
               }
            }
            int mF0=residue_mappings.L0[pL0].F0a;
            int mG0=residue_mappings.L0[pL0].G0a;
            int nG0=(mG0+residue_mappings.L0[pL0].cG0);
            if( nG0>mG0 ){
               for(int iG0=mG0;iG0<nG0;iG0++){
                  int iF0=residue_mappings.G0[iG0].F0;
                  std::string atm=residue_mappings.F0[iF0].atm;
                  int iL5=disulfide_links.il5atom(atm);
                  if( iL5==-1 ){
                     M3[iM3].S1N2F0sf(jS1,iN2,iF0-mF0)=( 16*(jS1+1) +4);
                     M3[iM3].S1N2G0sg(jS1,iN2,iG0-mG0)=( 16*(jS1+1) +0);
                  }else{
                     M3[iM3].S1N2F0sf(jS1,iN2,iF0-mF0)=
                       ( 16*(jS1+1) +disulfide_links.O5N2L5sf(iO5,iN2,iL5));
                     M3[iM3].S1N2G0sg(jS1,iN2,iG0-mG0)=
                       ( 16*(jS1+1) +disulfide_links.O5N2L5sg(iO5,iN2,iL5));
                  }
               }
            }
            int mB0=residue_mappings.L0[pL0].B0a;
            int nB0=(mB0+residue_mappings.L0[pL0].cB0);
            if( nB0>mB0 ){
               for(int iB0=mB0;iB0<nB0;iB0++){
                  int iF0=residue_mappings.B0[iB0].F0;
                  std::string atm=residue_mappings.F0[iF0].atm;
                  int iL5=disulfide_links.il5atom(atm);
                  if( iL5==-1 ){
                     M3[iM3].S1N2F0sf(jS1,iN2,iF0-mF0)=( 16*(jS1+1) +4);
                     M3[iM3].S1N2B0sb(jS1,iN2,iB0-mB0)=( 16*(jS1+1) +0);
                  }else{
                     M3[iM3].S1N2F0sf(jS1,iN2,iF0-mF0)=
                       ( 16*(jS1+1) +disulfide_links.O5N2L5sf(iO5,iN2,iL5));
                     M3[iM3].S1N2B0sb(jS1,iN2,iB0-mB0)=
                       ( 16*(jS1+1) +disulfide_links.O5N2L5sg(iO5,iN2,iL5));
                  }
               }
            }
         }

         jS1++;
      }
      M3[iM3].oS1=jS1;
   }
}
