#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include <cmath>

double Backbone_Defs::DEF_ZERO_C3(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      double psi3){

   double C1=( aut.mu1 +std::cos( physics_consts.RAD*psi3));
   double C2=( aut.mu2
              +aut.Zbet*std::cos( physics_consts.RAD*( psi3 -aut.bet)));
   double C3= aut.Zgam*std::cos( physics_consts.RAD*( psi3 -aut.gam));
   double S1= aut.SGN1*std::sqrt( (1.00) -C1*C1);
   double S2= aut.SGN2*std::sqrt( (1.00) -C2*C2);

   return ( S1 +S2 +C3 -aut.x5(2));
}
