#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include <cstdlib>
#include <cmath>

void Backbone_Defs::DEF_ZERO(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts){

   double x[5];
//
//
// loop over segments
//
   aut.nROO=0;
   for(int iSEG= 0;iSEG<aut.nSEG;iSEG++){
      x[0]= aut.SEG1[iSEG];
      x[4]= aut.SEG2[iSEG];
      x[2]=( x[0] +x[4])/(2.00);
      x[1]=( x[0] +x[2])/(2.00);
      x[3]=( x[2] +x[4])/(2.00);

      for(int i=0;i<4;i++){
         double x1= x[i  ];
         double x2= x[i+1];
         double F1= DEF_ZERO_C3(aut,physics_consts,x1);
         if( std::abs( F1)<(1.00e-4) ){
            aut.ROOps3[aut.nROO++]= x1;
            continue;
         }
         double F2= DEF_ZERO_C3(aut,physics_consts,x2);
         if( std::abs( F2)<(1.00e-4) ){
            aut.ROOps3[aut.nROO++]= x2;
            i++;
            continue;
         }

         double prod= F1*F2;
         if( prod<(0.00) ){
            bool CONVERGED=false;
            double psi3;
            for(int j= 0;j<20;j++){
               psi3=( x1 +x2)/(2.00);
               double F= DEF_ZERO_C3(aut,physics_consts,psi3);
               if( std::abs( F)<(1.00e-4) ){
                  aut.ROOps3[aut.nROO++]= psi3;
                  CONVERGED=true;
                  break;
               }
               prod= F1*F;
               if( prod<(0.00) ){
                  x2= psi3;
                  F2= F;
               }else{
                  x1= psi3;
                  F1= F;
               }
            }
            if( !CONVERGED ){
               aut.ROOps3[aut.nROO++]= psi3;
            }
         }
      }
   }
   return;
}
