#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <cmath>

class MEM_def_sort {
private:
   std::vector<double> o_R1phi;         //
   std::vector<double> o_R1psi;         //
   std::vector<double> o_R1omg;         //
   std::vector<std::string> o_R1cnf;    //region of (phi,psi) grid
   std::vector<int> o_R1jC4;            //undeformed conf
   std::vector<int> o_R1iC4;            //path through combined confs
public:
   MEM_def_sort(int o):
      o_R1phi(o),
      o_R1psi(o),
      o_R1omg(o),
      o_R1cnf(o),
      o_R1jC4(o),
      o_R1iC4(o)
   {
   }
   double& R1phi(int i){
      return o_R1phi.at( i);  }
   double& R1psi(int i){
      return o_R1psi.at( i);  }
   double& R1omg(int i){
      return o_R1omg.at( i);  }
   std::string& R1cnf(int i){
      return o_R1cnf.at( i);  }
   int& R1jC4(int i){
      return o_R1jC4.at( i);  }
   int& R1iC4(int i){
      return o_R1iC4.at( i);  }
};

void Backbone_Defs::DEF_SORT(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_ENERGY_PARAMS& energy_params,
      const DAT_RESIDUE_MAPPINGS& residue_mappings,
      const DAT_DEFORM_PARAMS& deform_params,
      const DAT_REGION_MAPS& region_maps,
      Output_Streams& out,
      const Structure& str,
      const Search_Subspace& sub,
      const Mechanical_System& mol,
      const Subset_Contracted_System::tM3& con,
      Conf_Dependent_System& dep,
      Energy_Surface4& ene,
      Local_Minimization4& loc,
      int iZ2,int iJ3){

   if( aut.nROO==0 )return;
   int jR1=Z2[iZ2].CYC;                 //start residue of segment
   int oR1=Z2[iZ2].nR1;                 //number of residues in segment
   MEM_def_sort vv(oR1);
   int bR1=(oR1-5)/2;                   //number of residues in terminal blocks

   vv.R1phi(  0  )= Z2[iZ2].R1[  0  ].phi;
   vv.R1psi(oR1-1)= Z2[iZ2].R1[oR1-1].psi;
   vv.R1omg(oR1-1)= Z2[iZ2].R1[oR1-1].omg;

   for(int iROO= 0;iROO<aut.nROO;iROO++){
      double psi3= aut.ROOps3[iROO];
      double Cps1=( aut.mu1 +std::cos( physics_consts.RAD*psi3));
      double psi1=( aut.SGN1*(std::acos( Cps1)/physics_consts.RAD)
                   +aut.the1[aut.iSOL]);
      double Cps2=( aut.mu2
                   +aut.Zbet*std::cos( physics_consts.RAD*( psi3 -aut.bet)));
      double psi2= aut.SGN2*(std::acos( Cps2)/physics_consts.RAD);

      for(int aR1= 0;aR1<bR1;aR1++){
         if( ( 1+aR1)==Z2[iZ2].CIS ){
            vv.R1psi(   aR1)= ( 150.);
            vv.R1omg(   aR1)= (   0.);
            vv.R1phi( 1+aR1)= ( -75.);
         }else{
            vv.R1psi(   aR1)= aut.V1R1psi(aut.iV1,aR1);
            vv.R1omg(   aR1)= ( 180.);
            vv.R1phi( 1+aR1)= aut.V1R1phi(aut.iV1,aR1);
         }
      }

      if      ( Z2[iZ2].CIS==(bR1+1) ){
         vv.R1psi(bR1  )= ( 150.);
         vv.R1omg(bR1  )= (   0.);
         vv.R1phi(bR1+1)= ( -75.);
         vv.R1psi(bR1+1)= psi1;
         vv.R1omg(bR1+1)= ( 180.);
         vv.R1phi(bR1+2)=( aut.the1[aut.iSOL] -psi1 -(180.));
         vv.R1psi(bR1+2)= psi2;
         vv.R1omg(bR1+2)= ( 180.);
         vv.R1phi(bR1+3)=( aut.the2[aut.iSOL] -psi2 -(180.));
         vv.R1psi(bR1+3)= psi3;
         vv.R1omg(bR1+3)= ( 180.);
         vv.R1phi(bR1+4)=( aut.the3[aut.iSOL] -psi3 -(180.));

      }else if( Z2[iZ2].CIS==(bR1+2) ){
         vv.R1psi(bR1  )=( psi1 +( 106.168 ));
         vv.R1omg(bR1  )= ( 180.);
         vv.R1phi(bR1+1)=( aut.the1[aut.iSOL] -psi1 -( 106.168 ) -(180.));
         vv.R1psi(bR1+1)= ( 150.);
         vv.R1omg(bR1+1)= (   0.);
         vv.R1phi(bR1+2)= ( -75.);
         vv.R1psi(bR1+2)=( psi2 -( -36.930 ));
         vv.R1omg(bR1+2)= ( 180.);
         vv.R1phi(bR1+3)=( aut.the2[aut.iSOL] -psi2 +( -36.930 ) -(180.));
         vv.R1psi(bR1+3)= psi3;
         vv.R1omg(bR1+3)= ( 180.);
         vv.R1phi(bR1+4)=( aut.the3[aut.iSOL] -psi3 -(180.));

      }else if( Z2[iZ2].CIS==(bR1+3) ){
         vv.R1psi(bR1  )= psi1;
         vv.R1omg(bR1  )= ( 180.);
         vv.R1phi(bR1+1)=( aut.the1[aut.iSOL] -psi1 -(180.));
         vv.R1psi(bR1+1)= psi2;
         vv.R1omg(bR1+1)= ( 180.);
         vv.R1phi(bR1+2)=( aut.the2[aut.iSOL] -psi2 -(180.));
         vv.R1psi(bR1+2)= ( 150.);
         vv.R1omg(bR1+2)= (   0.);
         vv.R1phi(bR1+3)= ( -75.);
         vv.R1psi(bR1+3)=( psi3 -( -36.930 ));
         vv.R1omg(bR1+3)= ( 180.);
         vv.R1phi(bR1+4)=( aut.the3[aut.iSOL] -psi3 +( -36.930 ) -(180.));

      }else if( Z2[iZ2].CIS==(bR1+4) ){
         vv.R1psi(bR1  )= psi1;
         vv.R1omg(bR1  )= ( 180.);
         vv.R1phi(bR1+1)=( aut.the1[aut.iSOL] -psi1 -(180.));
         vv.R1psi(bR1+1)= psi2;
         vv.R1omg(bR1+1)= ( 180.);
         vv.R1phi(bR1+2)=( aut.the2[aut.iSOL] -psi2 -(180.));
         vv.R1psi(bR1+2)= psi3;
         vv.R1omg(bR1+2)= ( 180.);
         vv.R1phi(bR1+3)=( aut.the3[aut.iSOL] -psi3 -(180.));
         vv.R1psi(bR1+3)= ( 150.);
         vv.R1omg(bR1+3)= (   0.);
         vv.R1phi(bR1+4)= ( -75.);

      }else{
         vv.R1psi(bR1  )= psi1;
         vv.R1omg(bR1  )= ( 180.);
         vv.R1phi(bR1+1)=( aut.the1[aut.iSOL] -psi1 -(180.));
         vv.R1psi(bR1+1)= psi2;
         vv.R1omg(bR1+1)= ( 180.);
         vv.R1phi(bR1+2)=( aut.the2[aut.iSOL] -psi2 -(180.));
         vv.R1psi(bR1+2)= psi3;
         vv.R1omg(bR1+2)= ( 180.);
         vv.R1phi(bR1+3)=( aut.the3[aut.iSOL] -psi3 -(180.));
         vv.R1psi(bR1+3)= aut.DISps4[aut.jDIS];
         vv.R1omg(bR1+3)= ( 180.);
         vv.R1phi(bR1+4)=( aut.DISthe4[aut.iDIS] -aut.DISps4[aut.jDIS] -(180.));

      }

      for(int aR1= 0;aR1<bR1;aR1++){
         if( ((oR1-1)-aR1)==Z2[iZ2].CIS ){
            vv.R1psi((oR1-1)-1-aR1)= ( 150.);
            vv.R1omg((oR1-1)-1-aR1)= (   0.);
            vv.R1phi((oR1-1)  -aR1)= ( -75.);
         }else{
            vv.R1psi((oR1-1)-1-aR1)= aut.V2R1psi(aut.iV2,aR1);
            vv.R1omg((oR1-1)-1-aR1)= ( 180.);
            vv.R1phi((oR1-1)  -aR1)= aut.V2R1phi(aut.iV2,aR1);
         }
      }

      for(int iR1= 0;iR1<oR1;iR1++){
         if      ( vv.R1phi(iR1)>=( 180.) ){
            vv.R1phi(iR1)-=(360.);
         }else if( vv.R1phi(iR1)< (-540.) ){
            vv.R1phi(iR1)+=(720.);
         }else if( vv.R1phi(iR1)< (-180.) ){
            vv.R1phi(iR1)+=(360.);
         }
         if      ( vv.R1psi(iR1)>=( 180.) ){
            vv.R1psi(iR1)-=(360.);
         }else if( vv.R1psi(iR1)< (-180.) ){
            vv.R1psi(iR1)+=(360.);
         }
      }

      bool REJECT=false;
      for(int iR1= 0;iR1<oR1&&(!REJECT);iR1++){
         int iL0=sub.R1[jR1+iR1].L0;
         int thr=residue_mappings.L0[iL0].thr;
         if( (iR1== 0)||(aut.PASS>0) )thr++;
         int iH4=1 +int( vv.R1phi(iR1) +(180.00))/10;
         int jH4=1 +int( vv.R1psi(iR1) +(180.00))/10;
         if( region_maps.H4H4scr(iH4,jH4)>thr ){
            REJECT=true;
            continue;
         }
         if( iR1> 0 ){
            std::string aa=sub.R1[jR1+iR1].aa;
            if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
            bool PROLINE=((aa=="PRO ")||(aa=="HPR "));
            if( PROLINE ){
               if( (vv.R1phi(iR1)<(-135.))||(vv.R1phi(iR1)>( -15.)) ){
                  REJECT=true;
                  continue;
               }
               double tphi;
               if      ( aa=="PRO " ){
                  tphi= (-74.39 );
               }else if( aa=="HPR " ){
                  tphi= (-74.39 );
               }
               double dphi=( vv.R1phi(iR1) -tphi);
               vv.R1phi(iR1  )= tphi;
               vv.R1psi(iR1-1)+=dphi;
               if      ( vv.R1psi(iR1-1)>=( 180.) ){
                  vv.R1psi(iR1-1)-=(360.);
               }else if( vv.R1psi(iR1-1)< (-180.) ){
                  vv.R1psi(iR1-1)+=(360.);
               }
            }
         }
      }
      if( REJECT )continue;

      REJECT=false;
      int nSTAR=0;
      int nBORD=0;
      for(int iR1= 0;iR1<oR1&&(!REJECT);iR1++){
         vv.R1cnf(iR1)="  ";
         std::string aa=sub.R1[jR1+iR1].aa;
         if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ") )continue;
         if( (aa[0]=='e')||(aa[0]=='z')||
             (aa[3]=='e')||(aa[3]=='z') )continue;
         double phi= vv.R1phi(iR1);
         double psi= vv.R1psi(iR1);
         if( phi>(0.00) ){
            phi=-phi;
            psi=-psi;
            vv.R1cnf(iR1)[1]='*';
            if( aa!="GLY " )nSTAR++;
            if( nSTAR>(2+(aut.PASS/8)) )REJECT=true;
         }
         int iH4=1 +int( phi +(180.00))/10;
         int jH4=1 +int( psi +(180.00))/10;
         int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                 region_maps.H4H4ala(iH4,jH4);
         vv.R1cnf(iR1)[0]=region_maps.I0alp(iI0);
         if( vv.R1cnf(iR1)[0]=='X' )nBORD++;
         if( nBORD>(4+(aut.PASS/8)) )REJECT=true;
      }
      if( REJECT )continue;

      double Fg= (0.00);
      for(int iR1= 0;iR1<oR1;iR1++){
         std::string aa=sub.R1[jR1+iR1].aa;
         std::string cnf=vv.R1cnf(iR1  );
         if      ( (aa=="SER ")&&(cnf=="A*") ){
            Fg+=(2.00)*energy_params.fac_pp;
         }else if( (aa=="CYS ")&&(cnf=="A*") ){
            Fg+=(3.60)*energy_params.fac_pp;
         }
      }

      for(int aR1= 1;aR1<oR1;aR1++){
         vv.R1jC4(aR1)=Z2[iZ2].R1[aR1].C4;
         double RRmin= (1.00e+6);
         double psi= vv.R1psi(aR1-1);
         double phi= vv.R1phi(aR1  );
         int iL0=sub.R1[jR1+aR1].L0;
         int iG4=residue_mappings.L0[iL0].G4;
         int iC4min=deform_params.G4[iG4].mC4;
         int iC4max=deform_params.G4[iG4].nC4;
         for(int iC4=iC4min;iC4<=iC4max;iC4++){
            double D1=( psi -deform_params.C4[iC4].psi);
            if      ( D1>( 180.) ){
               D1-=(360.);
            }else if( D1<(-180.) ){
               D1+=(360.);
            }
            double D2=( phi -deform_params.C4[iC4].phi);
            if      ( D2>( 180.) ){
               D2-=(360.);
            }else if( D2<(-180.) ){
               D2+=(360.);
            }
            double RR=( D1*D1 +D2*D2);
            if( RR<RRmin ){
               RRmin= RR;
               vv.R1iC4(aR1)=iC4;
            }
         }
      }

      double RRc= ( 2*(oR1-1))*( (oR1-1) +2)*( (oR1-1) +2);
      if( Z2[iZ2].CORE )RRc/=(4.);
      double zZ= deform_params.C4C4p( 0,vv.R1iC4( 1));
      double RRa= deform_params.C4C4d(vv.R1iC4( 1),vv.R1jC4( 1));
      for(int aR1= 2;aR1<oR1;aR1++){
         zZ*=deform_params.C4C4p(vv.R1iC4(aR1-1),vv.R1iC4(aR1  ));
         RRa+=deform_params.C4C4d(vv.R1iC4(aR1),vv.R1jC4(aR1));
      }
      zZ*=deform_params.C4C4p(vv.R1iC4(oR1-1), 0);
      if( zZ<(aut.z/(1+(aut.PASS/4))) )continue;
      if( !Z2[iZ2].CORE ){
         RRa= RRc*std::exp( (.40)*std::log( (1.00e-8) +(RRa/RRc)));
      }else{
         RRa= RRc*std::exp( (.80)*std::log( (1.00e-8) +(RRa/RRc)));
      }

      REJECT=false;
      for(int iD1= 0;iD1<Z2[iZ2].nD1&&(!REJECT);iD1++){
         double RRb=( Z2[iZ2].D1[iD1].d<RRa )? (.50)*Z2[iZ2].D1[iD1].d:
                                               (.50)*RRa;
         bool EQUIVALENT=true;
         double RR= (0.);
         for(int aR1= 1;aR1<oR1&&(EQUIVALENT);aR1++){
            RR+=deform_params.C4C4d(vv.R1iC4(aR1),Z2[iZ2].D1[iD1].R1[aR1].C4);
            if( RR>RRb )EQUIVALENT=false;
         }
         REJECT=EQUIVALENT;
      }
      if( REJECT )continue;

      int jD1=Z2[iZ2].nD1;
      if( Z2[iZ2].nD1<aut.oD1 ){
         Z2[iZ2].D1.push_back( tZ2::tZ2D1(oR1));
      }else{
         jD1=(aut.oD1-1);
      }
      for(int iR1= 0;iR1<oR1;iR1++){
         Z2[iZ2].D1[jD1].R1[iR1].phi= vv.R1phi(iR1);
         Z2[iZ2].D1[jD1].R1[iR1].psi= vv.R1psi(iR1);
         Z2[iZ2].D1[jD1].R1[iR1].omg= vv.R1omg(iR1);
         if( iR1> 0 ){
            Z2[iZ2].D1[jD1].R1[iR1].C4=vv.R1iC4(iR1);
         }
         Z2[iZ2].D1[jD1].R1[iR1].cnfa= vv.R1cnf(iR1);
      }

      DEF_SEGPT(physics_consts,residue_mappings,
                out,sub,mol,con,dep,ene,loc,
                iZ2,iJ3,jD1);
      double Rend= DEF_DEV18(physics_consts,residue_mappings,
                             out,str,sub,
                             iZ2,jD1);

//    if( (loc.M4[iM4].Ftot>(8.00e+3))||(Rend>(1.20)) ){
//       if( Z2[iZ2].nD1<aut.oD1 ){
//          Z2[iZ2].D1.pop_back();
//       }
//       continue;
//    }
      Z2[iZ2].D1[jD1].p= zZ;
      Z2[iZ2].D1[jD1].d= RRa;
      Z2[iZ2].D1[jD1].star=nSTAR;
      Z2[iZ2].D1[jD1].bord=nBORD;
      Z2[iZ2].D1[jD1].r= Rend;
      Z2[iZ2].D1[jD1].fg= Fg;
      if( Z2[iZ2].nD1<aut.oD1 ){
         Z2[iZ2].nD1++;
      }

      int mD1= 1;
      if( !PATCH ){
      if( (Z2[iZ2].J3[iJ3].shf1==0)&&(Z2[iZ2].J3[iJ3].shf2==0) ){
         mD1=2;
      }
      }
      for(int iD1=(Z2[iZ2].nD1-1);iD1>=mD1;iD1--){
         if( Z2[iZ2].D1[iD1  ].p<=Z2[iZ2].D1[iD1-1].p )continue;
         for(int iR1= 0;iR1<oR1;iR1++){
            Z2[iZ2].D1[iD1  ].R1[iR1].swap( Z2[iZ2].D1[iD1-1].R1[iR1]);
         }
         double z= Z2[iZ2].D1[iD1-1].p;
         Z2[iZ2].D1[iD1-1].p= Z2[iZ2].D1[iD1  ].p;
         Z2[iZ2].D1[iD1  ].p= z;
         z= Z2[iZ2].D1[iD1-1].d;
         Z2[iZ2].D1[iD1-1].d= Z2[iZ2].D1[iD1  ].d;
         Z2[iZ2].D1[iD1  ].d= z;
         int i=Z2[iZ2].D1[iD1-1].star;
         Z2[iZ2].D1[iD1-1].star=Z2[iZ2].D1[iD1  ].star;
         Z2[iZ2].D1[iD1  ].star=i;
         i=Z2[iZ2].D1[iD1-1].bord;
         Z2[iZ2].D1[iD1-1].bord=Z2[iZ2].D1[iD1  ].bord;
         Z2[iZ2].D1[iD1  ].bord=i;
         z= Z2[iZ2].D1[iD1-1].r;
         Z2[iZ2].D1[iD1-1].r= Z2[iZ2].D1[iD1  ].r;
         Z2[iZ2].D1[iD1  ].r= z;
         z= Z2[iZ2].D1[iD1-1].fg;
         Z2[iZ2].D1[iD1-1].fg= Z2[iZ2].D1[iD1  ].fg;
         Z2[iZ2].D1[iD1  ].fg= z;
      }
      if( (Z2[iZ2].nD1==aut.oD1)&&
          (Z2[iZ2].D1[aut.oD1-1].p>aut.z) )aut.z= Z2[iZ2].D1[aut.oD1-1].p;

   }
   return;
}
