#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <cmath>

void Backbone_Defs::DEF_SETX4(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
//
//
// set x4
//
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   double C= deform_params.Uphi(0,0);
   double S= deform_params.Uphi(1,0);
   Rotation_Matrix Rthe[ 3];

   if      ( Z2[iZ2].CIS==(oR1+1) ){
      double the= physics_consts.RAD*aut.the1[aut.iSOL];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*aut.the2[aut.iSOL];
      aut.Cthe2= std::cos( the);
      aut.Sthe2= std::sin( the);
      Rthe[ 1](0,0)= (1.00);
      Rthe[ 1](1,0)= (0.00);
      Rthe[ 1](2,0)= (0.00);
      Rthe[ 1](0,1)= (0.00);
      Rthe[ 1](1,1)= aut.Cthe2;
      Rthe[ 1](2,1)= aut.Sthe2;
      Rthe[ 1](0,2)= (0.00);
      Rthe[ 1](1,2)=-aut.Sthe2;
      Rthe[ 1](2,2)= aut.Cthe2;

      Coordinates x=( aut.x3 -deform_params.bcis);
      aut.x5= transpose(deform_params.Rcis)*x;
      x= transpose(deform_params.Uphi)*aut.x5;
      aut.x5= transpose(Rthe[ 0])*x;
      x=( aut.x5 -deform_params.bphi);
      aut.x5= transpose(deform_params.Uphi)*x;
      aut.x5-=Rthe[ 1]*deform_params.bphi;
      aut.x5(0)-=deform_params.bpsi(0)*( C +(1.00) +C);
      aut.x5(1)-=deform_params.bpsi(0)*(-S +S*aut.Cthe2);
      aut.x5(2)-=deform_params.bpsi(0)*( S*aut.Sthe2);
      aut.x5/=deform_params.bpsi(1);

   }else if( Z2[iZ2].CIS==(oR1+2) ){
      double the= physics_consts.RAD*aut.the1[aut.iSOL];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*aut.the2[aut.iSOL];
      CT= std::cos( the);
      ST= std::sin( the);
      Rthe[ 1](0,0)= (1.00);
      Rthe[ 1](1,0)= (0.00);
      Rthe[ 1](2,0)= (0.00);
      Rthe[ 1](0,1)= (0.00);
      Rthe[ 1](1,1)= CT;
      Rthe[ 1](2,1)= ST;
      Rthe[ 1](0,2)= (0.00);
      Rthe[ 1](1,2)=-ST;
      Rthe[ 1](2,2)= CT;

      Rotation_Matrix zB1= Rthe[ 0]*deform_params.Uphi;
      Rotation_Matrix zB2= zB1*deform_params.Rcis;
      Rotation_Matrix zB3= zB2*deform_params.Uphi;
      Rotation_Matrix zB4= zB3*Rthe[ 1];

      aut.x5=( aut.x3 -Rthe[ 0]*deform_params.bphi);
      aut.x5-=zB1*deform_params.bcis;
      aut.x5-=zB4*deform_params.bphi;

      the= physics_consts.RAD*( aut.the1[aut.iSOL] +( 106.168 ));
      CT= std::cos( the);
      ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*( aut.the2[aut.iSOL] +( -36.930 ));
      aut.Cthe2= std::cos( the);
      aut.Sthe2= std::sin( the);

      Coordinates x= transpose(Rthe[ 0])*aut.x5;
      aut.x5= transpose(deform_params.Ucis)*x;
      aut.x5(0)-=deform_params.bpsi(0)*( aut.C_ +(1.00) +C);
      aut.x5(1)-=deform_params.bpsi(0)*(-aut.S_ +S*aut.Cthe2);
      aut.x5(2)-=deform_params.bpsi(0)*( S*aut.Sthe2);
      aut.x5/=deform_params.bpsi(1);

   }else if( Z2[iZ2].CIS==(oR1+3) ){
      double the= physics_consts.RAD*aut.the1[aut.iSOL];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*aut.the2[aut.iSOL];
      CT= std::cos( the);
      ST= std::sin( the);
      Rthe[ 1](0,0)= (1.00);
      Rthe[ 1](1,0)= (0.00);
      Rthe[ 1](2,0)= (0.00);
      Rthe[ 1](0,1)= (0.00);
      Rthe[ 1](1,1)= CT;
      Rthe[ 1](2,1)= ST;
      Rthe[ 1](0,2)= (0.00);
      Rthe[ 1](1,2)=-ST;
      Rthe[ 1](2,2)= CT;

      Rotation_Matrix zB1= Rthe[ 1]*deform_params.Uphi;
      Coordinates x= transpose(Rthe[ 0])*aut.x3;
      x-=deform_params.bphi;
      aut.x5= transpose(deform_params.Uphi)*x;
      aut.x5-=Rthe[ 1]*deform_params.bphi;
      aut.x5-=zB1*deform_params.bcis;

      the= physics_consts.RAD*( aut.the2[aut.iSOL] +( 106.168 ));
      aut.Cthe2= std::cos( the);
      aut.Sthe2= std::sin( the);

      aut.x5(0)-=deform_params.bpsi(0)*( C +(1.00) +aut.C_);
      aut.x5(1)-=deform_params.bpsi(0)*(-S +aut.S_*aut.Cthe2);
      aut.x5(2)-=deform_params.bpsi(0)*( aut.S_*aut.Sthe2);
      aut.x5/=deform_params.bpsi(1);

   }else if( Z2[iZ2].CIS==(oR1+4) ){
      double the= physics_consts.RAD*aut.the1[aut.iSOL];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*aut.the2[aut.iSOL];
      aut.Cthe2= std::cos( the);
      aut.Sthe2= std::sin( the);
      Rthe[ 1](0,0)= (1.00);
      Rthe[ 1](1,0)= (0.00);
      Rthe[ 1](2,0)= (0.00);
      Rthe[ 1](0,1)= (0.00);
      Rthe[ 1](1,1)= aut.Cthe2;
      Rthe[ 1](2,1)= aut.Sthe2;
      Rthe[ 1](0,2)= (0.00);
      Rthe[ 1](1,2)=-aut.Sthe2;
      Rthe[ 1](2,2)= aut.Cthe2;

      the= physics_consts.RAD*aut.the3[aut.iSOL];
      CT= std::cos( the);
      ST= std::sin( the);
      Rthe[ 2](0,0)= (1.00);
      Rthe[ 2](1,0)= (0.00);
      Rthe[ 2](2,0)= (0.00);
      Rthe[ 2](0,1)= (0.00);
      Rthe[ 2](1,1)= CT;
      Rthe[ 2](2,1)= ST;
      Rthe[ 2](0,2)= (0.00);
      Rthe[ 2](1,2)=-ST;
      Rthe[ 2](2,2)= CT;

      Rotation_Matrix zB1= Rthe[ 1]*deform_params.Uphi;
      Rotation_Matrix zB2= zB1*Rthe[ 2];
      Rotation_Matrix zB3= zB2*deform_params.Uphi;

      Coordinates x= transpose(Rthe[ 0])*aut.x3;
      x-=deform_params.bphi;
      aut.x5= transpose(deform_params.Uphi)*x;
      aut.x5-=Rthe[ 1]*deform_params.bphi;
      aut.x5-=zB2*deform_params.bphi;
      x=( deform_params.bcis -deform_params.Rcis*deform_params.bphi);
      aut.x5-=zB3*x;
      aut.x5(0)-=deform_params.bpsi(0)*( C +(1.00) +C);
      aut.x5(1)-=deform_params.bpsi(0)*(-S +S*aut.Cthe2);
      aut.x5(2)-=deform_params.bpsi(0)*( S*aut.Sthe2);
      aut.x5/=deform_params.bpsi(1);

   }else{
      double the= physics_consts.RAD*aut.the1[aut.iSOL];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rthe[ 0](0,0)= (1.00);
      Rthe[ 0](1,0)= (0.00);
      Rthe[ 0](2,0)= (0.00);
      Rthe[ 0](0,1)= (0.00);
      Rthe[ 0](1,1)= CT;
      Rthe[ 0](2,1)= ST;
      Rthe[ 0](0,2)= (0.00);
      Rthe[ 0](1,2)=-ST;
      Rthe[ 0](2,2)= CT;

      the= physics_consts.RAD*aut.the2[aut.iSOL];
      aut.Cthe2= std::cos( the);
      aut.Sthe2= std::sin( the);
      Rthe[ 1](0,0)= (1.00);
      Rthe[ 1](1,0)= (0.00);
      Rthe[ 1](2,0)= (0.00);
      Rthe[ 1](0,1)= (0.00);
      Rthe[ 1](1,1)= aut.Cthe2;
      Rthe[ 1](2,1)= aut.Sthe2;
      Rthe[ 1](0,2)= (0.00);
      Rthe[ 1](1,2)=-aut.Sthe2;
      Rthe[ 1](2,2)= aut.Cthe2;

      the= physics_consts.RAD*aut.the3[aut.iSOL];
      CT= std::cos( the);
      ST= std::sin( the);
      Rthe[ 2](0,0)= (1.00);
      Rthe[ 2](1,0)= (0.00);
      Rthe[ 2](2,0)= (0.00);
      Rthe[ 2](0,1)= (0.00);
      Rthe[ 2](1,1)= CT;
      Rthe[ 2](2,1)= ST;
      Rthe[ 2](0,2)= (0.00);
      Rthe[ 2](1,2)=-ST;
      Rthe[ 2](2,2)= CT;

      Rotation_Matrix zB1= Rthe[ 1]*deform_params.Uphi;
      Rotation_Matrix zB2= zB1*Rthe[ 2];
      aut.B= zB2*deform_params.Uphi;

      Coordinates x= transpose(Rthe[ 0])*aut.x3;
      x-=deform_params.bphi;
      aut.x4= transpose(deform_params.Uphi)*x;
      aut.x4-=Rthe[ 1]*deform_params.bphi;
      aut.x4-=zB2*deform_params.bphi;

      aut.x4(0)-=deform_params.bpsi(0)*( C +(1.00) +C +aut.B(0,0));
      aut.x4(1)-=deform_params.bpsi(0)*(-S +S*aut.Cthe2 +aut.B(1,0));
      aut.x4(2)-=deform_params.bpsi(0)*( S*aut.Sthe2 +aut.B(2,0));
      aut.x4/=deform_params.bpsi(1);

   }
   return;
}
