#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>
#include <cmath>

class MEM_def_setx3 {
private:
   std::vector<Rotation_Matrix> o_Rthe; //
   std::vector<Rotation_Matrix> o_Rpsi; //
public:
   MEM_def_setx3(int o):
      o_Rthe(o),
      o_Rpsi(o)
   {
   }
   Rotation_Matrix& Rthe(int i){
      return o_Rthe.at( i);  }
   Rotation_Matrix& Rpsi(int i){
      return o_Rpsi.at( i);  }
};

void Backbone_Defs::DEF_SETX3(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   MEM_def_setx3 vv(oR1);
//
//
// calc  T3, x3
//
   for(int aR1= 0;aR1<oR1;aR1++){
      double thet= physics_consts.RAD*( aut.V2R1psi(aut.iV2,aR1)
                                       +aut.V2R1phi(aut.iV2,aR1) +(180.00));
      double CT= std::cos( thet);
      double ST= std::sin( thet);
      vv.Rthe(aR1)(0,0)= (1.00);
      vv.Rthe(aR1)(1,0)= (0.00);
      vv.Rthe(aR1)(2,0)= (0.00);
      vv.Rthe(aR1)(0,1)= (0.00);
      vv.Rthe(aR1)(1,1)= CT;
      vv.Rthe(aR1)(2,1)= ST;
      vv.Rthe(aR1)(0,2)= (0.00);
      vv.Rthe(aR1)(1,2)=-ST;
      vv.Rthe(aR1)(2,2)= CT;
      thet= physics_consts.RAD*aut.V2R1psi(aut.iV2,aR1);
      CT= std::cos( thet);
      ST= std::sin( thet);
      vv.Rpsi(aR1)(0,0)= (1.00);
      vv.Rpsi(aR1)(1,0)= (0.00);
      vv.Rpsi(aR1)(2,0)= (0.00);
      vv.Rpsi(aR1)(0,1)= (0.00);
      vv.Rpsi(aR1)(1,1)= CT;
      vv.Rpsi(aR1)(2,1)= ST;
      vv.Rpsi(aR1)(0,2)= (0.00);
      vv.Rpsi(aR1)(1,2)=-ST;
      vv.Rpsi(aR1)(2,2)= CT;
      if( (Z2[iZ2].nR1-1-aR1)==Z2[iZ2].CIS ){
         vv.Rthe(aR1)= deform_params.Rcis;
      }
   }

   aut.T3= aut.T2;
   aut.x3= aut.x2;
   for(int aR1= 0;aR1<oR1;aR1++){

      Rotation_Matrix B= aut.T3*transpose(vv.Rthe(aR1));
      aut.T3= B*transpose(deform_params.Uphi);

      Coordinates x;
      if( (Z2[iZ2].nR1-1-aR1)==Z2[iZ2].CIS ){
         x= deform_params.bcis
           -deform_params.Rcis*deform_params.bphi;
      }else{
         x= vv.Rpsi(aR1)*deform_params.bpsi;
      }

      aut.x3-=aut.T3*deform_params.bphi;
      aut.x3-=B*x;

   }
   return;
}
