#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <cmath>

class MEM_def_setx1 {
private:
   std::vector<Rotation_Matrix> o_Rphi; //
   std::vector<Rotation_Matrix> o_Rpsi; //
   std::vector<Rotation_Matrix> o_Romg; //
public:
   MEM_def_setx1(int o):
      o_Rphi(o),
      o_Rpsi(o),
      o_Romg(o)
   {
   }
   Rotation_Matrix& Rphi(int i){
      return o_Rphi.at( i);  }
   Rotation_Matrix& Rpsi(int i){
      return o_Rpsi.at( i);  }
   Rotation_Matrix& Romg(int i){
      return o_Romg.at( i);  }
};

void Backbone_Defs::DEF_SETX1(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      const Thread_Options& opt,
      const Structure& str,
      const Search_Subspace& sub,
      int iZ2,int iJ3){
//
//
// calc  T1, x1
//
   int jR1=Z2[iZ2].CYC;         //start residue of segment
   if( (!PATCH)&&(opt.MODE=="bb ") ){
      int oR1=(Z2[iZ2].nR1+Z2[iZ2].J3[iJ3].shf2-Z2[iZ2].J3[iJ3].shf1);
      MEM_def_setx1 vv(oR1);
      for(int aR1= 0;aR1<oR1;aR1++){
         int iR1=(jR1+Z2[iZ2].J3[iJ3].shf1+aR1);
         int mT5=sub.R1[iR1].T5a;
         double phi= (physics_consts.RAD)*D0T5chi( 0,mT5  );
         double C= std::cos( phi);
         double S= std::sin( phi);
         vv.Rphi(aR1)(0,0)= (1.00);
         vv.Rphi(aR1)(1,0)= (0.00);
         vv.Rphi(aR1)(2,0)= (0.00);
         vv.Rphi(aR1)(0,1)= (0.00);
         vv.Rphi(aR1)(1,1)= C;
         vv.Rphi(aR1)(2,1)= S;
         vv.Rphi(aR1)(0,2)= (0.00);
         vv.Rphi(aR1)(1,2)=-S;
         vv.Rphi(aR1)(2,2)= C;
         double psi= (physics_consts.RAD)*D0T5chi( 0,mT5+1);
         C= std::cos( psi);
         S= std::sin( psi);
         vv.Rpsi(aR1)(0,0)= (1.00);
         vv.Rpsi(aR1)(1,0)= (0.00);
         vv.Rpsi(aR1)(2,0)= (0.00);
         vv.Rpsi(aR1)(0,1)= (0.00);
         vv.Rpsi(aR1)(1,1)= C;
         vv.Rpsi(aR1)(2,1)= S;
         vv.Rpsi(aR1)(0,2)= (0.00);
         vv.Rpsi(aR1)(1,2)=-S;
         vv.Rpsi(aR1)(2,2)= C;
         double omg= (physics_consts.RAD)*D0T5chi( 0,mT5+2);
         C= std::cos( omg);
         S= std::sin( omg);
         vv.Romg(aR1)(0,0)= (1.00);
         vv.Romg(aR1)(1,0)= (0.00);
         vv.Romg(aR1)(2,0)= (0.00);
         vv.Romg(aR1)(0,1)= (0.00);
         vv.Romg(aR1)(1,1)= C;
         vv.Romg(aR1)(2,1)= S;
         vv.Romg(aR1)(0,2)= (0.00);
         vv.Romg(aR1)(1,2)=-S;
         vv.Romg(aR1)(2,2)= C;
      }

      Rotation_Matrix Bphi,Bpsi,Bomg;
//
// T1=(Rpsi*Upsi*Romg*Uomg*Rphi)
//
      Bpsi= vv.Rpsi( 0)*deform_params.Upsi;
      aut.T1= Bpsi*vv.Romg( 0);
      Bomg= aut.T1*deform_params.Uomg;
      aut.T1= Bomg*vv.Rphi( 1);
      for(int i=0;i<3;i++){
         aut.x1(i)= Bpsi(i,0)*(1.335)
                   +Bomg(i,0)*(1.449);
      }

      for(int aR1= 2;aR1<oR1;aR1++){
//
// T1*=Uphi*(Rpsi*Upsi*Romg*Uomg*Rphi)
//
         Bphi= aut.T1*deform_params.Uphi;
         aut.T1= Bphi*vv.Rpsi(aR1-1);
         Bpsi= aut.T1*deform_params.Upsi;
         aut.T1= Bpsi*vv.Romg(aR1-1);
         Bomg= aut.T1*deform_params.Uomg;
         aut.T1= Bomg*vv.Rphi(aR1  );
         for(int i=0;i<3;i++){
            aut.x1(i)+=( Bphi(i,0)*(1.522)
                        +Bpsi(i,0)*(1.335)
                        +Bomg(i,0)*(1.449));
         }
      }

   }else{
      Rotation_Matrix ROT1,ROT2;
      Coordinates TRANS1,TRANS2;

      int aR0=sub.R1[jR1].R0;
      int jP1=-1;
      int kP1=-1;
      int lP1=-1;
      int mP1=str.R0[aR0].P1a;
      int nP1=(mP1-1+str.R0[aR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if( atm==" N  " )jP1=iP1;
         if( atm==" CA " )kP1=iP1;
         if( atm==" C  " )lP1=iP1;
      }
      Coordinates zU=( str.P1[lP1].x -str.P1[kP1].x).normalize();
      Coordinates zV=( str.P1[jP1].x -str.P1[kP1].x);
      double zVU= dot(zV,zU);
      zV-=zVU*zU;
      zV.normalize();
      Coordinates zW= cross(zU,zV);
      ROT1(0,0)= zU(0);
      ROT1(1,0)= zU(1);
      ROT1(2,0)= zU(2);
      ROT1(0,1)= zV(0);
      ROT1(1,1)= zV(1);
      ROT1(2,1)= zV(2);
      ROT1(0,2)= zW(0);
      ROT1(1,2)= zW(1);
      ROT1(2,2)= zW(2);
      TRANS1= str.P1[lP1].x;

      int bR0=sub.R1[jR1-1+Z2[iZ2].nR1].R0;
      jP1=-1;
      kP1=-1;
      lP1=-1;
      mP1=str.R0[bR0].P1a;
      nP1=(mP1-1+str.R0[bR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if( atm==" N  " )jP1=iP1;
         if( atm==" CA " )kP1=iP1;
         if( atm==" C  " )lP1=iP1;
      }
      zU=( str.P1[kP1].x -str.P1[jP1].x).normalize();
      zV=( str.P1[lP1].x -str.P1[kP1].x);
      zVU= dot(zV,zU);
      zV-=zVU*zU;
      zV.normalize();
      zW= cross(zU,zV);
      ROT2(0,0)= zU(0);
      ROT2(1,0)= zU(1);
      ROT2(2,0)= zU(2);
      ROT2(0,1)= zV(0);
      ROT2(1,1)= zV(1);
      ROT2(2,1)= zV(2);
      ROT2(0,2)= zW(0);
      ROT2(1,2)= zW(1);
      ROT2(2,2)= zW(2);
      TRANS2= str.P1[kP1].x;

      aut.T1= transpose(ROT1)*ROT2;
      aut.x1= transpose(ROT1)*( TRANS2 -TRANS1);

   }
   return;
}
