#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include <cmath>

void Backbone_Defs::DEF_SETTH(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
//
//
// calc theta1, theta2, theta3 for theta4(i)
//
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   double C= deform_params.Uphi(0,0);
   double S= deform_params.Uphi(1,0);

   if      ( Z2[iZ2].CIS==(oR1+2) ){
      aut.C_= std::cos( physics_consts.RAD*( 114.108 ));
      aut.S_= std::sin( physics_consts.RAD*( 114.108 ));
      double Cthe2=( aut.C_*C -aut.T3(0,0))/(aut.S_*S);
      aut.the2[0]= std::acos( Cthe2)/physics_consts.RAD;
      aut.the2[1]=-aut.the2[0];
      double Sthe2= std::sqrt( (1.00) -Cthe2*Cthe2);

      double zP=( aut.S_*C +aut.C_*S*Cthe2);
      double zQ= S*Sthe2;
      double zZ=( zP*zP +zQ*zQ);
      double zU= (zP/zZ);
      double zV= (zQ/zZ);
      double Cthe1=( zU*aut.T3(1,0) +zV*aut.T3(2,0));
      double Sthe1=(-zV*aut.T3(1,0) +zU*aut.T3(2,0));
      aut.the1[0]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;
      zV=-zV;
      Cthe1=( zU*aut.T3(1,0) +zV*aut.T3(2,0));
      Sthe1=(-zV*aut.T3(1,0) +zU*aut.T3(2,0));
      aut.the1[1]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;

      zP=( aut.C_*S +aut.S_*C*Cthe2);
      zQ= aut.S_*Sthe2;
      zZ=( zP*zP +zQ*zQ);
      zU= (zP/zZ);
      zV= (zQ/zZ);
      double Cthe3=(-zU*aut.T3(0,1) +zV*aut.T3(0,2));
      double Sthe3=( zV*aut.T3(0,1) +zU*aut.T3(0,2));
      aut.the3[0]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;
      zV=-zV;
      Cthe3=(-zU*aut.T3(0,1) +zV*aut.T3(0,2));
      Sthe3=( zV*aut.T3(0,1) +zU*aut.T3(0,2));
      aut.the3[1]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;

      aut.the1[0]-=( 106.168 );
      if( aut.the1[0]<(-180.) )aut.the1[0]+=( 360.);
      aut.the1[1]-=( 106.168 );
      if( aut.the1[1]<(-180.) )aut.the1[1]+=( 360.);
      aut.the2[0]-=( -36.930 );
      if( aut.the2[0]>( 180.) )aut.the2[0]-=( 360.);
      aut.the2[1]-=( -36.930 );
      if( aut.the2[1]>( 180.) )aut.the2[1]-=( 360.);

   }else if( Z2[iZ2].CIS==(oR1+3) ){
      aut.C_= std::cos( physics_consts.RAD*( 114.108 ));
      aut.S_= std::sin( physics_consts.RAD*( 114.108 ));
      double Cthe2=( C*aut.C_ -aut.T3(0,0))/(S*aut.S_);
      aut.the2[0]= std::acos( Cthe2)/physics_consts.RAD;
      aut.the2[1]=-aut.the2[0];
      double Sthe2= std::sqrt( (1.00) -Cthe2*Cthe2);

      double zP=( S*aut.C_ +C*aut.S_*Cthe2);
      double zQ= aut.S_*Sthe2;
      double zZ=( zP*zP +zQ*zQ);
      double zU= (zP/zZ);
      double zV= (zQ/zZ);
      double Cthe1=( zU*aut.T3(1,0) +zV*aut.T3(2,0));
      double Sthe1=(-zV*aut.T3(1,0) +zU*aut.T3(2,0));
      aut.the1[0]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;
      zV=-zV;
      Cthe1=( zU*aut.T3(1,0) +zV*aut.T3(2,0));
      Sthe1=(-zV*aut.T3(1,0) +zU*aut.T3(2,0));
      aut.the1[1]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;

      zP=( C*aut.S_ +S*aut.C_*Cthe2);
      zQ= S*Sthe2;
      zZ=( zP*zP +zQ*zQ);
      zU= (zP/zZ);
      zV= (zQ/zZ);
      double Cthe3=(-zU*aut.T3(0,1) +zV*aut.T3(0,2));
      double Sthe3=( zV*aut.T3(0,1) +zU*aut.T3(0,2));
      aut.the3[0]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;
      zV=-zV;
      Cthe3=(-zU*aut.T3(0,1) +zV*aut.T3(0,2));
      Sthe3=( zV*aut.T3(0,1) +zU*aut.T3(0,2));
      aut.the3[1]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;

      aut.the2[0]-=( 106.168 );
      if( aut.the2[0]<(-180.) )aut.the2[0]=+( 360.);
      aut.the2[1]-=( 106.168 );
      if( aut.the2[1]<(-180.) )aut.the2[1]+=( 360.);
      aut.the3[0]-=( -36.930 );
      if( aut.the3[0]>( 180.) )aut.the3[0]-=( 360.);
      aut.the3[1]-=( -36.930 );
      if( aut.the3[1]>( 180.) )aut.the3[1]-=( 360.);

   }else{
      double Cthe2=( C*C -aut.T4(0,0))/(S*S);
      aut.the2[0]= std::acos( Cthe2)/physics_consts.RAD;
      aut.the2[1]=-aut.the2[0];

      double Sthe2= std::sqrt( (1.00) -Cthe2*Cthe2);
      double zP= C*S*( (1.00) +Cthe2);
      double zQ= S*Sthe2;
      double zZ=( zP*zP +zQ*zQ);
      double zU= (zP/zZ);
      double zV= (zQ/zZ);
      double Cthe1=( zU*aut.T4(1,0) +zV*aut.T4(2,0));
      double Sthe1=(-zV*aut.T4(1,0) +zU*aut.T4(2,0));
      aut.the1[0]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;
      double Cthe3=(-zU*aut.T4(0,1) +zV*aut.T4(0,2));
      double Sthe3=( zV*aut.T4(0,1) +zU*aut.T4(0,2));
      aut.the3[0]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;

      zV=-zV;
      Cthe1=( zU*aut.T4(1,0) +zV*aut.T4(2,0));
      Sthe1=(-zV*aut.T4(1,0) +zU*aut.T4(2,0));
      aut.the1[1]= std::atan2(Sthe1,Cthe1)/physics_consts.RAD;
      Cthe3=(-zU*aut.T4(0,1) +zV*aut.T4(0,2));
      Sthe3=( zV*aut.T4(0,1) +zU*aut.T4(0,2));
      aut.the3[1]= std::atan2(Sthe3,Cthe3)/physics_consts.RAD;

   }
   return;
}
