#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Rotation_Matrix.hh"
#include <cmath>

void Backbone_Defs::DEF_SETT4(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
//
//
// set T4
//
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks

   if      ( Z2[iZ2].CIS==(oR1+1) ){
   }else if( Z2[iZ2].CIS==(oR1+2) ){
   }else if( Z2[iZ2].CIS==(oR1+3) ){
   }else if( Z2[iZ2].CIS==(oR1+4) ){
   }else{
      double the= physics_consts.RAD*aut.DISthe4[aut.iDIS];
      double CT= std::cos( the);
      double ST= std::sin( the);
      Rotation_Matrix Rthe;
      Rthe(0,0)= (1.00);
      Rthe(1,0)= (0.00);
      Rthe(2,0)= (0.00);
      Rthe(0,1)= (0.00);
      Rthe(1,1)= CT;
      Rthe(2,1)= ST;
      Rthe(0,2)= (0.00);
      Rthe(1,2)=-ST;
      Rthe(2,2)= CT;

      Rotation_Matrix B= aut.T3*transpose(Rthe);
      aut.T4= B*transpose(deform_params.Uphi);
   }
   return;
}
