#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include <cmath>

void Backbone_Defs::DEF_SETSG(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
//
//
// set mu1, mu2
//
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   double C= deform_params.Uphi(0,0);
   double S= deform_params.Uphi(1,0);

   if      ( Z2[iZ2].CIS==(oR1+2) ){
      aut.mu1= aut.x5(0)/aut.S_;
      aut.mu2= aut.x5(1) -aut.C_*aut.mu1;

   }else if( Z2[iZ2].CIS==(oR1+3) ){
      aut.mu1= aut.x5(0)/S;
      aut.mu2= aut.x5(1) -C*aut.mu1;

   }else{
      aut.mu1= aut.x5(0)/S;
      aut.mu2= aut.x5(1) -C*aut.mu1;

   }
   Coordinates eta,f,g;
   g(0)=(( 1.00) -aut.mu1);
   f(0)=((-1.00) -aut.mu1);
   g(1)=(( 1.00) -aut.mu2)/aut.Zbet;
   f(1)=((-1.00) -aut.mu2)/aut.Zbet;
   g(2)=( aut.x5(2) +(2.00))/aut.Zgam;
   f(2)=( aut.x5(2) -(2.00))/aut.Zgam;
   eta(0)= (0.00);
   eta(1)= aut.bet;
   eta(2)= aut.gam;
//
//
// set the segments of (-180.0,180.0) st conds 1 and 2 hold
//
   aut.nSEG=0;
   if( (g(0)<(-1.00))||(f(0)>( 1.00)) )return;
   if( (g(1)<(-1.00))||(f(1)>( 1.00)) )return;
   if( (g(2)<(-1.00))||(f(2)>( 1.00)) )return;
      int MSUB[3];

      for(int j=0;j<3;j++){
         MSUB[j]=deform_params.S4S4sub( 0,89,j);
      }
      for(int i=0;i<3;i++){
         int ieta=int( std::floor( eta(i) +(360.00)));
         if( g(i)>( 1.00) ){
         }else{
            double z= std::acos( g(i))/physics_consts.RAD;
            int idel=int( std::floor( z))+1;
            if( idel>176 )return;
            int i1=(ieta+1)+idel+3;
            int i2=ieta-idel-3;
            i1=(i1>>2)-45;
            i2=(i2>>2)-45;
            if( i1>89 )i1-=90;
            if( i1< 0 )i1+=90;
            if( i2>89 )i2-=90;
            if( i2< 0 )i2+=90;
            for(int j=0;j<3;j++){
               MSUB[j]&=deform_params.S4S4sub(i1,i2,j);
            }
         }
         if( f(i)<(-1.00) ){
         }else{
            double z= std::acos( f(i))/physics_consts.RAD;
            int idel=int( std::floor( z));
            if( idel<4 )return;
            int i1=(ieta+1)-idel+3;
            int i2=ieta+idel-3;
            i1=(i1>>2)-45;
            i2=(i2>>2)-45;
            if( i1>89 )i1-=90;
            if( i1< 0 )i1+=90;
            if( i2>89 )i2-=90;
            if( i2< 0 )i2+=90;
            for(int j=0;j<3;j++){
               MSUB[j]&=deform_params.S4S4sub(i1,i2,j);
            }
         }
      }

   double psi= (-180.00);
   int M1=0;
   int M2;
   for(int i=0;i<3;i++){
      for(int j= 0;j<30;j++){
         psi+=(4.00);
         M2=(MSUB[i]&1);
         MSUB[i]>>=1;
         if      ( M2>M1 ){
            aut.SEG1[aut.nSEG  ]=( psi -(4.00));
            M1=M2;
         }else if( M2<M1 ){
            aut.SEG2[aut.nSEG++]=( psi -(4.00));
            M1=M2;
         }
      }
   }
   if( M2==1 ){
      aut.SEG2[aut.nSEG++]= (180.00);
   }
   return;
}
