#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"

void Backbone_Defs::DEF_SETPS(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_ENERGY_PARAMS& energy_params,
      const DAT_RESIDUE_MAPPINGS& residue_mappings,
      const DAT_DEFORM_PARAMS& deform_params,
      const DAT_REGION_MAPS& region_maps,
      Output_Streams& out,
      const Structure& str,
      const Search_Subspace& sub,
      const Mechanical_System& mol,
      const Subset_Contracted_System::tM3& con,
      Conf_Dependent_System& dep,
      Energy_Surface4& ene,
      Local_Minimization4& loc,
      int iZ2,int iJ3){
//
//
// find solns of cond 3a for psi4(j)
//
   for(aut.SGN1=( 1.00);aut.SGN1>(-1.01);aut.SGN1-=( 2.00)){
      for(aut.SGN2=( 1.00);aut.SGN2>(-1.01);aut.SGN2-=( 2.00)){
         DEF_ZERO(aut,physics_consts);
         DEF_SORT(aut,
                  physics_consts,energy_params,residue_mappings,deform_params,
                  region_maps,
                  out,str,sub,mol,con,dep,ene,loc,
                  iZ2,iJ3);
      }
   }
   return;
}
