#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <cmath>

class MEM_def_segpt {
private:
   std::vector<double> o_backup_U2chi;  //
   std::vector<double> o_backup_U2uca;  //
   std::vector<double> o_Q1uca;         //
   std::vector<double> o_Q1chi;         //
   std::vector<double> o_Q2uca;         //
   std::vector<double> o_Q2chi;         //
public:
   MEM_def_segpt(int oQ1,int oQ2,int oU2):
      o_backup_U2chi(oU2),
      o_backup_U2uca(oU2),
      o_Q1uca(oQ1),
      o_Q1chi(oQ1),
      o_Q2uca(oQ2),
      o_Q2chi(oQ2)
   {
   }
   double& backup_U2chi(int i){
      return o_backup_U2chi.at( i);  }
   double& backup_U2uca(int i){
      return o_backup_U2uca.at( i);  }
   double& Q1uca(int i){
      return o_Q1uca.at( i);  }
   double& Q1chi(int i){
      return o_Q1chi.at( i);  }
   double& Q2uca(int i){
      return o_Q2uca.at( i);  }
   double& Q2chi(int i){
      return o_Q2chi.at( i);  }
};

void Backbone_Defs::DEF_SEGPT(
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_RESIDUE_MAPPINGS& residue_mappings,
      Output_Streams& out,
      const Search_Subspace& sub,
      const Mechanical_System& mol,
      const Subset_Contracted_System::tM3& con,
      Conf_Dependent_System& dep,
      Energy_Surface4& ene,
      Local_Minimization4& loc,
      int iZ2,int iJ3,int iD1){

   int jR1=Z2[iZ2].CYC;                 //start residue of segment
   int oR1=Z2[iZ2].nR1;                 //number of residues in segment

   int oZ0=mol.nZ0;
   int oQ1=(mol.Z0[oZ0-1].Q1a+mol.Z0[oZ0-1].cQ1);
   int oQ2=(con.Z0[oZ0-1].Q2a+con.Z0[oZ0-1].cQ2);
   int oU2=ene.nU2;
   MEM_def_segpt vv(oQ1,oQ2,oU2);
//
//
// backup control and starting conf of minimization
//
   double backup_EPS1= loc.EPS1;
   double backup_BETA= loc.BETA;
   double backup_BMIN= loc.BMIN;
   double backup_BMAX= loc.BMAX;
   double backup_BET1= loc.BET1;

   for(int iU2= 0;iU2<oU2;iU2++){
      vv.backup_U2chi(iU2)= ene.U2chi(iU2);
      vv.backup_U2uca(iU2)= ene.U2uca(iU2);
   }
//
// restrict space of confs to deformable torsions of segment
// replace starting conf with approximate deformation iD1
//
   double frac= double( 3*(oR1-1))/double( oU2);
   loc.EPS1*=frac;
   double z= std::sqrt( frac);
   loc.BET1*=z;
   loc.BMIN*=z;
   loc.BMAX*=z;

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         vv.Q1uca(iQ1)= (0.00);
         vv.Q1chi(iQ1)= dep.Q1[iQ1].chi;
      }
   }

   int iR1min=jR1;
   int iR1max=(jR1-1+oR1);
   for(int iR1=iR1min;iR1<=iR1max;iR1++){
      if( sub.R1[iR1].bb==0 )continue;
      int jQ1bb=sub.R1[iR1].Q1bb;
      int jQ1sc=sub.R1[iR1].Q1sc;
      int iL0=sub.R1[iR1].L0;
      int mQ0=residue_mappings.L0[iL0].Q0a;
      int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
         int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
         if( BRANCH )continue;
         std::string tor=mol.Q1[jQ1].tor;
         if      ( tor=="OMG" ){
            if( iR1>iR1min ){
               vv.Q1chi(jQ1)= physics_consts.RAD
                          *Z2[iZ2].D1[iD1].R1[iR1-iR1min-1].omg;
               vv.Q1uca(jQ1)= (.10);
            }
         }else if( tor=="PHI" ){
            if( iR1>iR1min ){
               vv.Q1chi(jQ1)= physics_consts.RAD
                          *Z2[iZ2].D1[iD1].R1[iR1-iR1min  ].phi;
               vv.Q1uca(jQ1)= (.50);
            }
         }else if( tor=="PSI" ){
            if( iR1<iR1max ){
               vv.Q1chi(jQ1)= physics_consts.RAD
                          *Z2[iZ2].D1[iD1].R1[iR1-iR1min  ].psi;
               vv.Q1uca(jQ1)= (.50);
            }
         }
      }
   }

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int iQ2=mQ2;
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         if( con.Q1[iQ1].sub ){
            iQ2++;
            vv.Q2chi(iQ2)= vv.Q1chi(iQ1);
            vv.Q2uca(iQ2)= vv.Q1uca(iQ1);
         }
      }
   }

   int iU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         ene.U2uca(iU2++)= (0.00);
         ene.U2uca(iU2++)= (0.00);
         ene.U2uca(iU2++)= (0.00);
         ene.U2uca(iU2++)= (0.00);
         ene.U2uca(iU2++)= (0.00);
         ene.U2uca(iU2++)= (0.00);
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         ene.U2chi(iU2)= vv.Q2chi(iQ2);
         ene.U2uca(iU2)= vv.Q2uca(iQ2);
         iU2++;
      }
   }
//
//
// adjust torsions to exact deformation
//
   loc.MOV0(physics_consts,
            out,sub,mol,con,dep,ene,
            jR1,Z2[iZ2].J3[iJ3].shf1,Z2[iZ2].J3[iJ3].shf2);
   loc.WRT0(out,ene);
//
//
// replace approximate deformation iD1 with exact deformation
//
   iU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( con.Z0[iZ0].sub )iU2+=6;
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         if( con.Q2[iQ2].br==0 ){
            vv.Q2chi(iQ2)= ene.U2chi(iU2);
         }
         iU2++;
      }
   }

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int iQ2=mQ2;
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         if( con.Q1[iQ1].sub ){
            vv.Q1chi(iQ1)= vv.Q2chi(++iQ2);
         }
      }
   }

   iR1min=jR1;
   iR1max=(jR1-1+oR1);
   for(int iR1=iR1min;iR1<=iR1max;iR1++){
      if( sub.R1[iR1].bb==0 )continue;
      int jQ1bb=sub.R1[iR1].Q1bb;
      int jQ1sc=sub.R1[iR1].Q1sc;
      int iL0=sub.R1[iR1].L0;
      int mQ0=residue_mappings.L0[iL0].Q0a;
      int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         int br=residue_mappings.Q0[iQ0].br;
         int jQ1=( br>0 )? ++jQ1sc: ++jQ1bb;
         if( br>0 )continue;
         std::string tor=mol.Q1[jQ1].tor;
         if      ( tor=="OMG" ){
            if( iR1>iR1min ){
               Z2[iZ2].D1[iD1].R1[iR1-iR1min-1].omg= vv.Q1chi(jQ1)
                                                    /physics_consts.RAD;
            }
         }else if( tor=="PHI" ){
            if( iR1>iR1min ){
               Z2[iZ2].D1[iD1].R1[iR1-iR1min  ].phi= vv.Q1chi(jQ1)
                                                    /physics_consts.RAD;
            }
         }else if( tor=="PSI" ){
            if( iR1<iR1max ){
               Z2[iZ2].D1[iD1].R1[iR1-iR1min  ].psi= vv.Q1chi(jQ1)
                                                    /physics_consts.RAD;
            }
         }
      }
   }
//
//
// restore control and starting conf of minimization
//
   loc.EPS1= backup_EPS1;
   loc.BETA= backup_BETA;
   loc.BMIN= backup_BMIN;
   loc.BMAX= backup_BMAX;
   loc.BET1= backup_BET1;

   for(int iU2= 0;iU2<oU2;iU2++){
      ene.U2chi(iU2)= vv.backup_U2chi(iU2);
      ene.U2uca(iU2)= vv.backup_U2uca(iU2);
   }
   return;
}
