#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Rotation_Matrix.hh"
#include <cmath>

void Backbone_Defs::DEF_DISCT(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   double C= deform_params.Uphi(0,0);
   double S= deform_params.Uphi(1,0);

   aut.nDIS=0;
   if      ( Z2[iZ2].CIS==(oR1+1) ){
      Rotation_Matrix B= transpose(deform_params.Rcis)*aut.T3;
      aut.T4= transpose(deform_params.Uphi)*B;
      if( aut.T4(0,0)>( C*C -S*S) )aut.nDIS=1;

   }else if( Z2[iZ2].CIS==(oR1+2) ){
      double f= std::cos( physics_consts.RAD*( (  70.000 ) +( 114.108 )));
      double g= std::cos( physics_consts.RAD*(-(  70.000 ) +( 114.108 )));
      if( (aut.T3(0,0)>f)&&
          (aut.T3(0,0)<g) )aut.nDIS=1;

   }else if( Z2[iZ2].CIS==(oR1+3) ){
      double f= std::cos( physics_consts.RAD*( ( 114.108 ) +(  70.000 )));
      double g= std::cos( physics_consts.RAD*(-( 114.108 ) +(  70.000 )));
      if( (aut.T3(0,0)>f)&&
          (aut.T3(0,0)<g) )aut.nDIS=1;

   }else if( Z2[iZ2].CIS==(oR1+4) ){
      Rotation_Matrix B= aut.T3*transpose(deform_params.Rcis);
      aut.T4= B*transpose(deform_params.Uphi);
      if( aut.T4(0,0)>( C*C -S*S) )aut.nDIS=1;

   }else{
//
//
// calc the range of theta4
//
      double z= std::sqrt( aut.T3(0,1)*aut.T3(0,1)
                          +aut.T3(0,2)*aut.T3(0,2));
      double Calp=-aut.T3(0,1)/z;
      double Salp= aut.T3(0,2)/z;
      double alp= std::atan2(Salp,Calp)/physics_consts.RAD;
      double f=( C*C -S*S -C*aut.T3(0,0))/(S*z);
//
//
// set the discrete values of theta4
//
      double the=-(180.00);
      for(int i= 0;i<18;i++){
         the+=(20.00);
         if( std::cos( physics_consts.RAD*( the -alp))>f ){
            aut.DISthe4[aut.nDIS++]= the;
         }
      }

   }
   return;
}
