#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../def/Def_Automatic.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include <cstdlib>
#include <cmath>

void Backbone_Defs::DEF_DISCP(
      Def_Automatic& aut,
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      int iZ2){
//
//
//  determine the range of psi4
//
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   double C= deform_params.Uphi(0,0);
   double S= deform_params.Uphi(1,0);
   Coordinates d;

   if      ( (Z2[iZ2].CIS==(oR1+1))||(Z2[iZ2].CIS==(oR1+4)) ){
      d(0)=( S +S);
      d(1)=( C +(1.00)
            +std::sqrt( (C*aut.Cthe2)*(C*aut.Cthe2) +aut.Sthe2*aut.Sthe2)
             );
      d(2)=( (2.00)
            +std::sqrt( (C*aut.Sthe2)*(C*aut.Sthe2) +aut.Cthe2*aut.Cthe2)
             );
      aut.mDIS=0;
      if( (std::abs( aut.x5(0))>d(0))||
          (std::abs( aut.x5(1))>d(1))||
          (std::abs( aut.x5(2))>d(2)) ){
         return;
      }else{
         aut.mDIS=1;
      }

   }else if( Z2[iZ2].CIS==(oR1+2) ){
      d(0)=( aut.S_ +S);
      d(1)=( aut.C_ +(1.00)
            +std::sqrt( (C*aut.Cthe2)*(C*aut.Cthe2) +aut.Sthe2*aut.Sthe2)
             );
      d(2)=( (2.00)
            +std::sqrt( (C*aut.Sthe2)*(C*aut.Sthe2) +aut.Cthe2*aut.Cthe2)
             );
      aut.mDIS=0;
      if( (std::abs( aut.x5(0))>d(0))||
          (std::abs( aut.x5(1))>d(1))||
          (std::abs( aut.x5(2))>d(2)) ){
         return;
      }else{
         aut.mDIS=1;
      }

   }else if( Z2[iZ2].CIS==(oR1+3) ){
      d(0)=( S +aut.S_);
      d(1)=( C +(1.00)
            +std::sqrt( (aut.C_*aut.Cthe2)*(aut.C_*aut.Cthe2)
                       +aut.Sthe2*aut.Sthe2)
             );
      d(2)=( (2.00)
            +std::sqrt( (aut.C_*aut.Sthe2)*(aut.C_*aut.Sthe2)
                       +aut.Cthe2*aut.Cthe2)
             );
      aut.mDIS=0;
      if( (std::abs( aut.x5(0))>d(0))||
          (std::abs( aut.x5(1))>d(1))||
          (std::abs( aut.x5(2))>d(2)) ){
         return;
      }else{
         aut.mDIS=1;
      }

   }else{
      Coordinates eta,f,g;
      d(0)=( S +S);
      d(1)=( C +(1.00)
            +std::sqrt( (C*aut.Cthe2)*(C*aut.Cthe2) +aut.Sthe2*aut.Sthe2)
             );
      d(2)=( (2.00)
            +std::sqrt( (C*aut.Sthe2)*(C*aut.Sthe2) +aut.Cthe2*aut.Cthe2)
             );
      f=( aut.x4 -d);
      g=( aut.x4 +d);
      for(int i=0;i<3;i++){
         double q= std::sqrt( aut.B(i,1)*aut.B(i,1) +aut.B(i,2)*aut.B(i,2));
         double Ceta= aut.B(i,1)/q;
         double Seta= aut.B(i,2)/q;
         eta(i)= std::atan2(Seta,Ceta)/physics_consts.RAD;
         f(i)/=q;
         g(i)/=q;
      }
//
//
// set the discrete values of psi4
//
      aut.mDIS=0;
      if( (g(0)<(-1.00))||(f(0)>( 1.00)) )return;
      if( (g(1)<(-1.00))||(f(1)>( 1.00)) )return;
      if( (g(2)<(-1.00))||(f(2)>( 1.00)) )return;
      int MSUB[3];

      for(int j=0;j<3;j++){
         MSUB[j]=deform_params.S4S4sub( 0,89,j);
      }
      for(int i=0;i<3;i++){
         int ieta=int( std::floor( eta(i) +(360.00)));
         if( g(i)>( 1.00) ){
         }else{
            double z= std::acos( g(i))/physics_consts.RAD;
            int idel=int( std::floor( z))+1;
            if( idel>176 )return;
            int i1=(ieta+1)+idel+3;
            int i2=ieta-idel-3;
            i1=(i1>>2)-45;
            i2=(i2>>2)-45;
            if( i1>89 )i1-=90;
            if( i1< 0 )i1+=90;
            if( i2>89 )i2-=90;
            if( i2< 0 )i2+=90;
            for(int j=0;j<3;j++){
               MSUB[j]&=deform_params.S4S4sub(i1,i2,j);
            }
         }
         if( f(i)<(-1.00) ){
         }else{
            double z= std::acos( f(i))/physics_consts.RAD;
            int idel=int( std::floor( z));
            if( idel<4 )return;
            int i1=(ieta+1)-idel+3;
            int i2=ieta+idel-3;
            i1=(i1>>2)-45;
            i2=(i2>>2)-45;
            if( i1>89 )i1-=90;
            if( i1< 0 )i1+=90;
            if( i2>89 )i2-=90;
            if( i2< 0 )i2+=90;
            for(int j=0;j<3;j++){
               MSUB[j]&=deform_params.S4S4sub(i1,i2,j);
            }
         }
      }

      double psi= (-180.00);
      for(int i=0;i<3;i++){
         for(int j=0;j<6;j++){
            psi+=(20.00);
            if( (MSUB[i]&16)>0 ){
               aut.DISps4[aut.mDIS++]= psi;
            }
            MSUB[i]>>=5;
         }
      }

   }
//
//
// params of final equation f(psi3)=0
//
   if      ( Z2[iZ2].CIS==(oR1+2) ){
         aut.Zbet= std::sqrt( std::pow(( aut.C_*(S/aut.S_) +C*aut.Cthe2),2)
                             +(aut.Sthe2)*(aut.Sthe2));
         double Cbet=-( aut.C_*(S/aut.S_) +C*aut.Cthe2)/aut.Zbet;
         double Sbet= aut.Sthe2/aut.Zbet;
         aut.bet= std::atan2(Sbet,Cbet)/physics_consts.RAD;
         aut.Zgam= std::sqrt( (C*aut.Sthe2)*(C*aut.Sthe2)
                             +(aut.Cthe2)*(aut.Cthe2));
         double Cgam= C*aut.Sthe2/aut.Zgam;
         double Sgam= aut.Cthe2/aut.Zgam;
         aut.gam= std::atan2(Sgam,Cgam)/physics_consts.RAD;

   }else if( Z2[iZ2].CIS==(oR1+3) ){
         aut.Zbet= std::sqrt( std::pow(( C*(aut.S_/S) +aut.C_*aut.Cthe2),2)
                             +(aut.Sthe2)*(aut.Sthe2));
         double Cbet=-( C*(aut.S_/S) +aut.C_*aut.Cthe2)/aut.Zbet;
         double Sbet= aut.Sthe2/aut.Zbet;
         aut.bet= std::atan2(Sbet,Cbet)/physics_consts.RAD;
         aut.Zgam= std::sqrt( (aut.C_*aut.Sthe2)*(aut.C_*aut.Sthe2)
                             +(aut.Cthe2)*(aut.Cthe2));
         double Cgam= aut.C_*aut.Sthe2/aut.Zgam;
         double Sgam= aut.Cthe2/aut.Zgam;
         aut.gam= std::atan2(Sgam,Cgam)/physics_consts.RAD;

   }else{
      aut.Zbet= std::sqrt( ( C +C*aut.Cthe2)*( C +C*aut.Cthe2)
                          +aut.Sthe2*aut.Sthe2);
      double Cbet=-( C +C*aut.Cthe2)/aut.Zbet;
      double Sbet= aut.Sthe2/aut.Zbet;
      aut.bet= std::atan2(Sbet,Cbet)/physics_consts.RAD;

      aut.Zgam= std::sqrt( (C*aut.Sthe2)*(C*aut.Sthe2) +aut.Cthe2*aut.Cthe2);
      double Cgam= C*aut.Sthe2/aut.Zgam;
      double Sgam= aut.Cthe2/aut.Zgam;
      aut.gam= std::atan2(Sgam,Cgam)/physics_consts.RAD;

   }
   return;
}
