#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include <vector>
#include <cmath>

class MEM_def_disce {
private:
   int o_R1;                            //
   std::vector<int> o_X3R1C4;           //confs of peptide planes
   std::vector<double> o_X3p;           //probability
   std::vector<double> o_X3d;           //distance from undeformed conf
   std::vector<int> o_R1mC4;            //start conf of peptide plane
   std::vector<int> o_R1nC4;            //end conf of peptide plane
   std::vector<int> o_R1jC4;            //undeformed conf
   std::vector<int> o_R1iC4;            //path through combined confs
   std::vector<double> o_R1C4z;         //sum over partial paths
   std::vector<double> o_R1q;           //product over partial path
   std::vector<double> o_R1d;           //distance from undeformed conf
public:
   MEM_def_disce(int o):
      o_R1(o),
      o_X3R1C4(2048*o),
      o_X3p(2048),
      o_X3d(2048),
      o_R1mC4(o),
      o_R1nC4(o),
      o_R1jC4(o),
      o_R1iC4(o),
      o_R1C4z(o*60),
      o_R1q(o),
      o_R1d(o)
   {
   }
   int& X3R1C4(int i,int j){
      return o_X3R1C4.at( i*o_R1 +j);  }
   double& X3p(int i){
      return o_X3p.at( i);  }
   double& X3d(int i){
      return o_X3d.at( i);  }
   int& R1mC4(int i){
      return o_R1mC4.at( i);  }
   int& R1nC4(int i){
      return o_R1nC4.at( i);  }
   int& R1jC4(int i){
      return o_R1jC4.at( i);  }
   int& R1iC4(int i){
      return o_R1iC4.at( i);  }
   double& R1C4z(int i,int j){
      return o_R1C4z.at( i*60 +j);  }
   double& R1q(int i){
      return o_R1q.at( i);  }
   double& R1d(int i){
      return o_R1d.at( i);  }
};

void Backbone_Defs::DEF_DISCE(
      Def_Automatic& aut,
      const DAT_RESIDUE_MAPPINGS& residue_mappings,
      const DAT_DEFORM_PARAMS& deform_params,
      const Search_Subspace& sub,
      int iZ2){
//
//
// set the discrete values of the confs of the terminal blocks
//
   int jR1=Z2[iZ2].CYC;                 //start residue of segment
   int oR1=(Z2[iZ2].nR1-5)/2;           //number of residues in terminal blocks
   MEM_def_disce vv(oR1);
   if( oR1==0 ){
      aut.nV1=1;
      aut.nV2=1;
      return;
   }
   int oX3=2048;                        //maximum number of discrete confs

   double RRc= ( 2*oR1)*( oR1 +2)*( oR1 +2);
//
//
// N-terminal block
//
   for(int iX3= 0;iX3<oX3;iX3++){
      for(int aR1= 0;aR1<oR1;aR1++){
         vv.X3R1C4(iX3  ,aR1)=-1;
      }
      vv.X3p(iX3)= (0.00);
      vv.X3d(iX3)= (0.00);
   }

   double zN= (1.00);
   for(int aR1= 0;aR1<oR1;aR1++){
      vv.R1jC4(aR1)=Z2[iZ2].R1[ 1+aR1].C4;
      int iL0=sub.R1[jR1+1+aR1].L0;
      int iG4=residue_mappings.L0[iL0].G4;
      vv.R1mC4(aR1)=deform_params.G4[iG4].mC4;
      vv.R1nC4(aR1)=deform_params.G4[iG4].nC4;
      zN*=(vv.R1nC4(aR1)-vv.R1mC4(aR1)+1);
   }

   for(int iC4=vv.R1mC4(oR1-1);iC4<=vv.R1nC4(oR1-1);iC4++){
      vv.R1C4z(oR1-1,iC4)= deform_params.C4C4p(iC4, 0);
   }
   for(int aR1=(oR1-2);aR1>=0;aR1--){
      for(int iC4=vv.R1mC4(aR1  );iC4<=vv.R1nC4(aR1  );iC4++){
         vv.R1C4z(aR1  ,iC4)= (0.00);
         for(int jC4=vv.R1mC4(aR1+1);jC4<=vv.R1nC4(aR1+1);jC4++){
            vv.R1C4z(aR1  ,iC4)+=
                deform_params.C4C4p(iC4,jC4)*vv.R1C4z(aR1+1,jC4);
         }
      }
   }
   double zZ= (0.00);
   for(int jC4=vv.R1mC4( 0);jC4<=vv.R1nC4( 0);jC4++){
      zZ+=deform_params.C4C4p( 0,jC4)*vv.R1C4z(  0  ,jC4);
   }
   zZ*=std::exp( -( 10 +2*oR1)*std::log( (2.00)));

   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
   }
   int iR1= 0;
   for(;;){
      vv.R1iC4(iR1)++;
      if( vv.R1iC4(iR1)>vv.R1nC4(iR1) ){
         if( iR1== 0 ){
            break;
         }else{
            vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
            iR1--;
            continue;
         }

      }else{
         if( iR1== 0 ){
            vv.R1q(iR1  )= deform_params.C4C4p( 0,vv.R1iC4(iR1  ));
            vv.R1d(iR1  )= deform_params.C4C4d(vv.R1iC4(iR1  ),vv.R1jC4(iR1  ));
         }else{
            vv.R1q(iR1  )= vv.R1q(iR1-1)
                       *deform_params.C4C4p(vv.R1iC4(iR1-1),vv.R1iC4(iR1  ));
            vv.R1d(iR1  )= vv.R1d(iR1-1)
                       +deform_params.C4C4d(vv.R1iC4(iR1  ),vv.R1jC4(iR1  ));
         }
         if( vv.R1q(iR1  )*vv.R1C4z(iR1  ,vv.R1iC4(iR1  ))<zZ )continue;
         if( iR1==(oR1-1) ){
            double RRa= RRc
               *std::exp( (.40)*std::log( (1.00e-8) +(vv.R1d(oR1-1)/RRc)));

            bool DEGENERATE=false;
            for(int iX3= 0;(iX3<oX3)&&!DEGENERATE;iX3++){
               if( vv.X3p(iX3)<=(0.00) )break;
               double RRb=( vv.X3d(iX3)<RRa )? vv.X3d(iX3): RRa;
               double RR= (0.00);
               for(int aR1= 0;aR1<oR1;aR1++){
                  RR+=deform_params.C4C4d(vv.R1iC4(aR1),vv.X3R1C4(iX3  ,aR1));
               }
               if( RR<RRb )DEGENERATE=true;
            }
            if( DEGENERATE )continue;

            for(int aR1= 0;aR1<oR1;aR1++){
               vv.X3R1C4(oX3-1  ,aR1)=vv.R1iC4(aR1);
            }
            vv.X3p(oX3-1)= vv.R1q(oR1-1)*vv.R1C4z(oR1-1,vv.R1iC4(oR1-1));
            vv.X3d(oX3-1)= RRa;
            for(int iX3=(oX3-1);iX3>0;iX3--){
               if( vv.X3p(iX3)<=vv.X3p(iX3-1) )break;
               for(int aR1= 0;aR1<oR1;aR1++){
                  int j=vv.X3R1C4(iX3-1,aR1);
                  vv.X3R1C4(iX3-1,aR1)=vv.X3R1C4(iX3  ,aR1);
                  vv.X3R1C4(iX3  ,aR1)=j;
               }
               double z= vv.X3p(iX3-1);
               vv.X3p(iX3-1)= vv.X3p(iX3);
               vv.X3p(iX3)= z;
               z= vv.X3d(iX3-1);
               vv.X3d(iX3-1)= vv.X3d(iX3);
               vv.X3d(iX3)= z;
            }
            if( vv.X3p(oX3-1)>zZ )zZ= vv.X3p(oX3-1);

         }else{
            iR1++;
         }

      }
   }

   int nX3=oX3;
   while( (nX3>0)&&(vv.X3p(nX3-1)<=(0.00)) ){
      nX3--;
   }
   for(int iX3= 0;iX3<nX3;iX3++){
      for(int aR1= 0;aR1<oR1;aR1++){
         int iC4=vv.X3R1C4(iX3  ,aR1);
         aut.o_V1R1psi.push_back( deform_params.C4[iC4].psi);
         aut.o_V1R1phi.push_back( deform_params.C4[iC4].phi);
      }
   }
   aut.nV1=( nX3<=int( std::pow(2.00,6+oR1)) )? nX3: int( std::pow(2.00,6+oR1));
//
//
// C-terminal block
//
   for(int iX3= 0;iX3<oX3;iX3++){
      for(int aR1= 0;aR1<oR1;aR1++){
         vv.X3R1C4(iX3  ,aR1)=-1;
      }
      vv.X3p(iX3)= (0.00);
      vv.X3d(iX3)= (0.00);
   }

   zN= (1.00);
   for(int aR1= 0;aR1<oR1;aR1++){
      vv.R1jC4(aR1)=Z2[iZ2].R1[Z2[iZ2].nR1-1-aR1].C4;
      int iL0=sub.R1[jR1-1+Z2[iZ2].nR1-aR1].L0;
      int iG4=residue_mappings.L0[iL0].G4;
      vv.R1mC4(aR1)=deform_params.G4[iG4].mC4;
      vv.R1nC4(aR1)=deform_params.G4[iG4].nC4;
      zN*=(vv.R1nC4(aR1)-vv.R1mC4(aR1)+1);
   }

   for(int iC4=vv.R1mC4(oR1-1);iC4<=vv.R1nC4(oR1-1);iC4++){
      vv.R1C4z(oR1-1,iC4)= deform_params.C4C4p( 0,iC4);
   }
   for(int aR1=(oR1-2);aR1>=0;aR1--){
      for(int iC4=vv.R1mC4(aR1  );iC4<=vv.R1nC4(aR1  );iC4++){
         vv.R1C4z(aR1  ,iC4)= (0.00);
         for(int jC4=vv.R1mC4(aR1+1);jC4<=vv.R1nC4(aR1+1);jC4++){
            vv.R1C4z(aR1  ,iC4)+=
                deform_params.C4C4p(jC4,iC4)*vv.R1C4z(aR1+1,jC4);
         }
      }
   }
   zZ= (0.00);
   for(int jC4=vv.R1mC4( 0);jC4<=vv.R1nC4( 0);jC4++){
      zZ+=deform_params.C4C4p(jC4, 0)*vv.R1C4z(  0  ,jC4);
   }
   zZ*=std::exp( -( 10 +2*oR1)*std::log( (2.00)));

   for(int iR1= 0;iR1<oR1;iR1++){
      vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
   }
   iR1= 0;
   for(;;){
      vv.R1iC4(iR1)++;
      if( vv.R1iC4(iR1)>vv.R1nC4(iR1) ){
         if( iR1== 0 ){
            break;
         }else{
            vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
            iR1--;
            continue;
         }

      }else{
         if( iR1== 0 ){
            vv.R1q(iR1  )= deform_params.C4C4p(vv.R1iC4(iR1  ), 0);
            vv.R1d(iR1  )= deform_params.C4C4d(vv.R1iC4(iR1  ),vv.R1jC4(iR1  ));
         }else{
            vv.R1q(iR1  )= vv.R1q(iR1-1)
                       *deform_params.C4C4p(vv.R1iC4(iR1  ),vv.R1iC4(iR1-1));
            vv.R1d(iR1  )= vv.R1d(iR1-1)
                       +deform_params.C4C4d(vv.R1iC4(iR1  ),vv.R1jC4(iR1  ));
         }
         if( vv.R1C4z(iR1  ,vv.R1iC4(iR1  ))*vv.R1q(iR1  )<zZ )continue;
         if( iR1==(oR1-1) ){
            double RRa= RRc
               *std::exp( (.40)*std::log( (1.00e-8) +(vv.R1d(oR1-1)/RRc)));

            bool DEGENERATE=false;
            for(int iX3= 0;(iX3<oX3)&&!DEGENERATE;iX3++){
               if( vv.X3p(iX3)<=(0.00) )break;
               double RRb=( vv.X3d(iX3)<RRa )? vv.X3d(iX3): RRa;
               double RR= (0.00);
               for(int aR1= 0;aR1<oR1;aR1++){
                  RR+=deform_params.C4C4d(vv.R1iC4(aR1),vv.X3R1C4(iX3  ,aR1));
               }
               if( RR<RRb )DEGENERATE=true;
            }
            if( DEGENERATE )continue;

            for(int aR1= 0;aR1<oR1;aR1++){
               vv.X3R1C4(oX3-1,aR1)=vv.R1iC4(aR1);
            }
            vv.X3p(oX3-1)= vv.R1C4z(oR1-1,vv.R1iC4(oR1-1))*vv.R1q(oR1-1);
            vv.X3d(oX3-1)= RRa;
            for(int iX3=(oX3-1);iX3>0;iX3--){
               if( vv.X3p(iX3)<=vv.X3p(iX3-1) )break;
               for(int aR1= 0;aR1<oR1;aR1++){
                  int j=vv.X3R1C4(iX3-1,aR1);
                  vv.X3R1C4(iX3-1,aR1)=vv.X3R1C4(iX3  ,aR1);
                  vv.X3R1C4(iX3  ,aR1)=j;
               }
               double z= vv.X3p(iX3-1);
               vv.X3p(iX3-1)= vv.X3p(iX3);
               vv.X3p(iX3)= z;
               z= vv.X3d(iX3-1);
               vv.X3d(iX3-1)= vv.X3d(iX3);
               vv.X3d(iX3)= z;
            }
            if( vv.X3p(oX3-1)>zZ )zZ= vv.X3p(oX3-1);

         }else{
            iR1++;
         }

      }
   }

   nX3=oX3;
   while( (nX3>0)&&(vv.X3p(nX3-1)<=(0.00)) ){
      nX3--;
   }
   for(int iX3= 0;iX3<nX3;iX3++){
      for(int aR1= 0;aR1<oR1;aR1++){
         int iC4=vv.X3R1C4(iX3  ,aR1);
         aut.o_V2R1psi.push_back( deform_params.C4[iC4].psi);
         aut.o_V2R1phi.push_back( deform_params.C4[iC4].phi);
      }
   }
   aut.nV2=( nX3<=int( std::pow(2.00,6+oR1)) )? nX3: int( std::pow(2.00,6+oR1));

   return;
}
